/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.rc;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public class RCSupportPlugin
extends Plugin {
    private static RCSupportPlugin plugin;
    private HashSet mySynchronizedMetaclasses;
    public static final String EXT_POINT_SYNCH_METACLASSES = "synchronizedMetaclass";
    public static final String ATTR_METACLASS = "metaclass";

    public RCSupportPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
    }

    public void startup() throws CoreException {
        plugin = this;
        this.loadSynchronizedCollectionMetaclasses();
    }

    public void shutdown() throws CoreException {
        plugin = null;
    }

    public static RCSupportPlugin getDefault() {
        return plugin;
    }

    public boolean shouldBeSynchronized(String referenceCollectionMetaclass) {
        return this.mySynchronizedMetaclasses.contains(referenceCollectionMetaclass);
    }

    private void loadSynchronizedCollectionMetaclasses() {
        this.mySynchronizedMetaclasses = new HashSet();
        IExtensionPoint point = this.getDescriptor().getExtensionPoint(EXT_POINT_SYNCH_METACLASSES);
        IExtension[] metaclasses = point.getExtensions();
        int i = 0;
        while (i < metaclasses.length) {
            IConfigurationElement[] elements = metaclasses[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                String metaclass = element.getAttribute(ATTR_METACLASS);
                if (metaclass != null) {
                    this.mySynchronizedMetaclasses.add(metaclass);
                }
                ++j;
            }
            ++i;
        }
    }
}

