/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.rc;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.rc.AbstractChildReferencesRule;
import com.tssap.selena.model.providers.rc.IChildReferencesFilter;
import com.tssap.selena.model.providers.rc.IChildReferencesRule;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.enum.FilterEnumeration;
import com.tssap.selena.model.util.function.UnaryOperation;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;

public class ExcludingChildrenRuleAdapter
extends AbstractChildReferencesRule
implements IChildReferencesRule {
    private IChildReferencesFilter myFilter;

    public ExcludingChildrenRuleAdapter(IChildReferencesFilter filter) {
        this.myFilter = filter;
    }

    public UniqueNameEnumeration childReferencedEntities(ReferenceContainer container) {
        Entity correspondingEntity = AbstractChildReferencesRule.getCorrespondingEntity(container);
        if (correspondingEntity == null) {
            System.err.println("corresponding entity == null for : " + container);
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        FilterEnumeration childrenWithoutExcluded = new FilterEnumeration((Enumeration)correspondingEntity.children(), new UnaryOperation(){

            public Object execute(Object curObject) {
                Entity curChild = (Entity)curObject;
                if (ExcludingChildrenRuleAdapter.this.myFilter.shouldBeExcluded(curChild)) {
                    return null;
                }
                return curChild;
            }
        });
        return AbstractChildReferencesRule.toUinEnumeration((Enumeration)childrenWithoutExcluded);
    }

    public ModelDeltaNode getReferencedEntitiesDelta(ReferenceCollection collection, ModelDeltaNode rootDelta) {
        if (collection.isDeleted()) {
            return null;
        }
        Entity diagramNode = collection.getParent();
        if (diagramNode == null || diagramNode.isDeleted()) {
            return null;
        }
        ModelDeltaNode diagramNodeDelta = AbstractChildReferencesRule.findDeltaNode(rootDelta, diagramNode.getUniqueName());
        if (diagramNodeDelta != null) {
            ExcludingModelDelta result = new ExcludingModelDelta(diagramNodeDelta);
            return result;
        }
        if (rootDelta.isTotallyChanged()) {
            return new TotallyChangedDelta(diagramNode);
        }
        return null;
    }

    private class ExcludingModelDelta
    implements ModelDeltaNode {
        private ModelDeltaNode myOriginalDeltaNode;

        public ExcludingModelDelta(ModelDeltaNode originalDeltaNode) {
            this.myOriginalDeltaNode = originalDeltaNode;
        }

        public boolean isNew() {
            return this.myOriginalDeltaNode.isNew();
        }

        public boolean isDeleted() {
            return this.myOriginalDeltaNode.isDeleted();
        }

        public boolean isChanged() {
            return this.myOriginalDeltaNode.isChanged();
        }

        public Element getElement() {
            return this.myOriginalDeltaNode.getElement();
        }

        public UniqueName getElementUniqueName() {
            return this.myOriginalDeltaNode.getElementUniqueName();
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myOriginalDeltaNode.getOriginalElementUniqueName();
        }

        public boolean isEmpty() {
            return this.myOriginalDeltaNode.isEmpty();
        }

        public boolean isTotallyChanged() {
            return this.myOriginalDeltaNode.isTotallyChanged();
        }

        public Enumeration changedChildren() {
            if (this.myOriginalDeltaNode == null) {
                return EmptyEnumeration.getEnumeration();
            }
            LinkedList<ExcludingModelDelta> filteredSubDeltas = new LinkedList<ExcludingModelDelta>();
            Enumeration allSubDeltas = this.myOriginalDeltaNode.changedChildren();
            while (allSubDeltas.hasMoreElements()) {
                ModelDeltaNode curSubDelta = (ModelDeltaNode)allSubDeltas.nextElement();
                if (!curSubDelta.isDeleted()) {
                    Entity curNewChild = (Entity)curSubDelta.getElement();
                    if (curNewChild == null) {
                        System.err.println("Delta contains new Element which can not be found: " + curSubDelta.getElementUniqueName());
                        continue;
                    }
                    if (ExcludingChildrenRuleAdapter.this.myFilter.shouldBeExcluded(curNewChild)) continue;
                }
                filteredSubDeltas.add(new ExcludingModelDelta(curSubDelta));
            }
            return Collections.enumeration(filteredSubDeltas);
        }
    }

    private class TotallyChangedDelta
    implements ModelDeltaNode {
        private UniqueName myNodeUin;
        private UniqueName myModelUin;

        public TotallyChangedDelta(Entity diagramNode) {
            this.myNodeUin = diagramNode.getUniqueName();
            this.myModelUin = diagramNode.getModel().getUniqueName();
        }

        public boolean isTotallyChanged() {
            return true;
        }

        public Enumeration changedChildren() {
            return EmptyEnumeration.getEnumeration();
        }

        public UniqueName getElementUniqueName() {
            return this.myNodeUin;
        }

        public Element getElement() {
            Model model = ModelAccess.getModel((UniqueName)this.myModelUin);
            return model == null ? null : model.findEntity(this.myNodeUin);
        }

        public boolean isNew() {
            return false;
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isChanged() {
            return false;
        }

        public UniqueName getOriginalElementUniqueName() {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

