/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.rules;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.rc.AbstractChildReferencesRule;
import com.tssap.selena.model.providers.rc.IChildReferencesRule;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.TotalUpdateDeltaNode;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class UMLDiagramsRule
extends AbstractChildReferencesRule
implements IChildReferencesRule {
    public UniqueNameEnumeration childReferencedEntities(ReferenceContainer container) {
        if (container instanceof ReferenceCollection) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        Entity correspondingEntity = ((Reference)container).getEntity();
        return AbstractChildReferencesRule.toUinEnumeration((Enumeration)correspondingEntity.childEntities());
    }

    public ModelDeltaNode getReferencedEntitiesDelta(ReferenceCollection collection, ModelDeltaNode rootDelta) {
        Entity diagramNode = collection.getParent();
        ModelDeltaNode diagramNodeDelta = AbstractChildReferencesRule.findDeltaNode(rootDelta, diagramNode.getUniqueName());
        if (diagramNodeDelta == null) {
            return null;
        }
        UMLRuleDelta result = new UMLRuleDelta(collection, diagramNodeDelta);
        return result;
    }

    private class UMLRuleDelta
    implements ModelDeltaNode {
        private ModelDeltaNode myOriginalDeltaNode;
        private Set myTopLevelEntityUins = new HashSet();

        public UMLRuleDelta(ReferenceCollection collection, ModelDeltaNode originalDiagramNodeDelta) {
            this.myOriginalDeltaNode = originalDiagramNodeDelta;
            this.myTopLevelEntityUins = new HashSet();
            ReferenceEnumeration topLevelReferences = collection.references();
            while (topLevelReferences.hasMoreElements()) {
                Reference next = topLevelReferences.next();
                ReferenceUniqueName referenceUin = (ReferenceUniqueName)next.getUniqueName();
                this.myTopLevelEntityUins.add(referenceUin.getReferencedUniqueName());
            }
        }

        public boolean isNew() {
            return this.myOriginalDeltaNode.isNew();
        }

        public boolean isDeleted() {
            return this.myOriginalDeltaNode.isDeleted();
        }

        public boolean isChanged() {
            return this.myOriginalDeltaNode.isChanged();
        }

        public Element getElement() {
            return this.myOriginalDeltaNode.getElement();
        }

        public UniqueName getElementUniqueName() {
            return this.myOriginalDeltaNode.getElementUniqueName();
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myOriginalDeltaNode.getOriginalElementUniqueName();
        }

        public boolean isEmpty() {
            return this.myOriginalDeltaNode.isEmpty();
        }

        public boolean isTotallyChanged() {
            return this.myOriginalDeltaNode.isTotallyChanged();
        }

        public Enumeration changedChildren() {
            LinkedList<Object> filteredSubDeltas = new LinkedList<Object>();
            Enumeration allSubDeltas = this.myOriginalDeltaNode.changedChildren();
            while (allSubDeltas.hasMoreElements()) {
                UniqueName newDefDiagramUin;
                String newDefDiagramUinAsString;
                Element newElement;
                ModelDeltaNode curSubDelta = (ModelDeltaNode)allSubDeltas.nextElement();
                UniqueName curSubDeltaUin = curSubDelta.getElementUniqueName();
                if (curSubDelta.isDeleted() && curSubDelta.getOriginalElementUniqueName() != null && !curSubDelta.getOriginalElementUniqueName().equals(curSubDelta.getElementUniqueName())) continue;
                if (curSubDelta.isNew() && curSubDelta.getOriginalElementUniqueName() != null && !curSubDelta.getOriginalElementUniqueName().equals(curSubDeltaUin) && (newElement = curSubDelta.getElement()) != null && newElement.hasPropertyValue("$metaclass", "Package") && (newDefDiagramUinAsString = newElement.getPropertyValue("DiagramUIN")) != null && (newDefDiagramUin = ModelAccess.createUniqueName((String)newDefDiagramUinAsString)) != null && this.myTopLevelEntityUins.contains(newDefDiagramUin)) {
                    TotalUpdateDeltaNode substitutedDelta = new TotalUpdateDeltaNode(newElement.getModel(), newDefDiagramUin);
                    substitutedDelta.setTotalUpdateRequired();
                    filteredSubDeltas.add(substitutedDelta);
                    continue;
                }
                if (!this.myTopLevelEntityUins.contains(curSubDeltaUin)) continue;
                filteredSubDeltas.add(curSubDelta);
            }
            return Collections.enumeration(filteredSubDeltas);
        }
    }
}

