/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.rules;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.providers.internal.rc.delta.AbstractModelDeltaNodeAdapter;
import com.tssap.selena.model.providers.internal.rc.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.providers.internal.rc.rules.DeltaMerger;
import com.tssap.selena.model.providers.rc.AbstractChildReferencesRule;
import com.tssap.selena.model.providers.rc.IChildReferencesRule;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class SubstitutePackageByReferenceCollectionRule
extends AbstractChildReferencesRule
implements IChildReferencesRule {
    private static SubstitutedPackagesCache ourSubstitutedPackagesCache = new SubstitutedPackagesCache();
    private static final UniqueNameEnumeration EMPTY = EmptyEnumeration.getUniqueNameEnumeration();
    private static final Collection SUBSTITUTIBLE_METACLASSES = new HashSet<String>(Arrays.asList("Package", "com.tssap.j2ee.core.ear.EnterpriseApp", "com.tssap.j2ee.core.ejbjar.EjbJar", "com.tssap.j2ee.core.webapp.WebApp", "com.tssap.j2ee.core.web.WebContent"));

    public UniqueNameEnumeration childReferencedEntities(ReferenceContainer container) {
        if (container instanceof ReferenceCollection) {
            LinkedList<UniqueName> result = new LinkedList<UniqueName>();
            UniqueName collectionUin = ((ReferenceCollection)container).getUniqueName();
            Entity diagramNode = ((ReferenceCollection)container).getParent();
            if (diagramNode == null) {
                return EMPTY;
            }
            EntityEnumeration children = diagramNode.childEntities();
            while (children.hasMoreElements()) {
                Entity curChild = children.next();
                UniqueName diagramUin = this.substitute(collectionUin, curChild);
                if (diagramUin == null) continue;
                result.add(diagramUin);
            }
            return EnumerationConverter.toUniqueNameEnumeration(result.iterator());
        }
        if (container instanceof Reference) {
            ReferenceCollection substitutedRC;
            UniqueName substituted;
            ReferenceCollection parentRC = (ReferenceCollection)((Reference)container).getParent();
            Entity referenceEntity = ((Reference)container).getEntity();
            if (referenceEntity != null && (substituted = this.substitute(parentRC.getUniqueName(), referenceEntity)) != null && (substitutedRC = parentRC.getModel().findReferenceCollection(substituted)) != null) {
                return AbstractChildReferencesRule.toUinEnumeration((Enumeration)substitutedRC.childEntities());
            }
        }
        return EMPTY;
    }

    private UniqueName substitute(UniqueName collectionUin, Entity pakkage) {
        String diagramUinAsString;
        String metaclass;
        UniqueName result = ourSubstitutedPackagesCache.get(collectionUin, pakkage.getUniqueName());
        if (result != null) {
            return result;
        }
        if (!(pakkage instanceof ReferenceCollection) && SUBSTITUTIBLE_METACLASSES.contains(metaclass = pakkage.getPropertyValue("$metaclass")) && (diagramUinAsString = pakkage.getPropertyValue("DiagramUIN")) != null) {
            result = ModelAccess.createUniqueName((String)diagramUinAsString);
            ourSubstitutedPackagesCache.put(collectionUin, pakkage.getUniqueName(), result);
        }
        return result;
    }

    public ModelDeltaNode getReferencedEntitiesDelta(ReferenceCollection collection, ModelDeltaNode rootDelta) {
        UniqueName collectionUin = collection.getUniqueName();
        Entity diagramNode = collection.getParent();
        ModelDeltaNode diagramNodeDelta = AbstractChildReferencesRule.findDeltaNode(rootDelta, diagramNode.getUniqueName());
        if (diagramNodeDelta == null) {
            return null;
        }
        MyDeltaNode result = new MyDeltaNode(collection.getModel(), diagramNodeDelta);
        Enumeration originalSubDeltas = diagramNodeDelta.changedChildren();
        while (originalSubDeltas.hasMoreElements()) {
            ModelDeltaNode curSubDelta = (ModelDeltaNode)originalSubDeltas.nextElement();
            ModelDeltaNodeKind kind = AbstractModelDeltaNodeAdapter.getChangesKind(curSubDelta);
            UniqueName curChangedUin = curSubDelta.getElementUniqueName();
            UniqueName curSubstitutedUin = null;
            if (kind.isDeleted()) {
                curSubstitutedUin = ourSubstitutedPackagesCache.remove(collectionUin, curChangedUin);
            } else {
                Element curChangedElement;
                curSubstitutedUin = ourSubstitutedPackagesCache.get(collection.getUniqueName(), curChangedUin);
                if (curSubstitutedUin == null && (curChangedElement = curSubDelta.getElement()) instanceof Entity) {
                    curSubstitutedUin = this.substitute(collectionUin, (Entity)curChangedElement);
                }
            }
            if (curSubstitutedUin == null) continue;
            if (kind == ModelDeltaNodeKind.CONNECTION) {
                Enumeration deepChildren = curSubDelta.changedChildren();
                while (deepChildren.hasMoreElements()) {
                    ModelDeltaNode curDeepDelta = (ModelDeltaNode)deepChildren.nextElement();
                    if (!curSubstitutedUin.equals(curDeepDelta.getElementUniqueName())) continue;
                    kind = AbstractModelDeltaNodeAdapter.getChangesKind(curDeepDelta);
                    break;
                }
            }
            if (kind == ModelDeltaNodeKind.CONNECTION) continue;
            result.addSubDelta(curSubstitutedUin, kind, curSubDelta);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.isEmpty() ? null : result;
    }

    public void startListening(ReferenceCollection collection) {
    }

    public void stopListening(ReferenceCollection collection) {
    }

    private static class SubstitutedPackagesCache {
        private HashMap myCollectionsMaps = new HashMap();

        private SubstitutedPackagesCache() {
        }

        public void put(UniqueName collectionUin, UniqueName packageUin, UniqueName diagramUin) {
            UniqueName alreadyCached;
            Assert.isLegal((collectionUin != null ? 1 : 0) != 0);
            Assert.isLegal((packageUin != null ? 1 : 0) != 0);
            Assert.isLegal((diagramUin != null ? 1 : 0) != 0);
            HashMap<UniqueName, UniqueName> substitutionMap = (HashMap<UniqueName, UniqueName>)this.myCollectionsMaps.get(collectionUin);
            if (substitutionMap == null) {
                substitutionMap = new HashMap<UniqueName, UniqueName>();
                this.myCollectionsMaps.put(collectionUin, substitutionMap);
            }
            if ((alreadyCached = (UniqueName)substitutionMap.get(packageUin)) != null) {
                Assert.isLegal((boolean)alreadyCached.equals(diagramUin));
                return;
            }
            substitutionMap.put(packageUin, diagramUin);
        }

        public UniqueName get(UniqueName collectionUin, UniqueName packageUin) {
            Assert.isLegal((collectionUin != null ? 1 : 0) != 0);
            Assert.isLegal((packageUin != null ? 1 : 0) != 0);
            HashMap substitutionMap = (HashMap)this.myCollectionsMaps.get(collectionUin);
            if (substitutionMap == null) {
                return null;
            }
            return (UniqueName)substitutionMap.get(packageUin);
        }

        public boolean containsKey(UniqueName collectionUin) {
            return this.myCollectionsMaps.containsKey(collectionUin);
        }

        public UniqueName remove(UniqueName collectionUin, UniqueName packageUin) {
            Assert.isLegal((collectionUin != null ? 1 : 0) != 0);
            Assert.isLegal((packageUin != null ? 1 : 0) != 0);
            HashMap substitutionMap = (HashMap)this.myCollectionsMaps.get(collectionUin);
            if (substitutionMap == null) {
                return null;
            }
            return (UniqueName)substitutionMap.remove(packageUin);
        }

        public void removeAll(UniqueName collectionUin) {
            Assert.isLegal((collectionUin != null ? 1 : 0) != 0);
            this.myCollectionsMaps.remove(collectionUin);
        }
    }

    private class MyDeltaNode
    extends AbstractModelDeltaNodeAdapter
    implements ModelDeltaNode {
        private HashMap mySubDeltas = new HashMap();
        private ModelDeltaNode myOriginalDelta;

        public MyDeltaNode(Model model, ModelDeltaNode diagramNodeDelta) {
            super(model, AbstractModelDeltaNodeAdapter.getChangesKind(diagramNodeDelta));
            this.myOriginalDelta = diagramNodeDelta;
        }

        public void addSubDelta(final UniqueName uin, ModelDeltaNodeKind kind, final ModelDeltaNode substitutedDelta) {
            if (this.mySubDeltas.containsKey(uin)) {
                kind = ModelDeltaNodeKind.TOTALLY_CHANGED;
            }
            AbstractModelDeltaNodeAdapter deltaToAdd = new AbstractModelDeltaNodeAdapter(this.getModel(), kind){

                public Enumeration changedChildren() {
                    return substitutedDelta == null ? EMPTY : substitutedDelta.changedChildren();
                }

                public Element getElement() {
                    return this.getModel().findElement(uin);
                }

                public UniqueName getElementUniqueName() {
                    return uin;
                }

                public boolean isEmpty() {
                    return false;
                }
            };
            ModelDeltaNode merged = DeltaMerger.mergeWithChild(deltaToAdd, uin, this.getModel());
            this.mySubDeltas.put(uin, merged);
        }

        public boolean isEmpty() {
            return this.mySubDeltas.isEmpty();
        }

        public Element getElement() {
            return this.myOriginalDelta.getElement();
        }

        public UniqueName getElementUniqueName() {
            return this.myOriginalDelta.getElementUniqueName();
        }

        public Enumeration changedChildren() {
            return Collections.enumeration(this.mySubDeltas.values());
        }
    }
}

