/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.rules;

import com.tssap.selena.model.providers.internal.rc.rules.CompositeRule;
import com.tssap.selena.model.providers.internal.rc.rules.PackageDiagramRule;
import com.tssap.selena.model.providers.internal.rc.rules.SubstitutePackageByReferenceCollectionRule;
import com.tssap.selena.model.providers.internal.rc.rules.UMLDiagramsRule;
import com.tssap.selena.model.providers.rc.IChildReferencesRule;
import com.tssap.selena.model.providers.rc.RCSupportPlugin;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class RuleManager {
    public static final String EXT_POINT_REFERENCE_COLLECTION_RULE = "referenceCollectionRule";
    public static final String ATTR_DIAGRAM_METACLASS = "diagramMetaclass";
    public static final String ATTR_CLASS = "class";
    private static RuleManager ourInstance = null;
    private HashMap myMetaclass2Rule = new HashMap();

    private RuleManager() {
        this.initRules();
    }

    private void initRules() {
        this.initPredefinedRules();
        this.loadUserRules();
    }

    private void loadUserRules() {
        IExtensionPoint point = RCSupportPlugin.getDefault().getDescriptor().getExtensionPoint(EXT_POINT_REFERENCE_COLLECTION_RULE);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block7: {
                    IConfigurationElement element = elements[j];
                    String diagramMetaclass = element.getAttribute(ATTR_DIAGRAM_METACLASS);
                    if (diagramMetaclass != null) {
                        IChildReferencesRule rule = null;
                        try {
                            rule = (IChildReferencesRule)element.createExecutableExtension(ATTR_CLASS);
                        }
                        catch (Exception e) {
                            System.err.println("Can not instantiate Rule for diagram metaclass: " + diagramMetaclass + " :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block7;
                        }
                        catch (NoClassDefFoundError e) {
                            System.err.println("Can not instantiate Rule for diagram metaclass: " + diagramMetaclass + " :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block7;
                        }
                        if (rule != null) {
                            this.myMetaclass2Rule.put(diagramMetaclass, rule);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void initPredefinedRules() {
        CompositeRule umlDiagramsRule = new CompositeRule();
        umlDiagramsRule.addRule(new UMLDiagramsRule());
        this.myMetaclass2Rule.put("Class Diagram", umlDiagramsRule);
        this.myMetaclass2Rule.put("Activity Diagram", umlDiagramsRule);
        this.myMetaclass2Rule.put("Component Diagram", umlDiagramsRule);
        this.myMetaclass2Rule.put("Deployment Diagram", umlDiagramsRule);
        this.myMetaclass2Rule.put("Use Case Diagram", umlDiagramsRule);
        this.myMetaclass2Rule.put("State Diagram", umlDiagramsRule);
        this.myMetaclass2Rule.put("Sequence Diagram", umlDiagramsRule);
        CompositeRule packageDiagramRule = new CompositeRule();
        packageDiagramRule.addRule(new PackageDiagramRule());
        packageDiagramRule.addRule(new SubstitutePackageByReferenceCollectionRule());
        this.myMetaclass2Rule.put("Package Diagram", packageDiagramRule);
    }

    private IChildReferencesRule getDefaultRule() {
        return null;
    }

    public IChildReferencesRule getRule(String collectionMetaclass) {
        IChildReferencesRule result = (IChildReferencesRule)this.myMetaclass2Rule.get(collectionMetaclass);
        if (result != null) {
            return result;
        }
        return this.getDefaultRule();
    }

    public static RuleManager getInstance() {
        if (ourInstance == null) {
            ourInstance = new RuleManager();
        }
        return ourInstance;
    }
}

