/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.rules;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ReferenceDeltaTreeProvider;
import com.tssap.selena.model.providers.internal.rc.delta.AbstractModelDeltaNodeAdapter;
import com.tssap.selena.model.providers.internal.rc.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.providers.internal.rc.references.modeldelta.ReferenceCollectionDeltaAdapter;
import com.tssap.selena.model.providers.internal.rc.rules.AbstractRuleBasedReferenceProvider;
import com.tssap.selena.model.providers.rc.IChildReferencesRule;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RuleBasedReferenceDeltaProvider
extends AbstractRuleBasedReferenceProvider
implements ReferenceDeltaTreeProvider {
    private HashMap myDeltaNodes = new HashMap();

    public void registered(Model model) {
        super.registered(model);
        this.getModel().addModelDeltaListener((ModelChangeListener)this);
    }

    public void unregistered(Model model) {
        if (model != null) {
            model.removeModelDeltaListener((ModelChangeListener)this);
        }
        super.unregistered(model);
    }

    public void startCollectingChanges(ReferenceCollection collection) {
        UniqueName collectionUin = collection.getUniqueName();
        Assert.isLegal((!this.myDeltaNodes.containsKey(collectionUin) ? 1 : 0) != 0, (String)("RuleBasedReferenceDeltaProvider:: duplicate startCollectingChanges for collection: " + collectionUin));
        IChildReferencesRule rule = this.getRule((ReferenceContainer)collection);
        if (rule == null) {
            return;
        }
        rule.startListening(collection);
        this.initCollectionDelta(collection);
    }

    public void stopCollectingChanges(ReferenceCollection collection) {
        IChildReferencesRule rule = this.getRule((ReferenceContainer)collection);
        if (rule != null) {
            rule.stopListening(collection);
        }
        this.myDeltaNodes.remove(collection.getUniqueName());
    }

    public ModelDeltaNode getReferenceCollectionChanges(ReferenceCollection collection) {
        ModelDeltaNode collectedDelta = (ModelDeltaNode)this.myDeltaNodes.remove(collection.getUniqueName());
        if (collectedDelta != null) {
            this.initCollectionDelta(collection);
        }
        return collectedDelta;
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        ModelDeltaNode rootDelta = changeEvent.getRootDelta();
        final LinkedList<UniqueName> changedCollectionUins = new LinkedList<UniqueName>();
        final HashSet<ReferenceCollectionDeltaAdapter> affectedDeltas = new HashSet<ReferenceCollectionDeltaAdapter>();
        Iterator entries = this.myDeltaNodes.entrySet().iterator();
        while (entries.hasNext()) {
            IChildReferencesRule curRule;
            Map.Entry curEntry = entries.next();
            UniqueName curCollectionUin = (UniqueName)curEntry.getKey();
            ReferenceCollectionDeltaAdapter curCollectionDelta = (ReferenceCollectionDeltaAdapter)curEntry.getValue();
            ReferenceCollection curCollection = this.getModel().findReferenceCollection(curCollectionUin);
            if (curCollection == null || curCollection.isDeleted() || (curRule = this.getRule((ReferenceContainer)curCollection)) == null) continue;
            ModelDeltaNode transformedDelta = curRule.getReferencedEntitiesDelta(curCollection, rootDelta);
            ModelDeltaNodeKind curCollectionsKind = RuleBasedReferenceDeltaProvider.findChangesKind(curCollectionUin, rootDelta);
            if (curCollectionsKind == null) {
                curCollectionsKind = RuleBasedReferenceDeltaProvider.findChangesKind(curCollection.getParent().getUniqueName(), rootDelta);
            }
            if (transformedDelta == null && (curCollectionsKind == null || curCollectionsKind == ModelDeltaNodeKind.CONNECTION)) continue;
            changedCollectionUins.add(curCollectionUin);
            if (curCollectionsKind != null) {
                curCollectionDelta.setKind(curCollectionsKind);
            }
            if (transformedDelta != null) {
                curCollectionDelta.addRegularDelta(transformedDelta);
            }
            affectedDeltas.add(curCollectionDelta);
        }
        if (!changedCollectionUins.isEmpty()) {
            ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

                public void run() {
                    Iterator it = affectedDeltas.iterator();
                    while (it.hasNext()) {
                        ((ReferenceCollectionDeltaAdapter)it.next()).deleteReferencesForDeletedEntities();
                    }
                    Iterator it2 = changedCollectionUins.iterator();
                    while (it2.hasNext()) {
                        RuleBasedReferenceDeltaProvider.super.getModel().getExtensionManager().referenceCollectionContentsChanged((UniqueName)it2.next());
                    }
                }
            });
        }
    }

    private void initCollectionDelta(ReferenceCollection collection) {
        ReferenceCollectionDeltaAdapter newCollectionDelta = new ReferenceCollectionDeltaAdapter(this.getModel(), collection);
        this.myDeltaNodes.put(collection.getUniqueName(), newCollectionDelta);
    }

    private static ModelDeltaNodeKind findChangesKind(UniqueName uin, ModelDeltaNode delta) {
        if (uin.equals(delta.getElementUniqueName())) {
            return AbstractModelDeltaNodeAdapter.getChangesKind(delta);
        }
        Enumeration subDeltas = delta.changedChildren();
        while (subDeltas.hasMoreElements()) {
            ModelDeltaNode curSubDelta = (ModelDeltaNode)subDeltas.nextElement();
            ModelDeltaNodeKind curRecursiveResult = RuleBasedReferenceDeltaProvider.findChangesKind(uin, curSubDelta);
            if (curRecursiveResult == null) continue;
            return curRecursiveResult;
        }
        return null;
    }
}

