/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.rules;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.providers.rc.IChildReferencesFilter;
import com.tssap.selena.model.providers.rc.RCSupportPlugin;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class PackageDiagramFilter
implements IChildReferencesFilter {
    public static final String EXT_POINT_PACKAGE_DIAGRAM_RULE = "packageDiagramRule";
    public static final String ATTR_META_CLASS = "metaclass";
    private static PackageDiagramFilter ourInstance;
    private HashSet myMetaclassesToShow = new HashSet();

    public static PackageDiagramFilter getInstance() {
        if (ourInstance == null) {
            ourInstance = new PackageDiagramFilter();
        }
        return ourInstance;
    }

    private PackageDiagramFilter() {
        this.loadMetaclassesToShow();
    }

    public boolean shouldBeExcluded(Entity childEntity) {
        Entity parent = childEntity.getParent();
        if (parent == null) {
            System.err.println("parent == null for: " + childEntity);
            return true;
        }
        String childMetaclass = childEntity.getPropertyValue("$metaclass");
        return !this.myMetaclassesToShow.contains(childMetaclass);
    }

    private void loadMetaclassesToShow() {
        IExtensionPoint point = RCSupportPlugin.getDefault().getDescriptor().getExtensionPoint(EXT_POINT_PACKAGE_DIAGRAM_RULE);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                String metaclass = element.getAttribute(ATTR_META_CLASS);
                if (metaclass != null) {
                    this.myMetaclassesToShow.add(metaclass);
                }
                ++j;
            }
            ++i;
        }
    }
}

