/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.rules;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.delta.CompositeModelDeltaNode;
import com.tssap.selena.model.util.function.UnaryCondition;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

class DeltaMerger {
    DeltaMerger() {
    }

    public static ModelDeltaNode mergeWithChild(ModelDeltaNode deltaWithPossibleSameChild, UniqueName childUin, Model model) {
        ModelDeltaNode subDeltaForSameUin = null;
        Enumeration directSubDeltas = deltaWithPossibleSameChild.changedChildren();
        while (subDeltaForSameUin == null && directSubDeltas.hasMoreElements()) {
            ModelDeltaNode next = (ModelDeltaNode)directSubDeltas.nextElement();
            if (!childUin.equals(next.getElementUniqueName())) continue;
            subDeltaForSameUin = next;
        }
        if (subDeltaForSameUin == null) {
            return deltaWithPossibleSameChild;
        }
        CompositeModelDeltaNode result = new CompositeModelDeltaNode(model);
        result.addNode(DeltaMerger.filterChild(deltaWithPossibleSameChild, childUin));
        result.addNode(subDeltaForSameUin);
        return result;
    }

    private static ModelDeltaNode filterChild(ModelDeltaNode original, final UniqueName childUin) {
        UnaryCondition filter = new UnaryCondition(){

            public boolean execute(Object object) {
                if (object instanceof ModelDeltaNode) {
                    return !childUin.equals(((ModelDeltaNode)object).getElementUniqueName());
                }
                return false;
            }
        };
        return new FilteredDelta(original, filter);
    }

    private static class FilteredDelta
    implements ModelDeltaNode {
        private ModelDeltaNode myNotFiltered;
        private UnaryCondition myChildCondition;
        private List myChildren;

        public FilteredDelta(ModelDeltaNode notFiltered, UnaryCondition childCondition) {
            this.myNotFiltered = notFiltered;
            this.myChildCondition = childCondition;
        }

        public Enumeration changedChildren() {
            if (this.myChildren == null) {
                Enumeration notFilteredChildren = this.myNotFiltered.changedChildren();
                while (notFilteredChildren.hasMoreElements()) {
                    ModelDeltaNode next = (ModelDeltaNode)notFilteredChildren.nextElement();
                    if (!this.myChildCondition.execute((Object)next)) continue;
                    if (this.myChildren == null) {
                        this.myChildren = new LinkedList();
                    }
                    this.myChildren.add(new FilteredDelta(next, this.myChildCondition));
                }
            }
            return this.myChildren == null ? EmptyEnumeration.getEnumeration() : Collections.enumeration(this.myChildren);
        }

        public Element getElement() {
            return this.myNotFiltered.getElement();
        }

        public UniqueName getElementUniqueName() {
            return this.myNotFiltered.getElementUniqueName();
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myNotFiltered.getOriginalElementUniqueName();
        }

        public boolean isChanged() {
            return this.myNotFiltered.isChanged();
        }

        public boolean isDeleted() {
            return this.myNotFiltered.isDeleted();
        }

        public boolean isEmpty() {
            return this.myNotFiltered.isEmpty();
        }

        public boolean isNew() {
            return this.myNotFiltered.isNew();
        }

        public boolean isTotallyChanged() {
            return this.myNotFiltered.isTotallyChanged();
        }
    }
}

