/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references.modeldelta;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.providers.internal.rc.delta.AbstractModelDeltaNodeAdapter;
import com.tssap.selena.model.providers.internal.rc.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.providers.internal.rc.references.modeldelta.ReferenceCollectionDeltaAdapter;
import com.tssap.selena.model.update.diagram.DispatchedTreeDeltaListener;
import com.tssap.selena.model.update.hierarchy.DeltaDispatcher;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.ReferencesUinSupport;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.util.various.DeltaDumper;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;

public class ReferenceUpdateManager
implements DispatchedTreeDeltaListener {
    private static HashMap ourInstances = new HashMap();
    private ReferenceCollectionDeltaAdapter myRootDelta;
    private ReferenceCollection myCollection;
    private Entity myDiagramNode;
    private Model myModel;

    private ReferenceUpdateManager(ReferenceCollection collection) {
        this.myCollection = collection;
        this.myModel = collection.getModel();
        this.reinitListener(false);
    }

    private void reinitListener(boolean markShortcutsAsChanged) {
        this.myDiagramNode = this.myCollection.getParent();
        this.registerDispatchingDeltaPaths(markShortcutsAsChanged);
    }

    public void dispatchingChainCorrupted(ModelDeltaNode deltaNode) {
        if (!this.myCollection.isDeleted()) {
            this.reinitListener(true);
        } else {
            this.myRootDelta = null;
            ReferenceUpdateManager.removeManager(this.myCollection.getUniqueName());
        }
    }

    public void shortcutAdded(Entity shortcutedEntity) {
        this.registerDispatchingDeltaPath(shortcutedEntity);
    }

    public void shortcutRemoved(UniqueName shortcutedEntityUin) {
        DeltaDispatcher.getInstance((UniqueName)this.myModel.getUniqueName()).removeListener(shortcutedEntityUin, (DispatchedTreeDeltaListener)this);
    }

    public static ReferenceUpdateManager getManager(ReferenceCollection collection) {
        ReferenceUpdateManager result = (ReferenceUpdateManager)ourInstances.get(collection.getUniqueName());
        if (result == null) {
            result = new ReferenceUpdateManager(collection);
            ourInstances.put(collection.getUniqueName(), result);
        }
        return result;
    }

    private static void removeManager(UniqueName collectionUin) {
        ourInstances.remove(collectionUin);
    }

    public void modelChanged(ModelDeltaNode dispatchedDelta) {
        UniqueName changedUin = dispatchedDelta.getElementUniqueName();
        if (this.myDiagramNode.getUniqueName().equals(changedUin)) {
            throw new RuntimeException("should not be reachable -- rule based providers should be used instead");
        }
        this.getRootDelta().addShortcutDelta(dispatchedDelta);
        if (dispatchedDelta.isDeleted()) {
            Entity newEntity;
            UniqueName oldUin = dispatchedDelta.getElementUniqueName();
            UniqueName newUin = dispatchedDelta.getOriginalElementUniqueName();
            if (newUin != null && !newUin.equals(oldUin) && (newEntity = this.myModel.findEntity(newUin)) != null && !this.isReferenceAlreadyPresentsByRule(newEntity, this.myCollection)) {
                this.getRootDelta().addShortcutDelta(new EntityMovedToDeltaNode(this.myModel, newUin, oldUin));
                ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

                    public void run() {
                        ReferenceUpdateManager.this.registerDispatchingDeltaPath(newEntity);
                    }
                });
            }
        }
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                ReferenceUpdateManager.this.getRootDelta().deleteReferencesForDeletedEntities();
                ReferenceUpdateManager.this.myModel.getExtensionManager().referenceCollectionContentsChanged(ReferenceUpdateManager.this.myCollection.getUniqueName());
            }
        });
    }

    private boolean isReferenceAlreadyPresentsByRule(Entity newEntity, ReferenceCollection collection) {
        Reference alreadyPresent = ReferencesUinSupport.findReference((ReferenceCollection)collection, (Entity)newEntity);
        return alreadyPresent != null && !alreadyPresent.hasProperty("$shortcutReference");
    }

    private boolean isParentOfMovedElementChanged(ModelDeltaNode movedFromDelta, Entity newEntity) {
        if (Boolean.TRUE.booleanValue()) {
            throw new RuntimeException("isReferenceAlreadyPresentsByRule is used instead of isParentOfMovedElementChanged");
        }
        Entity newParent = newEntity.getParent();
        if (newParent == null) {
            return true;
        }
        ModelDeltaNode[] deltaParentChain = DeltaDispatcher.getInstance((UniqueName)this.myModel.getUniqueName()).getParentDeltaChain(movedFromDelta);
        if (deltaParentChain == null) {
            System.err.println("DeltaDispatcher cant compute parent chain for moved delta:");
            DeltaDumper.dumpDelta((ModelDeltaNode)movedFromDelta);
            return false;
        }
        if (deltaParentChain.length < 2) {
            System.err.println("DeltaDispatcher computes strange parent chain for moved delta:");
            DeltaDumper.dumpDelta((ModelDeltaNode)movedFromDelta);
            System.err.println("Computed chain: " + Arrays.asList(deltaParentChain).toString());
            return false;
        }
        Assert.isLegal((deltaParentChain[deltaParentChain.length - 1] == movedFromDelta ? 1 : 0) != 0, (String)"contract failed : DeltaDispatcher::getParentDeltaChain");
        UniqueName parentUinFromDelta = deltaParentChain[deltaParentChain.length - 2].getElementUniqueName();
        return !newParent.getUniqueName().equals(parentUinFromDelta);
    }

    private ReferenceCollectionDeltaAdapter getRootDelta() {
        if (this.myRootDelta == null) {
            this.myRootDelta = new ReferenceCollectionDeltaAdapter(this.myModel, this.myCollection);
        }
        return this.myRootDelta;
    }

    public ModelDeltaNode getCollectedDelta() {
        ReferenceCollectionDeltaAdapter result = this.myRootDelta;
        this.myRootDelta = null;
        return result;
    }

    private void registerDispatchingDeltaPaths(boolean markAllShortcutsAsChanged) {
        ReferenceEnumeration references = this.myCollection.references();
        while (references.hasMoreElements()) {
            Reference curReference = references.next();
            if (!curReference.hasProperty("$shortcutReference")) continue;
            this.registerDispatchingDeltaPath(curReference.getEntity());
            if (!markAllShortcutsAsChanged || curReference.getEntity() == null || curReference.getEntity().isDeleted()) continue;
            this.getRootDelta().addShortcutDelta(new FakeChangedDelta(curReference.getModel(), curReference.getEntity().getUniqueName()));
        }
    }

    private void registerDispatchingDeltaPath(Entity entity) {
        if (entity != null && !entity.isDeleted()) {
            DeltaDispatcher.getInstance((UniqueName)this.myModel.getUniqueName()).registerListener((Element)entity, (DispatchedTreeDeltaListener)this);
        }
    }

    private UniqueName getModelUin() {
        return this.myModel.getUniqueName();
    }

    private class FakeChangedDelta
    extends AbstractModelDeltaNodeAdapter
    implements ModelDeltaNode {
        private UniqueName myChangedUin;

        public FakeChangedDelta(Model model, UniqueName changedUin) {
            super(model, ModelDeltaNodeKind.CHANGED);
            this.myChangedUin = changedUin;
        }

        public Enumeration changedChildren() {
            return EmptyEnumeration.getEnumeration();
        }

        public Element getElement() {
            return this.getModel().findElement(this.myChangedUin);
        }

        public UniqueName getElementUniqueName() {
            return this.myChangedUin;
        }

        public UniqueName getOriginalElementUniqueName() {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private class EntityMovedToDeltaNode
    extends AbstractModelDeltaNodeAdapter
    implements ModelDeltaNode {
        private UniqueName myAddedUniqueName;
        private UniqueName myOriginalUniqueName;

        public EntityMovedToDeltaNode(Model model, UniqueName addedUin, UniqueName oldUin) {
            super(model, ModelDeltaNodeKind.ADDED);
            this.myAddedUniqueName = addedUin;
            this.myOriginalUniqueName = oldUin;
        }

        public Enumeration changedChildren() {
            return EmptyEnumeration.getEnumeration();
        }

        public Element getElement() {
            return this.getModel().findElement(this.myAddedUniqueName);
        }

        public UniqueName getElementUniqueName() {
            return this.myAddedUniqueName;
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myOriginalUniqueName;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

