/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references.modeldelta;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.internal.rc.delta.AbstractModelDeltaNodeAdapter;
import com.tssap.selena.model.providers.internal.rc.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.providers.internal.rc.references.modeldelta.ReferenceDeltaAdapter;
import com.tssap.selena.model.util.Assert;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReferenceCollectionDeltaAdapter
extends AbstractModelDeltaNodeAdapter {
    private List myReferenceNodes = new LinkedList();
    private ReferenceCollection myCollection;

    public ReferenceCollectionDeltaAdapter(Model model, ReferenceCollection collection) {
        super(model, ModelDeltaNodeKind.CONNECTION);
        this.myCollection = collection;
    }

    public void deleteReferencesForDeletedEntities() {
        Iterator myNodes = this.myReferenceNodes.iterator();
        while (myNodes.hasNext()) {
            ((ReferenceDeltaAdapter)myNodes.next()).processChangedUins();
        }
        Iterator myNodes2 = this.myReferenceNodes.iterator();
        while (myNodes2.hasNext()) {
            ((ReferenceDeltaAdapter)myNodes2.next()).deleteReferencesForDeletedEntities();
        }
    }

    public UniqueName getElementUniqueName() {
        return this.myCollection.getUniqueName();
    }

    public Element getElement() {
        return this.myCollection;
    }

    public boolean isEmpty() {
        return this.myReferenceNodes.isEmpty();
    }

    public void addRegularDelta(ModelDeltaNode regularDelta) {
        if (this.isCollectionValid()) {
            Enumeration subDeltas = regularDelta.changedChildren();
            while (subDeltas.hasMoreElements()) {
                ModelDeltaNode curSubDelta = (ModelDeltaNode)subDeltas.nextElement();
                if (this.myCollection.getUniqueName().equals(curSubDelta.getElementUniqueName())) {
                    this.setKind(AbstractModelDeltaNodeAdapter.getChangesKind(curSubDelta));
                    continue;
                }
                this.myReferenceNodes.add(new ReferenceDeltaAdapter(this, this.myCollection, curSubDelta));
            }
        }
    }

    public void addShortcutDelta(ModelDeltaNode shortcutDelta) {
        if (this.isCollectionValid()) {
            Assert.isLegal((!this.myCollection.getParent().getUniqueName().equals(shortcutDelta.getElementUniqueName()) ? 1 : 0) != 0);
            this.myReferenceNodes.add(new ReferenceDeltaAdapter(this, this.myCollection, shortcutDelta));
        }
    }

    public Enumeration changedChildren() {
        return Collections.enumeration(this.myReferenceNodes);
    }

    private boolean isCollectionValid() {
        return !this.myCollection.isDeleted() && this.myCollection.getParent() != null;
    }
}

