/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references.find;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.nodeset.CachedDesignModelScope;
import com.tssap.selena.dom.search.IDesignSearchScope;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.providers.internal.rc.references.find.DesignReferenceFinder;
import com.tssap.selena.model.providers.internal.rc.references.find.ReferenceByEntityUinMatcher;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.ReferencesUinSupport;
import com.tssap.selena.model.util.SingleEnumeration;

public class OwnerCollectionPropertyProvider
extends AbstractDesignProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        if (element instanceof Reference) {
            return ((ReferenceCollection)element.getParent()).getUniqueName().toString();
        }
        Entity entity = (Entity)element;
        String optimizedForJavaResult = this.findDefaultPackageDiagramUin(entity);
        if (optimizedForJavaResult != null) {
            return optimizedForJavaResult;
        }
        return this.findAllDesignDiagrams(entity);
    }

    public Property getProperty(Element element, String propertyName) {
        String value = this.getPropertyValue(element, propertyName);
        return value == null ? null : new PropertyAdapter(propertyName, value, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return true;
    }

    public PropertyEnumeration properties(Element element) {
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property result = this.getProperty(element, propertyName);
        return result == null ? EmptyEnumeration.getPropertyEnumeration() : SingleEnumeration.createPropertyEnumeration((Property)result);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if (element instanceof Reference) {
            return propertyValue.equals(((ReferenceCollection)element.getParent()).getUniqueName());
        }
        UniqueName diagramUin = ModelAccess.createUniqueName((String)propertyValue);
        ReferenceCollection diagram = element.getModel().findReferenceCollection(diagramUin);
        if (diagram == null) {
            return false;
        }
        return ReferencesUinSupport.findReference((ReferenceCollection)diagram, (Entity)((Entity)element)) != null;
    }

    private String findDefaultPackageDiagramUin(Entity javaEntity) {
        String metaclass = javaEntity.getPropertyValue("$metaclass");
        if ("Attribute".equals(metaclass) || "Operation".equals(metaclass) || "Package".equals(metaclass) || "Class".equals(metaclass) || "Property".equals(metaclass) || "Interface".equals(metaclass)) {
            Entity parent = javaEntity.getParent();
            while (parent != null && !parent.hasProperty("DiagramUIN")) {
                parent = parent.getParent();
            }
            return parent == null ? null : parent.getPropertyValue("DiagramUIN");
        }
        return null;
    }

    private String findAllDesignDiagrams(Entity entity) {
        DesignReferenceFinder finder = new DesignReferenceFinder(new ReferenceByEntityUinMatcher(entity));
        CachedDesignModelScope scope = new CachedDesignModelScope(this.getCache());
        DesignReference[] references = finder.find((IDesignSearchScope)scope);
        if (references.length != 0) {
            DesignView firstView = references[0].getDesignView();
            return NameUtil.getUniqueName((DesignElement)firstView).toString();
        }
        return null;
    }
}

