/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IReferenceContainer;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ReferenceUinUtil {
    private static String REFERENCE_DOMAIN = "reference";

    public static boolean isDesignReference(Reference reference) {
        ReferenceUniqueName referenceUin = (ReferenceUniqueName)reference.getUniqueName();
        return ReferenceUinUtil.isDesignReferenceUniqueName(referenceUin);
    }

    public static UniqueName getCollectionUin(ReferenceUniqueName referenceUin) {
        if (!ReferenceUinUtil.isDesignReferenceUniqueName(referenceUin)) {
            return null;
        }
        return ReferenceUinUtil.parameter2uin(referenceUin.getLocation());
    }

    public static boolean isDesignReferenceUniqueName(ReferenceUniqueName referenceUin) {
        if (REFERENCE_DOMAIN.equals(referenceUin.getDomain()) && "" == referenceUin.getSubDomain() && "" != referenceUin.getLocation() && "" == referenceUin.getName() && referenceUin.getParametersCount() > 0) {
            UniqueName shouldBeCollectionUin = ReferenceUinUtil.parameter2uin(referenceUin.getLocation());
            if (shouldBeCollectionUin == null) {
                return false;
            }
            UniqueName entityUin = referenceUin.getReferencedUniqueName();
            return ReferenceUinUtil.uin2parameter(entityUin).equals(referenceUin.getParameter(0));
        }
        return false;
    }

    public static ReferenceUniqueName getReferenceUniqueName(DesignReference reference) {
        if (reference == null) {
            return null;
        }
        UniqueName entityUin = ModelAccess.createUniqueName((String)reference.getProxyId());
        String collectionUinAsParameter = ReferenceUinUtil.uin2parameter(NameUtil.getUniqueName((DesignElement)reference.getDesignView()));
        List proxyIdChain = ReferenceUinUtil.getIdChain(reference);
        return ReferenceUinUtil.createReferenceUniqueName(collectionUinAsParameter, entityUin, proxyIdChain);
    }

    public static ReferenceUniqueName getReferenceUniqueName(IReferenceContainer parentContainer, Entity entity) {
        String proxyId = entity.getUniqueName().toString();
        String collectionUinAsParameter = ReferenceUinUtil.uin2parameter(NameUtil.getUniqueName((DesignElement)parentContainer.getDesignView()));
        LinkedList<String> newParameters = new LinkedList<String>();
        newParameters.add(ReferenceUinUtil.proxyId2parameter(proxyId));
        if (parentContainer instanceof DesignReference) {
            newParameters.addAll(ReferenceUinUtil.getIdChain((DesignReference)parentContainer));
        }
        return ReferenceUinUtil.createReferenceUniqueName(collectionUinAsParameter, entity.getUniqueName(), newParameters);
    }

    public static DesignReference findReference(Model model, ReferenceUniqueName referenceUin, boolean forceCreation) {
        if (model == null) {
            return null;
        }
        if (!ReferenceUinUtil.isDesignReferenceUniqueName(referenceUin)) {
            return null;
        }
        UniqueName collectionUin = ReferenceUinUtil.parameter2uin(referenceUin.getLocation());
        DesignElement shouldBeView = NameUtil.getElement((NodeSetCache)NodeSetCache.getCache((UniqueName)model.getUniqueName()), (UniqueName)collectionUin);
        if (!(shouldBeView instanceof DesignView)) {
            return null;
        }
        DesignView curContainer = (DesignView)shouldBeView;
        int i = referenceUin.getParametersCount() - 1;
        while (curContainer != null && i >= 0) {
            String curParameter = referenceUin.getParameter(i);
            String curProxyId = ReferenceUinUtil.parameter2proxyId(curParameter);
            DesignReference nextContainer = curContainer.getReferenceByProxyId(curProxyId);
            if (nextContainer == null && forceCreation) {
                nextContainer = curContainer.internalAddReference(curProxyId);
            }
            curContainer = nextContainer;
            --i;
        }
        if (curContainer instanceof DesignReference) {
            return (DesignReference)curContainer;
        }
        return null;
    }

    public static ReferenceUniqueName getReferenceUniqueName(ReferenceContainer modelContainer, UniqueName entityUin) {
        if (modelContainer instanceof ReferenceCollection) {
            return ReferenceUinUtil.getReferenceUniqueName((ReferenceCollection)modelContainer, entityUin);
        }
        Reference reference = (Reference)modelContainer;
        ReferenceUniqueName referenceUin = (ReferenceUniqueName)reference.getUniqueName();
        return ReferenceUinUtil.getReferenceUniqueName(referenceUin, entityUin);
    }

    public static ReferenceUniqueName getReferenceUniqueName(ReferenceCollection collection, UniqueName entityUin) {
        String collectionUinAsParameter = ReferenceUinUtil.uin2parameter(collection.getUniqueName());
        List<String> parentIdChain = Collections.singletonList(ReferenceUinUtil.uin2parameter(entityUin));
        return ReferenceUinUtil.createReferenceUniqueName(collectionUinAsParameter, entityUin, parentIdChain);
    }

    public static ReferenceUniqueName getReferenceUniqueName(ReferenceUniqueName parentReferenceUin, UniqueName entityUin) {
        Assert.isLegal((boolean)ReferenceUinUtil.isDesignReferenceUniqueName(parentReferenceUin));
        String collectionUinAsParameter = parentReferenceUin.getLocation();
        LinkedList<String> parentIdChain = new LinkedList<String>();
        parentIdChain.add(ReferenceUinUtil.uin2parameter(entityUin));
        int i = 0;
        while (i < parentReferenceUin.getParametersCount()) {
            parentIdChain.add(parentReferenceUin.getParameter(i));
            ++i;
        }
        return ReferenceUinUtil.createReferenceUniqueName(collectionUinAsParameter, entityUin, parentIdChain);
    }

    public static ReferenceUniqueName getParentReferenceUniqueName(ReferenceUniqueName referenceUin) {
        if (referenceUin.getParametersCount() <= 1) {
            return null;
        }
        LinkedList<String> parentIdChain = new LinkedList<String>();
        int i = 0;
        while (i < referenceUin.getParametersCount()) {
            if (i != 0) {
                parentIdChain.add(referenceUin.getParameter(i));
            }
            ++i;
        }
        UniqueName entityUin = ReferenceUinUtil.parameter2uin((String)parentIdChain.getFirst());
        String collectionUinAsParameter = referenceUin.getLocation();
        ReferenceUniqueName result = ReferenceUinUtil.createReferenceUniqueName(collectionUinAsParameter, entityUin, parentIdChain);
        return result;
    }

    private static ReferenceUniqueName createReferenceUniqueName(String collectionUinAsParameter, UniqueName entityUin, List proxyIdChain) {
        Assert.isLegal((collectionUinAsParameter != null ? 1 : 0) != 0);
        Assert.isLegal((entityUin != null ? 1 : 0) != 0);
        Assert.isLegal((proxyIdChain != null && proxyIdChain.size() > 0 ? 1 : 0) != 0);
        String entityUinAsParameter = ReferenceUinUtil.uin2parameter(entityUin);
        Assert.isLegal((entityUinAsParameter != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)proxyIdChain.get(0).equals(entityUinAsParameter));
        UniqueName baseReferenceUin = ModelAccess.createUniqueName((String)REFERENCE_DOMAIN, null, (String)collectionUinAsParameter, null, (String[])proxyIdChain.toArray(new String[proxyIdChain.size()]));
        return ModelAccess.createReferenceUniqueName((UniqueName)baseReferenceUin, (UniqueName)entityUin);
    }

    private static String uin2parameter(UniqueName uin) {
        return ReferenceUinUtil.uinAsString2parameter(uin.toString());
    }

    private static String uinAsString2parameter(String asString) {
        return asString.replace(':', '@');
    }

    private static String proxyId2parameter(String proxyId) {
        return ReferenceUinUtil.uinAsString2parameter(proxyId);
    }

    private static String parameter2proxyId(String asParameter) {
        return asParameter.replace('@', ':');
    }

    private static UniqueName parameter2uin(String asParameter) {
        UniqueName result = ModelAccess.createUniqueName((String)ReferenceUinUtil.parameter2proxyId(asParameter));
        return result;
    }

    private static List getIdChain(DesignReference reference) {
        LinkedList<String> result = new LinkedList<String>();
        String curProxyId = reference.getProxyId();
        result.add(ReferenceUinUtil.uinAsString2parameter(curProxyId));
        IReferenceContainer curParent = reference.getParentContainer();
        while (curParent instanceof DesignReference) {
            curProxyId = ((DesignReference)curParent).getProxyId();
            result.add(ReferenceUinUtil.uinAsString2parameter(curProxyId));
            curParent = ((DesignReference)curParent).getParentContainer();
        }
        return result;
    }
}

