/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.property.IDesignPropertySetValidator;
import com.tssap.selena.internal.dom.providers.DesignPropertyAdapter;
import com.tssap.selena.internal.dom.providers.GenericGetPropertyProvider;
import com.tssap.selena.internal.dom.providers.PropertySetRegistry;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.providers.internal.rc.references.ReferenceUinUtil;
import com.tssap.selena.model.util.various.DiagramPropertySet;
import java.util.Arrays;
import java.util.HashSet;

public class DesignReferencesPropertyProvider
extends GenericGetPropertyProvider
implements PropertyGetProvider,
PropertySetProvider {
    private HashSet myRejectedPropertyNames = new HashSet();

    public DesignReferencesPropertyProvider() {
        this.myRejectedPropertyNames.addAll(Arrays.asList(DiagramPropertySet.REFERENCES_INHERITED_PROPERTIES));
    }

    protected DesignNotion getPropertyOwner(Element element) {
        return ReferenceUinUtil.findReference(this.getModel(), (ReferenceUniqueName)element.getUniqueName(), false);
    }

    protected DesignReference createPropertyOwner(Element element) {
        return ReferenceUinUtil.findReference(this.getModel(), (ReferenceUniqueName)element.getUniqueName(), true);
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (propertyName != null && this.myRejectedPropertyNames.contains(propertyName)) {
            return false;
        }
        if (element instanceof Reference && ReferenceUinUtil.isDesignReference((Reference)element)) {
            Entity referencedEntity = ((Reference)element).getEntity();
            return referencedEntity != null && !referencedEntity.isDeleted();
        }
        return false;
    }

    protected Model getModel() {
        return ModelAccess.getModel((UniqueName)this.getModelUin());
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        DesignReference reference = this.createPropertyOwner(element);
        return new DesignPropertyAdapter(reference.createProperty(propertyName, propertyValue), element);
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        if (this.isDiagramReadOnly((Reference)element)) {
            return false;
        }
        String metaclass = this.getDiagramMetaclass(element);
        if (metaclass == null) {
            return false;
        }
        if (!PropertySetRegistry.getInstance().isMutableProperty(propertyName, metaclass)) {
            return false;
        }
        if (!PropertySetRegistry.getInstance().isMultivaluedProperty(propertyName, metaclass)) {
            return !this.hasProperty(element, propertyName);
        }
        IDesignPropertySetValidator validator = PropertySetRegistry.getInstance().getValidator(propertyName);
        return validator == null || validator.isValidValue(element, propertyName, propertyValue);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (this.isDiagramReadOnly((Reference)element)) {
            return false;
        }
        String metaclass = this.getDiagramMetaclass(element);
        if (metaclass == null) {
            return false;
        }
        if (PropertySetRegistry.getInstance().isMutableProperty(propertyName, metaclass)) {
            IDesignPropertySetValidator validator = PropertySetRegistry.getInstance().getValidator(propertyName);
            return validator == null || validator.isValidValue(element, propertyName, propertyValue);
        }
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        DesignReference reference = this.createPropertyOwner(element);
        final DesignProperty[] properties = reference.getProperties(propertyName);
        if (propertyValue == null) {
            if (properties != null) {
                reference.getNodeSet().runCommand(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < properties.length) {
                            properties[i].delete();
                            ++i;
                        }
                    }
                });
            }
        } else if (properties == null || properties.length == 0) {
            reference.createProperty(propertyName, propertyValue);
        } else {
            properties[0].setValue(propertyValue);
        }
    }

    private String getDiagramMetaclass(Element element) {
        ReferenceCollection collection = (ReferenceCollection)element.getParent();
        if (collection == null) {
            return null;
        }
        return collection.getPropertyValue("$metaclass");
    }

    private boolean isDiagramReadOnly(Reference reference) {
        ReferenceCollection collection = (ReferenceCollection)reference.getParent();
        return this.isReadOnly((Entity)collection);
    }
}

