/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.internal.dom.IDesignReferenceChangeListener;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ReferenceDeltaTreeProvider;
import com.tssap.selena.model.providers.internal.rc.delta.CollectionDeltaNodeAdapter;
import com.tssap.selena.model.providers.internal.rc.delta.DesignViewDeltaNode;
import com.tssap.selena.model.providers.internal.rc.references.AbstractReferenceProvider;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;

public class DesignReferenceTreeDeltaProvider
extends AbstractReferenceProvider
implements ReferenceDeltaTreeProvider,
IDesignReferenceChangeListener {
    private HashMap myCollection2DeltaNodes = new HashMap();

    public void registered(Model model) {
        super.registered(model);
        this.getCache().setReferenceListener((IDesignReferenceChangeListener)this);
    }

    public void unregistered(Model model) {
        this.getCache().removeReferenceListener();
        super.unregistered(model);
    }

    public ModelDeltaNode getReferenceCollectionChanges(ReferenceCollection collection) {
        DesignViewDeltaNode delta = (DesignViewDeltaNode)this.myCollection2DeltaNodes.get(collection.getUniqueName());
        if (delta == null) {
            System.err.println("getReferenceCollectionChanges before startCollectingChanges for:" + collection);
            this.startCollectingChanges(collection);
            delta = (DesignViewDeltaNode)this.myCollection2DeltaNodes.get(collection.getUniqueName());
        }
        CollectionDeltaNodeAdapter result = new CollectionDeltaNodeAdapter(this.getModel(), delta);
        this.startCollectingChanges(collection);
        return result;
    }

    public void startCollectingChanges(ReferenceCollection collection) {
        DesignViewDeltaNode newDeltaNode = new DesignViewDeltaNode(this.getModel(), collection.getUniqueName());
        this.myCollection2DeltaNodes.put(collection.getUniqueName(), newDeltaNode);
    }

    public void stopCollectingChanges(ReferenceCollection collection) {
        this.myCollection2DeltaNodes.remove(collection);
    }

    private UniqueName getCollectionUin(DesignReference designReference) {
        Assert.isLegal((designReference != null ? 1 : 0) != 0);
        DesignView designView = designReference.getDesignView();
        return NameUtil.getUniqueName((DesignElement)designView);
    }

    private DesignViewDeltaNode getDeltaNode(DesignReference designReference) {
        UniqueName collectionUin = this.getCollectionUin(designReference);
        Assert.isLegal((collectionUin != null ? 1 : 0) != 0);
        return (DesignViewDeltaNode)this.myCollection2DeltaNodes.get(collectionUin);
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        throw new RuntimeException("should not be reachable");
    }

    public void referenceAdded(DesignReference reference) {
        if (this.checkReferencedEntityExists(reference)) {
            DesignViewDeltaNode deltaNode = this.getDeltaNode(reference);
            if (deltaNode != null) {
                deltaNode.deepReferenceAdded(reference);
            }
            this.getModel().getExtensionManager().referenceCollectionContentsChanged(this.getCollectionUin(reference));
        }
    }

    public void referenceChanged(DesignReference reference) {
        DesignViewDeltaNode deltaNode = this.getDeltaNode(reference);
        if (deltaNode != null) {
            deltaNode.deepReferenceChanged(reference);
        }
        this.getModel().getExtensionManager().referenceCollectionContentsChanged(this.getCollectionUin(reference));
    }

    public void referenceDeleted(DesignReference reference) {
        DesignViewDeltaNode deltaNode = this.getDeltaNode(reference);
        if (deltaNode != null) {
            deltaNode.deepReferenceDeleted(reference);
        }
        this.getModel().getExtensionManager().referenceCollectionContentsChanged(this.getCollectionUin(reference));
    }

    private boolean checkReferencedEntityExists(DesignReference reference) {
        Element referencedElement = this.getModel().findElement(ModelAccess.createUniqueName((String)reference.getProxyId()));
        return referencedElement != null && !referencedElement.isDeleted();
    }
}

