/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.references;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.IReferenceContainer;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.ReferenceUniqueNameEnumeration;
import com.tssap.selena.model.extension.ReferenceProvider;
import com.tssap.selena.model.providers.internal.rc.DiagramUtil;
import com.tssap.selena.model.providers.internal.rc.references.AbstractReferenceProvider;
import com.tssap.selena.model.providers.internal.rc.references.ReferenceUinUtil;
import com.tssap.selena.model.providers.internal.rc.references.modeldelta.ReferenceUpdateManager;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.HashSet;
import java.util.Set;

public class DesignReferenceProvider
extends AbstractReferenceProvider
implements ReferenceProvider {
    public boolean isReferenceProviderApplicable(ReferenceContainer container) {
        return this.getDesignContainer(container) != null;
    }

    public ReferenceUniqueNameEnumeration references(ReferenceContainer container) {
        Assert.isNotNull((Object)container);
        HashSet result = new HashSet();
        this.addSynchronizedReferenceUins(container, result);
        this.addShortcuts(container, result);
        return EnumerationConverter.toReferenceUniqueNameEnumeration(result.iterator());
    }

    public boolean canAddReference(ReferenceContainer container, Reference template, Entity entity) {
        if (container != null && container.equals(entity)) {
            return false;
        }
        IReferenceContainer designContainer = this.getDesignContainer(container);
        if (this.isReadOnly((DesignNotion)designContainer.getDesignView())) {
            return false;
        }
        return designContainer.getReferenceByProxyId(entity.getUniqueName().toString()) == null;
    }

    public ReferenceUniqueName addReference(ReferenceContainer container, final Reference template, Entity entity) {
        final IReferenceContainer designContainer = this.getDesignContainer(container);
        final String proxyId = entity.getUniqueName().toString();
        final DesignReference[] newDesignReference = new DesignReference[1];
        designContainer.getDesignView().runCommand(new Runnable(){

            public void run() {
                newDesignReference[0] = designContainer.addReference(proxyId);
                if (template != null) {
                    PropertyEnumeration predefinedProperties = template.properties();
                    while (predefinedProperties.hasMoreElements()) {
                        Property curProperty = predefinedProperties.next();
                        newDesignReference[0].createProperty(curProperty.getName(), curProperty.getValue());
                    }
                }
            }
        });
        if (container instanceof ReferenceCollection && template != null && template.hasProperty("$shortcutReference")) {
            ReferenceUpdateManager.getManager((ReferenceCollection)container).shortcutAdded(entity);
        }
        return ReferenceUinUtil.getReferenceUniqueName(newDesignReference[0]);
    }

    private void addSynchronizedReferenceUins(ReferenceContainer modelContainer, Set result) {
    }

    private void addShortcuts(ReferenceContainer container, Set result) {
        IReferenceContainer designContainer = this.getDesignContainer(container);
        if (designContainer == null) {
            return;
        }
        DesignReference[] subReferences = designContainer.getReferences();
        int i = 0;
        while (i < subReferences.length) {
            if (DiagramUtil.hasDesignProperty((DesignNotion)subReferences[i], "$shortcutReference")) {
                ReferenceUniqueName curReferenceUin = ReferenceUinUtil.getReferenceUniqueName(subReferences[i]);
                result.add(curReferenceUin);
            }
            ++i;
        }
    }
}

