/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.delta;

import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.internal.rc.delta.DesignReferenceDeltaNode;
import com.tssap.selena.model.providers.internal.rc.references.modeldelta.ReferenceUpdateManager;
import com.tssap.selena.model.util.Assert;
import java.util.Iterator;
import java.util.List;

public class DesignViewDeltaNode
extends DesignReferenceDeltaNode {
    private UniqueName myCollectionUin;
    private UniqueName myModelUin;

    public DesignViewDeltaNode(Model model, UniqueName collectionUin) {
        super(null, false);
        this.myCollectionUin = collectionUin;
        this.myModelUin = model.getUniqueName();
    }

    public UniqueName getElementUniqueName() {
        return this.myCollectionUin;
    }

    public void deepReferenceAdded(DesignReference reference) {
        this.coupleUntilParentNode(reference).add(reference);
        this.notifyReferenceUpdateManager(reference);
    }

    public void deepReferenceChanged(DesignReference reference) {
        this.coupleUntilParentNode(reference).change(reference);
    }

    public void deepReferenceDeleted(DesignReference reference) {
        this.coupleUntilParentNode(reference).delete(reference);
    }

    private DesignReferenceDeltaNode coupleUntilParentNode(DesignReference deepReference) {
        List parentChain = DesignReferenceDeltaNode.getParentContainerChain(deepReference);
        DesignReferenceDeltaNode curParentDeltaNode = this;
        Iterator referenceChain = parentChain.iterator();
        Assert.isLegal((boolean)referenceChain.hasNext(), (String)"parent chain is empty");
        do {
            DesignReference curInChain = (DesignReference)referenceChain.next();
            if (!referenceChain.hasNext()) continue;
            curParentDeltaNode = curParentDeltaNode.couple(curInChain);
        } while (referenceChain.hasNext());
        return curParentDeltaNode;
    }

    private void notifyReferenceUpdateManager(DesignReference designReference) {
        String entityUinStr;
        UniqueName entityUin;
        Entity shortcutedEntity;
        ReferenceCollection collection;
        Model model;
        if (designReference.getProperties("$shortcutReference").length > 0 && (model = ModelAccess.getModel((UniqueName)this.myModelUin)) != null && (collection = model.findReferenceCollection(this.myCollectionUin)) != null && (shortcutedEntity = model.findEntity(entityUin = ModelAccess.createUniqueName((String)(entityUinStr = designReference.getProxyId())))) != null) {
            ReferenceUpdateManager.getManager(collection).shortcutAdded(shortcutedEntity);
        }
    }
}

