/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.delta;

import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.internal.rc.references.ReferenceUinUtil;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DesignReferenceDeltaNode {
    private DesignReference myDesignReference;
    private boolean myPropertyChanged;
    HashMap myAddedChildren = new HashMap();
    HashMap myDeletedChildren = new HashMap();
    HashMap myChangedChildren = new HashMap();

    public DesignReferenceDeltaNode(DesignReference designReference, boolean propertyChanged) {
        this.myDesignReference = designReference;
        this.myPropertyChanged = propertyChanged;
    }

    public boolean isPropertyChanged() {
        return this.myPropertyChanged;
    }

    public void setPropertyChanged() {
        this.myPropertyChanged = true;
    }

    public boolean isEmpty() {
        return this.myAddedChildren.isEmpty() && this.myChangedChildren.isEmpty() && this.myDeletedChildren.isEmpty();
    }

    private void checkSubDeltaUnqiue(ReferenceUniqueName referenceUin) {
        int correspondingMaps = 0;
        if (this.myAddedChildren.containsKey(referenceUin)) {
            ++correspondingMaps;
        }
        if (this.myChangedChildren.containsKey(referenceUin)) {
            ++correspondingMaps;
        }
        if (this.myDeletedChildren.containsKey(referenceUin)) {
            ++correspondingMaps;
        }
        if (correspondingMaps > 1) {
            throw new RuntimeException("SubDelta is not unique");
        }
    }

    public ReferenceUniqueName getReferenceUin() {
        return DesignReferenceDeltaNode.getUin(this.myDesignReference);
    }

    public UniqueName getElementUniqueName() {
        return this.getReferenceUin();
    }

    protected DesignReferenceDeltaNode add(DesignReference child) {
        ReferenceUniqueName addedUin = DesignReferenceDeltaNode.getUin(child);
        DesignReferenceDeltaNode result = null;
        Assert.isLegal((!this.myChangedChildren.containsKey(addedUin) ? 1 : 0) != 0, (String)"can not add already known subReference");
        Assert.isLegal((!this.myAddedChildren.containsKey(addedUin) ? 1 : 0) != 0, (String)"can not add already known subReference");
        DesignReferenceDeltaNode wasDeleted = (DesignReferenceDeltaNode)this.myDeletedChildren.remove(addedUin);
        if (wasDeleted != null) {
            result = new DesignReferenceDeltaNode(child, true);
            this.myChangedChildren.put(addedUin, result);
            this.markChildrenAsChanged(result, child);
        } else {
            result = new DesignReferenceDeltaNode(child, false);
            this.myAddedChildren.put(addedUin, result);
        }
        return result;
    }

    protected DesignReferenceDeltaNode change(DesignReference child) {
        ReferenceUniqueName changedUin = DesignReferenceDeltaNode.getUin(child);
        Assert.isLegal((!this.myDeletedChildren.containsKey(changedUin) ? 1 : 0) != 0, (String)"can not change already deleted subReference");
        if (this.myAddedChildren.containsKey(changedUin)) {
            return (DesignReferenceDeltaNode)this.myAddedChildren.get(changedUin);
        }
        if (this.myChangedChildren.containsKey(changedUin)) {
            DesignReferenceDeltaNode result = (DesignReferenceDeltaNode)this.myChangedChildren.get(changedUin);
            result.setPropertyChanged();
            return result;
        }
        DesignReferenceDeltaNode result = new DesignReferenceDeltaNode(child, true);
        this.myChangedChildren.put(changedUin, result);
        return result;
    }

    protected DesignReferenceDeltaNode couple(DesignReference child) {
        ReferenceUniqueName coupledUin = DesignReferenceDeltaNode.getUin(child);
        Assert.isLegal((!this.myDeletedChildren.containsKey(coupledUin) ? 1 : 0) != 0, (String)"can not couple already deleted subReference");
        if (this.myChangedChildren.containsKey(coupledUin)) {
            return (DesignReferenceDeltaNode)this.myChangedChildren.get(coupledUin);
        }
        if (this.myAddedChildren.containsKey(coupledUin)) {
            return (DesignReferenceDeltaNode)this.myAddedChildren.get(coupledUin);
        }
        DesignReferenceDeltaNode result = new DesignReferenceDeltaNode(child, false);
        this.myChangedChildren.put(coupledUin, result);
        return result;
    }

    protected DesignReferenceDeltaNode delete(DesignReference child) {
        ReferenceUniqueName deletedUin = DesignReferenceDeltaNode.getUin(child);
        Assert.isLegal((!this.myDeletedChildren.containsKey(deletedUin) ? 1 : 0) != 0, (String)"can not delete already deleted subReference");
        DesignReferenceDeltaNode result = null;
        if (this.myChangedChildren.containsKey(deletedUin)) {
            this.myChangedChildren.remove(deletedUin);
            result = new DesignReferenceDeltaNode(child, false);
            this.myDeletedChildren.put(deletedUin, result);
        } else if (this.myAddedChildren.containsKey(deletedUin)) {
            this.myAddedChildren.remove(deletedUin);
            result = null;
        } else {
            result = new DesignReferenceDeltaNode(child, false);
            this.myDeletedChildren.put(deletedUin, result);
        }
        return result;
    }

    private void markChildrenAsChanged(DesignReferenceDeltaNode baseDeltaNode, DesignReference baseReference) {
        DesignReference[] references = baseReference.getReferences();
        int i = 0;
        while (i < references.length) {
            DesignReference curSubReference = references[i];
            DesignReferenceDeltaNode curSubNode = baseDeltaNode.change(curSubReference);
            this.markChildrenAsChanged(curSubNode, curSubReference);
            ++i;
        }
    }

    private static ReferenceUniqueName getUin(DesignReference designReference) {
        return ReferenceUinUtil.getReferenceUniqueName(designReference);
    }

    protected static List getParentContainerChain(DesignReference reference) {
        LinkedList<DesignReference> result = new LinkedList<DesignReference>();
        DesignReference curContainer = reference;
        DesignView view = reference.getDesignView();
        while (curContainer instanceof DesignReference) {
            result.addFirst(curContainer);
            curContainer = curContainer.getParentContainer();
        }
        Assert.isLegal((boolean)(curContainer instanceof DesignView));
        Assert.isLegal((curContainer == view ? 1 : 0) != 0);
        return result;
    }
}

