/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.delta;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.internal.rc.delta.ModelDeltaNodeKind;
import java.util.Enumeration;

public abstract class AbstractModelDeltaNodeAdapter
implements ModelDeltaNode {
    protected ModelDeltaNodeKind myKind;
    private Model myModel;

    public AbstractModelDeltaNodeAdapter(Model model, ModelDeltaNodeKind kind) {
        this.myModel = model;
        this.setKind(kind);
    }

    public void setKind(ModelDeltaNodeKind kind) {
        this.myKind = kind;
    }

    public UniqueName getOriginalElementUniqueName() {
        return this.getElementUniqueName();
    }

    public final boolean isNew() {
        return this.myKind.isNew();
    }

    public final boolean isDeleted() {
        return this.myKind.isDeleted();
    }

    public boolean isChanged() {
        return this.myKind.isChanged();
    }

    public final boolean isTotallyChanged() {
        return this.myKind.isTotallyChanged();
    }

    protected Model getModel() {
        return this.myModel;
    }

    public static ModelDeltaNodeKind getChangesKind(ModelDeltaNode deltaNode) {
        if (deltaNode.isNew()) {
            return ModelDeltaNodeKind.ADDED;
        }
        if (deltaNode.isDeleted()) {
            return ModelDeltaNodeKind.DELETED;
        }
        if (deltaNode.isTotallyChanged()) {
            return ModelDeltaNodeKind.TOTALLY_CHANGED;
        }
        if (deltaNode.isChanged()) {
            return ModelDeltaNodeKind.CHANGED;
        }
        return ModelDeltaNodeKind.CONNECTION;
    }

    public abstract Enumeration changedChildren();

    public abstract boolean isEmpty();

    public abstract Element getElement();

    public abstract UniqueName getElementUniqueName();
}

