/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.copypaste;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class TemplateInfo {
    private HashMap myChildren = new HashMap();
    private UniqueName myOriginalUin;

    public TemplateInfo(UniqueName uin) {
        this.myOriginalUin = uin;
    }

    public final void substituteInnerTemplates(Map substitutionMap) {
        if (substitutionMap.isEmpty()) {
            return;
        }
        HashMap<UniqueName, TemplateInfo> newUin2oldTemplate = null;
        Iterator entries = this.myChildren.entrySet().iterator();
        while (entries.hasNext()) {
            UniqueName newUin;
            Map.Entry nextEntry = entries.next();
            UniqueName nextSubUin = (UniqueName)nextEntry.getKey();
            TemplateInfo nextChild = (TemplateInfo)nextEntry.getValue();
            nextChild.substituteInnerTemplates(substitutionMap);
            if (!substitutionMap.containsKey(nextSubUin)) continue;
            if (newUin2oldTemplate == null) {
                newUin2oldTemplate = new HashMap<UniqueName, TemplateInfo>();
            }
            nextChild.myOriginalUin = newUin = ((Entity)substitutionMap.get(nextSubUin)).getUniqueName();
            newUin2oldTemplate.put(newUin, nextChild);
            entries.remove();
        }
        if (newUin2oldTemplate != null) {
            this.myChildren.putAll(newUin2oldTemplate);
        }
    }

    public final void addChildInfo(TemplateInfo child) {
        Assert.isLegal((!this.myChildren.containsKey(child.getOriginalUin()) ? 1 : 0) != 0);
        this.myChildren.put(child.getOriginalUin(), child);
    }

    public final UniqueName getOriginalUin() {
        return this.myOriginalUin;
    }

    public final TemplateInfo getChildInfo(UniqueName childEntityUin) {
        return (TemplateInfo)this.myChildren.get(childEntityUin);
    }

    public final TemplateInfo removeChildInfo(UniqueName childEntityUin) {
        return (TemplateInfo)this.myChildren.remove(childEntityUin);
    }

    public final TemplateInfo[] getAllChildInfos() {
        return this.myChildren.values().toArray(new TemplateInfo[this.myChildren.values().size()]);
    }

    public final boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((TemplateInfo)obj).getOriginalUin().equals(this.getOriginalUin());
    }

    public final int hashCode() {
        return this.getOriginalUin().hashCode();
    }
}

