/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.copypaste;

import com.tssap.selena.internal.dom.copypaste.DesignClipboardManager;
import com.tssap.selena.internal.dom.copypaste.IDesignClipboardCopy;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.providers.internal.rc.copypaste.IReferenceCollectionSaver;
import com.tssap.selena.model.providers.internal.rc.copypaste.ReferenceCollectionSaverFactory;
import com.tssap.selena.model.providers.internal.rc.references.AbstractReferenceProvider;
import com.tssap.selena.model.util.Assert;

public class DesignCollectionCopyCutProvider
extends AbstractReferenceProvider
implements CopyProvider,
CutProvider {
    private DesignClipboardManager myClipboardManager;

    public boolean isCopyProviderApplicable(Element element) {
        return element instanceof ReferenceCollection && this.getDesignView((ReferenceCollection)element) != null;
    }

    public boolean isCutProviderApplicable(Element element) {
        return this.isCopyProviderApplicable(element) && !this.isReadOnly((Entity)((ReferenceCollection)element));
    }

    public boolean canCopy(Element element) {
        return true;
    }

    public void copy(Element element, CopyUniqueName copyUin) {
        IReferenceCollectionSaver rcSaver = ReferenceCollectionSaverFactory.createSaver((ReferenceCollection)element);
        rcSaver.save((ReferenceCollection)element, false);
        ReferenceCollection diagram = (ReferenceCollection)element;
        ReferenceEnumeration references = diagram.references();
        while (references.hasMoreElements()) {
            Reference next = references.next();
            this.addReferencedEntityCopy(rcSaver, next);
        }
        this.myClipboardManager.addCopy((UniqueName)copyUin, (IDesignClipboardCopy)rcSaver);
    }

    public boolean canCut(Element element) {
        if (this.canCopy(element) && (DesignCollectionCopyCutProvider.isDefaultDiagram(element) || element.canDelete())) {
            boolean result = true;
            ReferenceEnumeration references = ((ReferenceCollection)element).references();
            while (result && references.hasMoreElements()) {
                Reference next = references.next();
                if (!this.shouldCopyReferencedEntity(next)) continue;
                Entity entity = next.getEntity();
                result = entity.canCut();
            }
            return result;
        }
        return false;
    }

    public void cut(Element element, CopyUniqueName copyUin) {
        IReferenceCollectionSaver rcSaver = ReferenceCollectionSaverFactory.createSaver((ReferenceCollection)element);
        rcSaver.save((ReferenceCollection)element, true);
        ReferenceCollection diagram = (ReferenceCollection)element;
        ReferenceEnumeration references = diagram.references();
        while (references.hasMoreElements()) {
            Reference next = references.next();
            this.addCuttedEntity(rcSaver, next);
        }
        this.myClipboardManager.addCopy((UniqueName)copyUin, (IDesignClipboardCopy)rcSaver);
        if (!DesignCollectionCopyCutProvider.isDefaultDiagram(element)) {
            this.getDesignView((ReferenceCollection)element).delete();
        }
    }

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardManager = DesignClipboardManager.getInstance((Model)model);
    }

    public void unregistered(Model model) {
        if (this.myClipboardManager != null) {
            this.myClipboardManager.clearAll();
            this.myClipboardManager = null;
        }
        super.unregistered(model);
    }

    private boolean shouldCopyReferencedEntity(Reference reference) {
        if (reference.hasProperty("$imported")) {
            return false;
        }
        Entity entity = reference.getEntity();
        if (entity == null) {
            return false;
        }
        return entity.hasPropertyValue("$design:entity_type", "link") || entity.hasPropertyValue("$design:entity_type", "node");
    }

    private void addReferencedEntityCopy(IReferenceCollectionSaver saver, Reference reference) {
        if (!this.shouldCopyReferencedEntity(reference)) {
            return;
        }
        Entity entity = reference.getEntity();
        IDesignClipboardCopy designCopy = this.createDesignCopy(entity);
        if (designCopy == null) {
            return;
        }
        saver.addDesignEntityCopy(designCopy);
    }

    private void addCuttedEntity(IReferenceCollectionSaver saver, Reference reference) {
        if (!this.shouldCopyReferencedEntity(reference)) {
            return;
        }
        Entity entity = reference.getEntity();
        if (!this.checkCuttableByDesignProviders(entity)) {
            return;
        }
        Entity entityCut = entity.cut();
        if (entityCut == null) {
            return;
        }
        IDesignClipboardCopy designCut = this.myClipboardManager.getCopy(entityCut.getUniqueName());
        Assert.isLegal((designCut != null ? 1 : 0) != 0, (String)("cut-copy for entity:" + entity + " is not created by design subsystem"));
        saver.addDesignEntityCopy(designCut);
        this.myClipboardManager.removeCopy(entityCut.getUniqueName());
    }

    private boolean checkCuttableByDesignProviders(Entity entity) {
        return this.createDesignCopy(entity) != null;
    }

    private IDesignClipboardCopy createDesignCopy(Entity entity) {
        Entity entityCopy = entity.copy();
        if (entityCopy == null) {
            return null;
        }
        IDesignClipboardCopy result = this.myClipboardManager.getCopy(entityCopy.getUniqueName());
        this.myClipboardManager.removeCopy(entityCopy.getUniqueName());
        return result;
    }

    private static boolean isDefaultDiagram(Element element) {
        return element.hasProperty("$defaultDiagram");
    }
}

