/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc.copypaste;

import com.tssap.selena.internal.dom.MovedDiagramDeltaProvider;
import com.tssap.selena.internal.dom.copypaste.IDesignClipboardCopy;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.providers.internal.rc.copypaste.IReferenceCollectionSaver;
import com.tssap.selena.model.providers.internal.rc.copypaste.ReferenceCollectionTemplateInfo;
import com.tssap.selena.model.providers.internal.rc.copypaste.ReferenceTemplateInfo;
import com.tssap.selena.model.providers.internal.rc.copypaste.TemplateInfo;
import com.tssap.selena.model.providers.resources.IRootManager;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;

public abstract class AbstractDiagramSaver
implements IReferenceCollectionSaver {
    private ReferenceCollection myPastedResult = null;
    private ReferenceCollectionTemplateInfo myRCInfo;
    private Model myCachedModel;
    private List myDesignEntityCopies = new LinkedList();
    private MovedDeltaInfo myMovedDeltaInfo = null;

    protected AbstractDiagramSaver() {
    }

    public void dispose() {
    }

    protected abstract boolean shouldSaveTopLevelReference(Reference var1);

    public abstract boolean canPaste(Entity var1);

    protected abstract ReferenceCollection doPasteBaseElements(Entity var1, Map var2);

    public final Entity pasteBaseElements(Entity parent, Map substitutionMap) {
        this.myPastedResult = this.doPasteBaseElements(parent, substitutionMap);
        if (this.myPastedResult != null && this.myMovedDeltaInfo != null) {
            this.myMovedDeltaInfo.registerMovedDelta(this.myPastedResult);
            this.myMovedDeltaInfo.dispose();
            this.myMovedDeltaInfo = null;
        }
        return this.myPastedResult;
    }

    public final void addDesignEntityCopy(IDesignClipboardCopy designCopy) {
        if (designCopy != null) {
            this.myDesignEntityCopies.add(designCopy);
        }
    }

    public final void save(ReferenceCollection original, boolean cutMode) {
        this.myCachedModel = original.getModel();
        this.saveCollection(original);
        if (cutMode) {
            this.myMovedDeltaInfo = new MovedDeltaInfo(original);
        }
    }

    protected final boolean canPasteDesignEntityCopies(Entity parent) {
        boolean result = true;
        Iterator designEntityCopies = this.myDesignEntityCopies.iterator();
        while (result && designEntityCopies.hasNext()) {
            IDesignClipboardCopy next = (IDesignClipboardCopy)designEntityCopies.next();
            result = next.canPaste(parent);
        }
        return result;
    }

    protected final void pasteDesignEntityCopies(Entity parent, Map substitutionMap) {
        Iterator designCopies = this.myDesignEntityCopies.iterator();
        while (designCopies.hasNext()) {
            IDesignClipboardCopy next = (IDesignClipboardCopy)designCopies.next();
            next.pasteBaseElements(parent, substitutionMap);
        }
    }

    public final Entity paste(Entity parent) {
        HashMap substitutionMap = new HashMap();
        if (this.pasteBaseElements(parent, substitutionMap) != null) {
            this.pasteDerivedElements(parent, substitutionMap);
            this.pasteTertiaryElements(parent, substitutionMap);
        }
        return this.myPastedResult;
    }

    public final void pasteDerivedElements(Entity parent, Map substitutionMap) {
        Iterator designCopies = this.myDesignEntityCopies.iterator();
        while (designCopies.hasNext()) {
            IDesignClipboardCopy next = (IDesignClipboardCopy)designCopies.next();
            next.pasteDerivedElements(parent, substitutionMap);
        }
    }

    public final void pasteTertiaryElements(Entity parent, Map substitutionMap) {
        Iterator designCopies = this.myDesignEntityCopies.iterator();
        while (designCopies.hasNext()) {
            IDesignClipboardCopy next = (IDesignClipboardCopy)designCopies.next();
            next.pasteTertiaryElements(parent, substitutionMap);
        }
        this.substituteReferences(substitutionMap);
        this.restoreCollection();
    }

    public final ReferenceCollection getReferenceCollectionTemplate() {
        return this.myRCInfo.getReferenceCollectionTemplate();
    }

    private void saveCollection(ReferenceCollection collection) {
        this.myRCInfo = new ReferenceCollectionTemplateInfo(collection);
        ReferenceEnumeration topLevelReferences = collection.references();
        while (topLevelReferences.hasMoreElements()) {
            Reference curTopLevel = topLevelReferences.next();
            if (!this.shouldSaveTopLevelReference(curTopLevel)) continue;
            ReferenceTemplateInfo curInfo = this.saveReference(curTopLevel);
            Assert.isNotNull((Object)curInfo);
            Assert.isLegal((this.myRCInfo.getChildInfo(curInfo.getOriginalUin()) == null ? 1 : 0) != 0);
            this.myRCInfo.addChildInfo(curInfo);
        }
    }

    private ReferenceTemplateInfo saveReference(Reference original) {
        ReferenceTemplateInfo result = new ReferenceTemplateInfo(original);
        ReferenceEnumeration subRefs = original.references();
        while (subRefs.hasMoreElements()) {
            Reference curSubRef = subRefs.next();
            ReferenceTemplateInfo curSubInfo = this.saveReference(curSubRef);
            Assert.isLegal((result.getChildInfo(curSubInfo.getOriginalUin()) == null ? 1 : 0) != 0);
            result.addChildInfo(curSubInfo);
        }
        return result;
    }

    private void restoreCollection() {
        if (this.myRCInfo != null && this.myPastedResult != null) {
            this.restoreCollection(this.myPastedResult, this.myRCInfo);
        }
    }

    private void substituteReferences(Map substitutionMap) {
        this.myRCInfo.substituteInnerTemplates(substitutionMap);
    }

    private void restoreCollection(ReferenceCollection clone, ReferenceCollectionTemplateInfo rcInfo) {
        if (clone != null && rcInfo != null) {
            AbstractDiagramSaver.restoreProperties((Element)clone, (Element)rcInfo.getReferenceCollectionTemplate());
            this.restoreChildReferences((ReferenceContainer)clone, rcInfo);
        }
    }

    private void restoreChildReferences(ReferenceContainer parentClone, TemplateInfo parentInfo) {
        ReferenceEnumeration existsClonedChildren = parentClone.references();
        while (existsClonedChildren.hasMoreElements()) {
            Reference curExistsClone = existsClonedChildren.next();
            UniqueName curEntityUin = ((ReferenceUniqueName)curExistsClone.getUniqueName()).getReferencedUniqueName();
            ReferenceTemplateInfo infoForExistsClone = (ReferenceTemplateInfo)parentInfo.removeChildInfo(curEntityUin);
            if (infoForExistsClone == null) continue;
            Reference templateForExistsClone = infoForExistsClone.getReferenceTemplate();
            AbstractDiagramSaver.restoreProperties((Element)curExistsClone, (Element)templateForExistsClone);
            this.restoreChildReferences((ReferenceContainer)curExistsClone, infoForExistsClone);
        }
        TemplateInfo[] shortcutInfos = parentInfo.getAllChildInfos();
        int i = 0;
        while (i < shortcutInfos.length) {
            Reference childClone;
            ReferenceTemplateInfo curShortcutInfo = (ReferenceTemplateInfo)shortcutInfos[i];
            Reference curShortcutTemplate = curShortcutInfo.getReferenceTemplate();
            Entity curShortcutedEntity = this.myCachedModel.findEntity(curShortcutInfo.getOriginalUin());
            if (curShortcutedEntity != null && !curShortcutedEntity.isDeleted() && (childClone = parentClone.addReference(curShortcutedEntity, curShortcutTemplate)) != null) {
                this.restoreChildReferences((ReferenceContainer)childClone, curShortcutInfo);
            }
            ++i;
        }
    }

    private static void restoreProperties(Element clone, Element template) {
        if (template == null) {
            return;
        }
        PropertyEnumeration cachedProperties = template.properties();
        while (cachedProperties.hasMoreElements()) {
            Property curCached = cachedProperties.next();
            AbstractDiagramSaver.restoreProperty(clone, curCached);
        }
    }

    private static void restoreProperty(Element clone, Property cachedProperty) {
        String name = cachedProperty.getName();
        String value = cachedProperty.getValue();
        if (!clone.hasProperty(name)) {
            clone.setPropertyValue(name, value);
        } else if (!clone.hasPropertyValue(name, value)) {
            clone.addProperty(name, value);
        }
    }

    private static class MovedDeltaInfo {
        private IRootRelativePath myOriginalFolder;
        private UniqueName myOriginalDiagramUin;

        public MovedDeltaInfo(ReferenceCollection original) {
            this.myOriginalDiagramUin = original.getUniqueName();
            this.myOriginalFolder = MovedDeltaInfo.extractParentPath(original);
        }

        public void registerMovedDelta(ReferenceCollection pastedResult) {
            if (pastedResult == null || this.myOriginalFolder == null || this.myOriginalDiagramUin == null) {
                return;
            }
            IRootRelativePath newFolderPath = MovedDeltaInfo.extractParentPath(pastedResult);
            if (newFolderPath == null) {
                return;
            }
            MovedDiagramDeltaProvider.diagramMoved((Model)pastedResult.getModel(), (IRootRelativePath)this.myOriginalFolder, (UniqueName)this.myOriginalDiagramUin, (IRootRelativePath)newFolderPath, (UniqueName)pastedResult.getUniqueName(), (boolean)false);
        }

        public void dispose() {
            this.myOriginalDiagramUin = null;
            this.myOriginalFolder = null;
        }

        private static IRootManager getRootManager(Model model) {
            IProject project = ModelUinSupport.getProject((UniqueName)model.getUniqueName());
            if (project == null || !project.isAccessible()) {
                return null;
            }
            return RootManagerAccess.getRootManager((IProject)project);
        }

        private static IRootRelativePath extractParentPath(ReferenceCollection original) {
            Entity parent = original.getParent();
            if (parent instanceof Model) {
                return null;
            }
            IRootManager rootManager = MovedDeltaInfo.getRootManager(original.getModel());
            if (rootManager == null || !"Package".equals(parent.getPropertyValue("$metaclass"))) {
                return null;
            }
            return rootManager.extractRootRelativePath(parent.getUniqueName());
        }
    }
}

