/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.various.DiagramPropertySet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ReferenceInheritedPropertyProvider
implements PropertyGetProvider,
ModelAware {
    private Model myModel;
    private Set myPropertyNamesSet = new HashSet();

    public ReferenceInheritedPropertyProvider() {
        int i = 0;
        while (i < DiagramPropertySet.REFERENCES_INHERITED_PROPERTIES.length) {
            this.myPropertyNamesSet.add(DiagramPropertySet.REFERENCES_INHERITED_PROPERTIES[i]);
            ++i;
        }
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        Entity referencedElement = this.instantiate(element);
        if (referencedElement == null) {
            return null;
        }
        return referencedElement.getPropertyValue(propertyName);
    }

    public Property getProperty(Element element, String propertyName) {
        Entity referencedElement = this.instantiate(element);
        if (referencedElement == null) {
            return null;
        }
        return referencedElement.getProperty(propertyName);
    }

    public boolean hasProperty(Element element, String propertyName) {
        Entity referencedElement = this.instantiate(element);
        if (referencedElement == null) {
            return false;
        }
        return referencedElement.hasProperty(propertyName);
    }

    public PropertyEnumeration properties(Element element) {
        Entity referencedElement = this.instantiate(element);
        if (referencedElement == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        LinkedList properties = new LinkedList();
        Iterator applicablePropertyNames = this.myPropertyNamesSet.iterator();
        while (applicablePropertyNames.hasNext()) {
            String curPropertyName = (String)applicablePropertyNames.next();
            PropertyEnumeration propertiesFromElement = referencedElement.properties(curPropertyName);
            while (propertiesFromElement.hasMoreElements()) {
                properties.add(propertiesFromElement.nextElement());
            }
        }
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(properties));
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Entity referencedElement = this.instantiate(element);
        if (referencedElement == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        return referencedElement.properties(propertyName);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        Entity referencedElement = this.instantiate(element);
        if (referencedElement == null) {
            return false;
        }
        return referencedElement.hasPropertyValue(propertyName, propertyValue);
    }

    private Entity instantiate(Element reference) {
        Entity result = ((Reference)reference).getEntity();
        return result == null || result.isDeleted() ? null : result;
    }

    private Model getModel() {
        return this.myModel;
    }

    public void registered(Model model) {
        this.myModel = model;
    }

    public void unregistered(Model model) {
        Assert.isLegal((boolean)model.getUniqueName().equals(this.myModel.getUniqueName()), (String)(this + " was unregistered in the wrong model : " + model.getUniqueName()));
        this.myModel = null;
    }
}

