/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiagramUtil {
    public static final IContainer getDiagramFolder(Entity diagramNode) {
        IProject project;
        String relativePathAsString = diagramNode.getPropertyValue("$diagram_folder");
        if (relativePathAsString == null) {
            return null;
        }
        String projectName = diagramNode.getPropertyValue("$diagram_project");
        if (projectName == null) {
            projectName = ModelUinSupport.getProjectId((UniqueName)diagramNode.getModel().getUniqueName());
        }
        if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null) {
            return null;
        }
        return DesignRootAccess.getInstance((IProject)project).createUnderDesignRoot((IPath)new Path(relativePathAsString));
    }

    public static boolean hasDesignProperty(DesignNotion notion, String propertyName) {
        DesignProperty[] properties = notion.getProperties(propertyName);
        return properties.length > 0;
    }

    public static boolean hasDesignPropertyValue(DesignNotion notion, String propertyName, String propertyValue) {
        DesignProperty[] properties = notion.getProperties(propertyName);
        int i = 0;
        while (i < properties.length) {
            if (propertyValue.equals(properties[i].getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean shouldChildDiagramKnowParent(Entity parent) {
        return !parent.hasProperty("$moveableDiagramParent");
    }

    private static String capitalizeFirstLetter(String string) {
        String firstLetter = string.substring(0, 1);
        return firstLetter.toUpperCase() + string.substring(1);
    }

    public static DesignView createDefaultDiagram(NodeSetCache cache, Entity parent) {
        String notFinalMetaclass = parent.getPropertyValue("$meta:child:referenceCollection");
        if (notFinalMetaclass == null) {
            notFinalMetaclass = "Package Diagram";
        }
        String metaclass = notFinalMetaclass;
        String name = null;
        return DiagramUtil.internalCreateView(cache, parent, metaclass, name, true);
    }

    public static DesignView createCustomDiagram(NodeSetCache cache, Entity parent, String shapeType) {
        String name = NameUtil.getNewName((Entity)parent, (String)shapeType, null);
        return DiagramUtil.internalCreateView(cache, parent, shapeType, name, false);
    }

    private static DesignView internalCreateView(NodeSetCache cache, final Entity parent, final String shapeType, String name, final boolean isDefault) {
        final String newDesignId = "V" + NameUtil.newDesignId((String)shapeType);
        IContainer folder = DiagramUtil.getDiagramFolder(parent);
        final DesignNodeSet nodeSet = cache.getNamingStrategy().getDiagramNodeSet(parent, folder, shapeType, name);
        final DesignView[] createdView = new DesignView[1];
        nodeSet.runCommand(new Runnable(){

            public void run() {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("$metaclass", shapeType);
                if (isDefault) {
                    properties.put("$defaultDiagram", "true");
                }
                if (DiagramUtil.shouldChildDiagramKnowParent(parent)) {
                    properties.put("$parentUin", parent.getUniqueName().toString());
                }
                createdView[0] = nodeSet.createChildView(newDesignId, properties, !isDefault);
                if (isDefault) {
                    nodeSet.internallyChanged(false);
                }
            }
        });
        return createdView[0];
    }

    public static int collectChildDiagramViews(NodeSetCache cache, Entity parent, List result) {
        result.clear();
        IContainer folder = DiagramUtil.getDiagramFolder(parent);
        if (folder == null || !folder.exists()) {
            return -1;
        }
        DesignNodeSet[] nodeSets = cache.nodeSets(folder);
        int defaultDiagramIndex = 0;
        DesignView defaultDiagram = null;
        int i = 0;
        while (i < nodeSets.length) {
            DesignNodeSet curNodeSet = nodeSets[i];
            if (curNodeSet.getParent() == null) {
                Iterator members = curNodeSet.iterator();
                while (members.hasNext()) {
                    DesignView curView;
                    DesignElement curChild = (DesignElement)members.next();
                    if (!(curChild instanceof DesignView) || !DiagramUtil.isChildOfThisParent(parent, curView = (DesignView)curChild)) continue;
                    result.add(curView);
                    if (!DiagramUtil.isDefaultDiagram(curView)) continue;
                    if (defaultDiagram != null) {
                        System.err.println("SEVERAL DEFAULT DIAGRAM FILES FOUNDED in parent :" + parent.getUniqueName() + "\n first: " + curView.getId() + "\n second: " + defaultDiagram.getId());
                    }
                    defaultDiagram = curView;
                    defaultDiagramIndex = result.size() - 1;
                }
            }
            ++i;
        }
        if (defaultDiagram == null) {
            defaultDiagram = DiagramUtil.createDefaultDiagram(cache, parent);
            result.add(defaultDiagram);
            defaultDiagramIndex = result.size() - 1;
        }
        return defaultDiagramIndex;
    }

    protected static boolean isDefaultDiagram(DesignView view) {
        return DiagramUtil.hasDesignProperty((DesignNotion)view, "$defaultDiagram");
    }

    protected static boolean isChildOfThisParent(Entity parent, DesignView view) {
        if (DiagramUtil.shouldChildDiagramKnowParent(parent)) {
            return DiagramUtil.hasDesignPropertyValue((DesignNotion)view, "$parentUin", parent.getUniqueName().toString());
        }
        return !DiagramUtil.hasDesignProperty((DesignNotion)view, "$parentUin");
    }
}

