/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.property.IDesignPropertySetValidator;
import com.tssap.selena.internal.dom.providers.AbstractPropertyProvider;
import com.tssap.selena.internal.dom.providers.DesignPropertyAdapter;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.internal.dom.providers.PropertySetRegistry;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.extension.TemplateProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class DiagramPropertyProvider
extends AbstractPropertyProvider
implements PropertyGetProvider,
PropertySetProvider,
TemplateProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return super.isPropertyProviderApplicable(element, propertyName) && NameUtil.isDesignViewUin((UniqueName)element.getUniqueName()) && !"$name".equals(propertyName);
    }

    public boolean isTemplateProviderApplicable(Element original) {
        return this.isPropertyProviderApplicable(original, null);
    }

    public void buildTemplate(Element original, Element template) {
        DesignProperty[] properties;
        DesignNotion owner = this.getPropertyOwner(original);
        if (owner != null && (properties = owner.getProperties()) != null && properties.length > 0) {
            int i = 0;
            while (i < properties.length) {
                DesignProperty next = properties[i];
                if (next.getName() != null && next.getValue() != null) {
                    template.addProperty(next.getName(), next.getValue());
                }
                ++i;
            }
        }
    }

    public String getPropertyValue(Element element, String propertyName) {
        DesignProperty[] properties;
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null && (properties = owner.getProperties(propertyName)) != null && properties.length > 0) {
            return properties[0].getValue();
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        DesignProperty[] properties;
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null && (properties = owner.getProperties(propertyName)) != null && properties.length > 0) {
            return new DesignPropertyAdapter(properties[0], element);
        }
        return null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            DesignProperty[] properties = owner.getProperties(propertyName);
            return properties != null && properties.length > 0;
        }
        return false;
    }

    public PropertyEnumeration properties(Element element) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            return this.properties(owner.getProperties(), element);
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            return this.properties(owner.getProperties(propertyName), element);
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    private PropertyEnumeration properties(DesignProperty[] properties, Element element) {
        ArrayList<DesignPropertyAdapter> result = new ArrayList<DesignPropertyAdapter>();
        int i = 0;
        while (i < properties.length) {
            result.add(new DesignPropertyAdapter(properties[i], element));
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(result));
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            DesignProperty[] properties = owner.getProperties(propertyName);
            int i = 0;
            while (i < properties.length) {
                if (propertyValue.equals(properties[i].getValue())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        if (this.isReadOnly((Entity)element)) {
            return false;
        }
        String metaclass = this.getMetaclass(element);
        if (metaclass == null) {
            return false;
        }
        if (PropertySetRegistry.getInstance().isMutableProperty(propertyName, metaclass)) {
            IDesignPropertySetValidator validator = PropertySetRegistry.getInstance().getValidator(propertyName);
            return validator == null || validator.isValidValue(element, propertyName, propertyValue);
        }
        return false;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        if (this.isReadOnly((Entity)element)) {
            return false;
        }
        String metaclass = this.getMetaclass(element);
        if (metaclass == null) {
            return false;
        }
        if (!PropertySetRegistry.getInstance().isMutableProperty(propertyName, metaclass)) {
            return false;
        }
        if (!PropertySetRegistry.getInstance().isMultivaluedProperty(propertyName, metaclass)) {
            return !this.hasProperty(element, propertyName);
        }
        IDesignPropertySetValidator validator = PropertySetRegistry.getInstance().getValidator(propertyName);
        return validator == null || validator.isValidValue(element, propertyName, propertyValue);
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner == null) {
            return;
        }
        final DesignProperty[] properties = owner.getProperties(propertyName);
        if (properties == null || properties.length == 0) {
            if (propertyValue != null) {
                owner.createProperty(propertyName, propertyValue);
            }
        } else if (propertyValue == null) {
            owner.runCommand(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < properties.length) {
                        properties[i].delete();
                        ++i;
                    }
                }
            });
        } else {
            properties[0].setValue(propertyValue);
        }
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner == null) {
            return null;
        }
        return new DesignPropertyAdapter(owner.createProperty(propertyName, propertyValue), element);
    }

    protected String getMetaclass(Element element) {
        DesignNotion propertyOwner = this.getPropertyOwner(element);
        if (propertyOwner == null) {
            return null;
        }
        DesignProperty[] metaclasses = propertyOwner.getProperties("$metaclass");
        if (metaclasses == null || metaclasses.length == 0) {
            return null;
        }
        return metaclasses[0].getValue();
    }
}

