/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.internal.dom.providers.AbstractPropertyProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.extension.TemplateProvider;
import com.tssap.selena.model.providers.internal.rc.DiagramUtil;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class DiagramNamePropertyProvider
extends AbstractPropertyProvider
implements PropertyGetProvider,
PropertySetProvider,
TemplateProvider {
    private static final int DOT_LENGTH = ".".length();

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return super.isPropertyProviderApplicable(element, propertyName) && NameUtil.isDesignViewUin((UniqueName)element.getUniqueName());
    }

    public boolean isTemplateProviderApplicable(Element original) {
        return NameUtil.isDesignViewUin((UniqueName)original.getUniqueName());
    }

    public String getPropertyValue(Element element, String propertyName) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (!(owner instanceof DesignView)) {
            return null;
        }
        if (DiagramUtil.hasDesignProperty(owner, "$defaultDiagram")) {
            Entity parent = element.getParent();
            String result = parent.getPropertyValue("$default_diagram_name");
            if (result != null) {
                return result;
            }
            return parent.getPropertyValue("$name");
        }
        IFile diagramFile = owner.getNodeSet().getFile();
        if (diagramFile == null) {
            return null;
        }
        String fileName = diagramFile.getFullPath().removeFileExtension().lastSegment();
        return fileName;
    }

    public Property getProperty(Element element, String propertyName) {
        String result = this.getPropertyValue(element, propertyName);
        return result == null ? null : new PropertyAdapter(propertyName, result, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$name");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property result = this.getProperty(element, propertyName);
        if (result != null) {
            return SingleEnumeration.createPropertyEnumeration((Property)result);
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return false;
        }
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner == null || this.isReadOnly(owner)) {
            return false;
        }
        if (DiagramUtil.hasDesignProperty(owner, "$defaultDiagram")) {
            Entity parent = element.getParent();
            if (parent.hasProperty("$default_diagram_name")) {
                return parent.canSetPropertyValue("$default_diagram_name", propertyValue);
            }
            return parent.canSetPropertyValue(propertyName, propertyValue);
        }
        if (this.checkName(propertyValue)) {
            IFile diagramFile = owner.getNodeSet().getFile();
            IPath newPath = DiagramNamePropertyProvider.getRenamedPath(diagramFile, propertyValue);
            if (newPath != null && newPath.equals((Object)diagramFile.getFullPath())) {
                return true;
            }
            return newPath != null && newPath.segmentCount() == diagramFile.getFullPath().segmentCount() && newPath.getFileExtension().equals(diagramFile.getFileExtension()) && newPath.removeLastSegments(1).equals((Object)diagramFile.getFullPath().removeLastSegments(1)) && this.getCache().canRenameDesignFile(diagramFile, newPath);
        }
        return false;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner == null) {
            return;
        }
        if (DiagramUtil.hasDesignProperty(owner, "$defaultDiagram")) {
            Entity parent = element.getParent();
            if (parent.hasProperty("$default_diagram_name")) {
                parent.setPropertyValue("$default_diagram_name", propertyValue);
            } else {
                parent.setPropertyValue(propertyName, propertyValue);
            }
        } else {
            IFile diagramFile = owner.getNodeSet().getFile();
            IPath newPath = DiagramNamePropertyProvider.getRenamedPath(diagramFile, propertyValue);
            if (newPath.equals((Object)diagramFile.getFullPath())) {
                return;
            }
            this.getCache().renameDesignFile(diagramFile, newPath);
        }
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public void buildTemplate(Element original, Element template) {
        String originalName = this.getPropertyValue(original, "$name");
        template.setPropertyValue("$name", originalName);
    }

    private static String getFileName(IFile diagramFile) {
        if (diagramFile == null) {
            return null;
        }
        String extension = diagramFile.getFileExtension();
        String fileName = diagramFile.getFullPath().lastSegment();
        return fileName.substring(0, fileName.length() - DOT_LENGTH - extension.length());
    }

    private boolean checkName(String name) {
        if (name == null) {
            return false;
        }
        String normalizedName = this.getCache().getNamingStrategy().normalizeForFileSystem(name);
        boolean result = name.equals(normalizedName);
        if (!result) {
            System.err.println("Can not set name for diagram: " + name);
            System.err.println("normalized variant: " + normalizedName);
        }
        return result;
    }

    private static IPath getRenamedPath(IFile diagramFile, String newName) {
        String oldExtension = diagramFile.getFileExtension();
        return diagramFile.getFullPath().removeLastSegments(1).append(newName).addFileExtension(oldExtension);
    }
}

