/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.providers.AbstractDesignExistenceProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ReferenceCollectionExistenceProvider;
import com.tssap.selena.model.providers.internal.rc.DiagramUtil;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class DiagramExistenceProvider
extends AbstractDesignExistenceProvider
implements ReferenceCollectionExistenceProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, ReferenceCollection template) {
        return DiagramUtil.getDiagramFolder(parent) != null && DiagramExistenceProvider.isApplicableShapeType(parent, shapeType);
    }

    private static boolean isApplicableShapeType(Entity parent, String shapeType) {
        return parent.hasPropertyValue("$meta:child:referenceCollection", shapeType);
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, ReferenceCollection template) {
        DesignView createdView = DiagramUtil.createCustomDiagram(this.getCache(), parent, shapeType);
        return NameUtil.getUniqueName((DesignElement)createdView);
    }

    public boolean exists(UniqueName uniqueName) {
        DesignElement element = this.getDesignElement(uniqueName);
        if (element instanceof DesignView) {
            DesignProperty[] parentUins = element.getProperties("$parentUin");
            return parentUins.length == 0 || this.checkKnownParentExists((DesignView)element, parentUins[0].getValue());
        }
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return super.isDeleteProviderApplicable(element) && NameUtil.isDesignViewUin((UniqueName)element.getUniqueName());
    }

    public boolean canDelete(Element element) {
        if (!super.canDelete(element)) {
            return false;
        }
        return !DiagramUtil.hasDesignProperty((DesignNotion)this.getDesignElement(element.getUniqueName()), "$defaultDiagram");
    }

    public void delete(final Element element) {
        ModelAccess.runCommand((Runnable)new UndoTransparableCommand(){

            public void run() {
                DesignReference next;
                DesignView designView = (DesignView)NameUtil.getElement((NodeSetCache)DiagramExistenceProvider.super.getCache(), (UniqueName)element.getUniqueName());
                LinkedList<Entity> referencedEntities = null;
                Model model = ModelAccess.getModel((UniqueName)DiagramExistenceProvider.this.getModelUin());
                if (DiagramExistenceProvider.this.shouldDeleteElementsWithDiagram(element, designView)) {
                    Iterator<DesignReference> designReferences = Arrays.asList(designView.getReferences()).iterator();
                    while (designReferences.hasNext()) {
                        UniqueName entityUin;
                        Entity entity;
                        next = designReferences.next();
                        if (DiagramUtil.hasDesignProperty((DesignNotion)next, "$imported") || (entity = model.findEntity(entityUin = ModelAccess.createUniqueName((String)next.getProxyId()))) == null || entity.isDeleted() || !entity.canDelete()) continue;
                        if (referencedEntities == null) {
                            referencedEntities = new LinkedList<Entity>();
                        }
                        referencedEntities.add(entity);
                    }
                }
                DiagramExistenceProvider.super.delete(element);
                if (referencedEntities != null) {
                    Iterator entities = referencedEntities.iterator();
                    while (entities.hasNext()) {
                        next = (Entity)entities.next();
                        if (next.isDeleted()) continue;
                        next.delete();
                    }
                }
            }
        });
    }

    private boolean shouldDeleteElementsWithDiagram(Element collection, DesignView designView) {
        if (DiagramUtil.hasDesignProperty((DesignNotion)designView, "$defaultDiagram")) {
            return false;
        }
        if (collection.hasProperty("automaticallySynchronized")) {
            return false;
        }
        return !DiagramUtil.hasDesignPropertyValue((DesignNotion)designView, "$metaclass", "Class Diagram");
    }

    private Model getModel() {
        return ModelAccess.getModel((UniqueName)this.getModelUin());
    }

    private boolean checkKnownParentExists(DesignView designView, String knownParentUinStr) {
        Entity parent;
        UniqueName knownParentUin;
        return knownParentUinStr != null && (knownParentUin = ModelAccess.createUniqueName((String)knownParentUinStr)) != null && (parent = this.getModel().findEntity(knownParentUin)) != null && !parent.isDeleted();
    }
}

