/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.dom.DesignView;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.providers.rc.RCSupportPlugin;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;

public class AutomaticallySynchronizedPropertyProvider
extends AbstractDesignProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (propertyName == null || "automaticallySynchronized".equals(propertyName)) {
            return element instanceof ReferenceCollection && this.getDesignElement(((ReferenceCollection)element).getUniqueName()) instanceof DesignView;
        }
        return false;
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public boolean hasProperty(Element element, String propertyName) {
        String metaclass = element.getPropertyValue("$metaclass");
        return RCSupportPlugin.getDefault().shouldBeSynchronized(metaclass);
    }

    public String getPropertyValue(Element element, String propertyName) {
        return this.hasProperty(element, propertyName) ? "" : null;
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    public PropertyEnumeration properties(Element element) {
        Property property = this.getProperty(element, "automaticallySynchronized");
        if (property == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        return SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return this.properties(element);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue != null && propertyValue.equals(this.getPropertyValue(element, propertyName));
    }
}

