/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.rc;

import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.providers.internal.rc.DiagramUtil;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.HashMap;

public class ActiveDiagramUinPropertyProvider
extends AbstractDesignProvider
implements PropertyGetProvider,
PropertySetProvider {
    private HashMap myValuesMap;

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (propertyName == null || "$ActiveDiagramUIN".equals(propertyName)) {
            return element instanceof Entity && DiagramUtil.getDiagramFolder((Entity)element) != null;
        }
        return false;
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        return (String)this.myValuesMap.get(element.getUniqueName());
    }

    public Property getProperty(Element element, String propertyName) {
        String value = this.getPropertyValue(element, propertyName);
        if (value == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, value, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getProperty(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$ActiveDiagramUIN");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        if (property == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        return SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public boolean isPropertyWritable(Element element, String propertyName) {
        return true;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            this.myValuesMap.remove(element.getUniqueName());
        } else {
            this.myValuesMap.put(element.getUniqueName(), propertyValue);
        }
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }

    public void registered(Model model) {
        super.registered(model);
        this.myValuesMap = new HashMap();
    }

    public void unregistered(Model model) {
        super.unregistered(model);
        this.myValuesMap.clear();
        this.myValuesMap = null;
    }
}

