/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.RecordStore;
import org.apache.batik.transcoder.wmf.tosvg.WMFPainter;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLFilter;

public class WMFTranscoder
extends AbstractTranscoder
implements SVGConstants {
    public static final int WMF_TRANSCODER_ERROR_BASE = 65280;
    public static final int ERROR_NULL_INPUT = 65280;
    public static final int ERROR_INCOMPATIBLE_INPUT_TYPE = 65281;
    public static final int ERROR_INCOMPATIBLE_OUTPUT_TYPE = 65282;
    public static final String USAGE = "The WMFTranscoder converts a WMF document into an SVG document. \nThis simple application generates SVG documents that have the same name, but a where the .wmf extension \nis replaced with .svg. To run the application, type the following at the command line: \njava org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder fileName [fileName]+";
    public static final String WMF_EXTENSION = ".wmf";
    public static final String SVG_EXTENSION = ".svg";

    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        DataInputStream dataInputStream = this.getCompatibleInput(transcoderInput);
        WMFRecordStore wMFRecordStore = new WMFRecordStore();
        try {
            ((RecordStore)wMFRecordStore).read(dataInputStream);
        }
        catch (IOException iOException) {
            this.handler.fatalError(new TranscoderException(iOException));
            return;
        }
        WMFPainter wMFPainter = new WMFPainter(wMFRecordStore);
        DOMImplementation dOMImplementation = ExtensibleSVGDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        wMFPainter.paint((Graphics)sVGGraphics2D);
        int n = wMFRecordStore.getVpX();
        int n2 = wMFRecordStore.getVpY();
        int n3 = wMFRecordStore.getVpW();
        int n4 = wMFRecordStore.getVpH();
        sVGGraphics2D.setSVGCanvasSize(new Dimension(n3, n4));
        Element element = sVGGraphics2D.getRoot();
        element.setAttributeNS(null, "viewBox", "" + n + " " + n2 + " " + n3 + " " + n4);
        this.writeSVGToOutput(sVGGraphics2D, element, transcoderOutput);
    }

    private void writeSVGToOutput(SVGGraphics2D sVGGraphics2D, Element element, TranscoderOutput transcoderOutput) throws TranscoderException {
        block9: {
            Document document;
            XMLFilter xMLFilter = transcoderOutput.getXMLFilter();
            if (xMLFilter != null) {
                this.handler.fatalError(new TranscoderException("65282"));
            }
            if ((document = transcoderOutput.getDocument()) != null) {
                this.handler.fatalError(new TranscoderException("65282"));
            }
            try {
                OutputStream outputStream = transcoderOutput.getOutputStream();
                if (outputStream != null) {
                    sVGGraphics2D.stream(element, (Writer)new OutputStreamWriter(outputStream));
                    return;
                }
                Writer writer = transcoderOutput.getWriter();
                if (writer != null) {
                    sVGGraphics2D.stream(element, writer);
                    return;
                }
                String string = transcoderOutput.getURI();
                if (string == null) break block9;
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    outputStream = uRLConnection.getOutputStream();
                    sVGGraphics2D.stream(element, (Writer)new OutputStreamWriter(outputStream));
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    this.handler.fatalError(new TranscoderException(malformedURLException));
                }
                catch (IOException iOException) {
                    this.handler.fatalError(new TranscoderException(iOException));
                }
            }
            catch (IOException iOException) {
                throw new TranscoderException(iOException);
            }
        }
        throw new TranscoderException("65282");
    }

    private DataInputStream getCompatibleInput(TranscoderInput transcoderInput) throws TranscoderException {
        InputStream inputStream;
        if (transcoderInput == null) {
            this.handler.fatalError(new TranscoderException("65280"));
        }
        if ((inputStream = transcoderInput.getInputStream()) != null) {
            return new DataInputStream(new BufferedInputStream(inputStream));
        }
        String string = transcoderInput.getURI();
        if (string != null) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
                return new DataInputStream(new BufferedInputStream(inputStream));
            }
            catch (MalformedURLException malformedURLException) {
                this.handler.fatalError(new TranscoderException(malformedURLException));
            }
            catch (IOException iOException) {
                this.handler.fatalError(new TranscoderException(iOException));
            }
        }
        this.handler.fatalError(new TranscoderException("65281"));
        return null;
    }

    public static void main(String[] stringArray) throws TranscoderException {
        if (stringArray.length < 1) {
            System.err.println(USAGE);
            System.exit(1);
        }
        WMFTranscoder wMFTranscoder = new WMFTranscoder();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!string.toLowerCase().endsWith(WMF_EXTENSION)) {
                System.err.println(stringArray[n2] + " does not have the " + WMF_EXTENSION + " extension. It is ignored");
            } else {
                System.out.print("Processing : " + stringArray[n2] + "...");
                String string2 = string.substring(0, string.toLowerCase().indexOf(WMF_EXTENSION)) + SVG_EXTENSION;
                File file = new File(string);
                File file2 = new File(string2);
                try {
                    TranscoderInput transcoderInput = new TranscoderInput(file.toURL().toString());
                    TranscoderOutput transcoderOutput = new TranscoderOutput(new FileOutputStream(file2));
                    wMFTranscoder.transcode(transcoderInput, transcoderOutput);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new TranscoderException(malformedURLException);
                }
                catch (IOException iOException) {
                    throw new TranscoderException(iOException);
                }
                System.out.println(".... Done");
            }
            ++n2;
        }
        System.exit(0);
    }
}

