/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.LengthKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.apache.batik.transcoder.keys.Rectangle2DKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGSVGElement;

public abstract class ImageTranscoder
extends XMLAbstractTranscoder {
    protected UserAgent userAgent = new ImageTranscoderUserAgent();
    protected static final Set FEATURES = new HashSet();
    public static final TranscodingHints.Key KEY_EXECUTE_ONLOAD;
    public static final TranscodingHints.Key KEY_WIDTH;
    public static final TranscodingHints.Key KEY_HEIGHT;
    public static final TranscodingHints.Key KEY_AOI;
    public static final TranscodingHints.Key KEY_LANGUAGE;
    public static final TranscodingHints.Key KEY_MEDIA;
    public static final TranscodingHints.Key KEY_ALTERNATE_STYLESHEET;
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI;
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM;
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR;
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE;
    public static final TranscodingHints.Key KEY_ALLOWED_SCRIPT_TYPES;
    public static final String DEFAULT_ALLOWED_SCRIPT_TYPES = "text/ecmascript, application/java-archive";
    public static final TranscodingHints.Key KEY_CONSTRAIN_SCRIPT_ORIGIN;

    protected ImageTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, ExtensibleSVGDOMImplementation.getDOMImplementation());
        this.hints.put(KEY_MEDIA, "screen");
        this.hints.put(KEY_EXECUTE_ONLOAD, Boolean.FALSE);
        this.hints.put(KEY_ALLOWED_SCRIPT_TYPES, DEFAULT_ALLOWED_SCRIPT_TYPES);
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        AffineTransform affineTransform;
        float f;
        float f2;
        GraphicsNode graphicsNode;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage("notsvg", null));
        }
        BridgeContext bridgeContext = new BridgeContext(this.userAgent);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        SVGSVGElement sVGSVGElement = sVGOMDocument.getRootElement();
        GVTBuilder gVTBuilder = new GVTBuilder();
        ConcreteImageRendererFactory concreteImageRendererFactory = new ConcreteImageRendererFactory();
        boolean bl = this.hints.containsKey(KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get(KEY_EXECUTE_ONLOAD) != false && BaseScriptingEnvironment.isDynamicDocument((Document)sVGOMDocument);
        bridgeContext.setDynamic(bl);
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, (Document)sVGOMDocument);
            if (bridgeContext.isDynamic()) {
                BaseScriptingEnvironment baseScriptingEnvironment = new BaseScriptingEnvironment(bridgeContext);
                baseScriptingEnvironment.loadScripts();
                baseScriptingEnvironment.dispatchSVGLoadEvent();
            }
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException((Exception)((Object)bridgeException));
        }
        float f3 = (float)bridgeContext.getDocumentSize().getWidth();
        float f4 = (float)bridgeContext.getDocumentSize().getHeight();
        bridgeContext = null;
        gVTBuilder = null;
        float f5 = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            f6 = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (f5 > 0.0f && f6 > 0.0f) {
            f2 = f5;
            f = f6;
        } else if (f6 > 0.0f) {
            f2 = f3 * f6 / f4;
            f = f6;
        } else if (f5 > 0.0f) {
            f2 = f5;
            f = f4 * f5 / f3;
        } else {
            f2 = f3;
            f = f4;
        }
        String string2 = null;
        try {
            string2 = new URL(string).getRef();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            affineTransform = ViewBox.getViewTransform((String)string2, (Element)sVGSVGElement, (float)f2, (float)f);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException((Exception)((Object)bridgeException));
        }
        if (affineTransform.isIdentity() && (f2 != f3 || f != f4)) {
            float f7 = Math.max(f3, f4);
            float f8 = Math.max(f2, f);
            float f9 = f8 / f7;
            affineTransform = AffineTransform.getScaleInstance(f9, f9);
        }
        if (this.hints.containsKey(KEY_AOI)) {
            Rectangle2D rectangle2D = (Rectangle2D)this.hints.get(KEY_AOI);
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
            AffineTransform affineTransform2 = new AffineTransform();
            double d = (double)f2 / rectangle2D.getWidth();
            double d2 = (double)f / rectangle2D.getHeight();
            affineTransform2.scale(d, d2);
            double d3 = -rectangle2D.getX();
            double d4 = -rectangle2D.getY();
            affineTransform2.translate(d3, d4);
            affineTransform.preConcatenate(affineTransform2);
        }
        int n = (int)((double)f2 + 0.5);
        int n2 = (int)((double)f + 0.5);
        ImageRenderer imageRenderer = concreteImageRendererFactory.createStaticImageRenderer();
        imageRenderer.updateOffScreen(n, n2);
        imageRenderer.setTransform(affineTransform);
        imageRenderer.setTree(graphicsNode);
        graphicsNode = null;
        try {
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f2, f);
            imageRenderer.repaint(affineTransform.createInverse().createTransformedShape(float_));
            BufferedImage bufferedImage = imageRenderer.getOffScreen();
            imageRenderer = null;
            BufferedImage bufferedImage2 = this.createImage(n, n2);
            Graphics2D graphics2D = GraphicsUtil.createGraphics((BufferedImage)bufferedImage2);
            if (this.hints.containsKey(KEY_BACKGROUND_COLOR)) {
                Paint paint = (Paint)this.hints.get(KEY_BACKGROUND_COLOR);
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (bufferedImage != null) {
                graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
            }
            graphics2D.dispose();
            bufferedImage = null;
            this.writeImage(bufferedImage2, transcoderOutput);
        }
        catch (Exception exception) {
            throw new TranscoderException(exception);
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXSVGDocumentFactory(string);
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;

    static {
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
        KEY_EXECUTE_ONLOAD = new BooleanKey();
        KEY_WIDTH = new LengthKey();
        KEY_HEIGHT = new LengthKey();
        KEY_AOI = new Rectangle2DKey();
        KEY_LANGUAGE = new StringKey();
        KEY_MEDIA = new StringKey();
        KEY_ALTERNATE_STYLESHEET = new StringKey();
        KEY_USER_STYLESHEET_URI = new StringKey();
        KEY_PIXEL_TO_MM = new FloatKey();
        KEY_BACKGROUND_COLOR = new PaintKey();
        KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();
        KEY_ALLOWED_SCRIPT_TYPES = new StringKey();
        KEY_CONSTRAIN_SCRIPT_ORIGIN = new BooleanKey();
    }

    protected class ImageTranscoderUserAgent
    implements UserAgent {
        protected Vector scripts;
        protected Set extensions = new HashSet();

        protected ImageTranscoderUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String string) {
            try {
                ImageTranscoder.this.handler.error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception exception) {
            try {
                ImageTranscoder.this.handler.error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            try {
                ImageTranscoder.this.handler.warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void showAlert(String string) {
        }

        public String showPrompt(String string) {
            return null;
        }

        public String showPrompt(String string, String string2) {
            return null;
        }

        public boolean showConfirm(String string) {
            return false;
        }

        public float getPixelToMM() {
            if (ImageTranscoder.this.hints.containsKey(KEY_PIXEL_TO_MM)) {
                return ((Float)ImageTranscoder.this.hints.get(KEY_PIXEL_TO_MM)).floatValue();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            if (ImageTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)ImageTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            return (String)ImageTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
        }

        public String getXMLParserClassName() {
            if (ImageTranscoder.this.hints.containsKey(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME)) {
                return (String)ImageTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            return (Boolean)ImageTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
        }

        public String getMedia() {
            return (String)ImageTranscoder.this.hints.get(KEY_MEDIA);
        }

        public String getAlternateStyleSheet() {
            return (String)ImageTranscoder.this.hints.get(KEY_ALTERNATE_STYLESHEET);
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
        }

        public void setSVGCursor(Cursor cursor) {
        }

        public void runThread(Thread thread) {
        }

        public AffineTransform getTransform() {
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point();
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean supportExtension(String string) {
            return this.extensions.contains(string);
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.add(iterator.next());
            }
        }

        public void handleElement(Element element, Object object) {
        }

        public ScriptSecurity getScriptSecurity(String string, URL uRL, URL uRL2) {
            if (this.scripts == null) {
                this.computeAllowedScripts();
            }
            if (!this.scripts.contains(string)) {
                return new NoLoadScriptSecurity(string);
            }
            boolean bl = true;
            if (ImageTranscoder.this.hints.containsKey(KEY_CONSTRAIN_SCRIPT_ORIGIN)) {
                bl = (Boolean)ImageTranscoder.this.hints.get(KEY_CONSTRAIN_SCRIPT_ORIGIN);
            }
            if (bl) {
                return new DefaultScriptSecurity(string, uRL, uRL2);
            }
            return new RelaxedScriptSecurity(string, uRL, uRL2);
        }

        protected void computeAllowedScripts() {
            this.scripts = new Vector();
            if (!ImageTranscoder.this.hints.containsKey(KEY_ALLOWED_SCRIPT_TYPES)) {
                return;
            }
            String string = (String)ImageTranscoder.this.hints.get(KEY_ALLOWED_SCRIPT_TYPES);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.scripts.addElement(stringTokenizer.nextToken());
            }
        }
    }
}

