/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.xdom.io;

import com.sap.aii.util.xml.xdom.InvalidArgumentException;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XNamespace;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class XDOMSAXHandler
extends DefaultHandler {
    private XDocument doc = null;
    private XElement root = null;
    private Stack stack = new Stack();
    private Stack nsStack = new Stack();
    private XDOMFactory factory = null;
    private StringBuffer sb = new StringBuffer();

    public XDOMSAXHandler(XDOMFactory xf) {
        this.factory = xf;
    }

    private void flushText() {
        if (this.sb.length() > 0) {
            String s = this.sb.toString();
            if (s.length() > 0) {
                XElement node = this.peek();
                node.add(s);
            }
            this.sb = new StringBuffer();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }

    public void endDocument() throws SAXException {
        if (!this.stack.isEmpty()) {
            throw new SAXException("ParserError: XML is not \"well-formed\"! Some tags are not closed");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushText();
        this.pop();
    }

    public void endPrefixMapping() throws SAXException {
    }

    public void ignorableWhiteSpace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(String target) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.doc = this.factory.newXDocument();
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushText();
        parent = this.stack.isEmpty() != false ? null : this.peek();
        pos = qName.indexOf(58);
        prefix = pos > 0 ? qName.substring(0, pos) : "";
        namespace = null;
        try {
            namespace = this.factory.newXNamespace(prefix, uri);
        }
        catch (InvalidArgumentException ex) {
            // empty catch block
        }
        try {
            node = this.factory.newXElement(localName, namespace);
            if (true) ** GOTO lbl19
        }
        catch (InvalidArgumentException iae) {
            throw new SAXException((Exception)iae);
        }
        do {
            node.add((XNamespace)this.nsStack.pop());
lbl19:
            // 2 sources

        } while (!this.nsStack.isEmpty());
        if (null == this.doc.getRoot()) {
            this.doc.setRoot(node);
            this.root = node;
        } else {
            if (this.stack.isEmpty()) {
                throw new SAXException("Document must have only one root element!");
            }
            el = this.peek();
            el.add(node);
        }
        this.push(node);
        i = 0;
        while (i < attributes.getLength()) {
            try {
                attrURI = attributes.getURI(i);
                attrPrefix = node.getNamespacePrefix(attrURI);
                attrNs = this.factory.newXNamespace(attrPrefix, attrURI);
                attrName = this.factory.newXName(attributes.getLocalName(i), attrNs);
                attr = this.factory.newXAttribute(attrName, attributes.getValue(i));
            }
            catch (InvalidArgumentException iae) {
                throw new SAXException((Exception)iae);
            }
            node.add(attr);
            ++i;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.nsStack.push(this.factory.newXNamespace(prefix, uri));
        }
        catch (InvalidArgumentException iae) {
            throw new SAXException((Exception)((Object)iae));
        }
    }

    public void error(SAXParseException e) throws SAXException {
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e);
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    private void push(XElement node) {
        this.stack.push(node);
    }

    private XElement pop() {
        return (XElement)this.stack.pop();
    }

    private XElement peek() {
        return (XElement)this.stack.peek();
    }

    public XDocument getDocument() {
        return this.doc;
    }

    public void reset() {
        this.doc = null;
        this.root = null;
        this.stack.removeAllElements();
    }
}

