/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.xdom.io;

import com.sap.aii.util.misc.api.IOUtil;
import com.sap.aii.util.misc.api.StringUtil;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XCDATA;
import com.sap.aii.util.xml.xdom.XComment;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.XProcessingInstruction;
import com.sap.aii.util.xml.xdom.XText;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class XDOMOutputter {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_INDENT = "    ";
    private String indent = "    ";
    private String encoding = "UTF-8";
    private boolean doIndent = false;
    private boolean brkLines = false;
    private boolean mixedContent = true;

    public XDOMOutputter() {
        this(DEFAULT_INDENT);
    }

    public XDOMOutputter(String indent) {
        this(indent, false);
    }

    public XDOMOutputter(String indent, boolean breakLines) {
        this.init(indent, breakLines);
    }

    public XDOMOutputter(String indent, boolean breakLines, String encoding) throws UnsupportedEncodingException {
        this.init(indent, breakLines);
        this.setEncoding(encoding);
    }

    private void init(String indent, boolean breakLines) {
        this.setIndent(true);
        this.setIndent(indent);
        this.setBreakLines(breakLines);
    }

    public void setIndent(boolean indent) {
        this.doIndent = indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (!IOUtil.isEncodingSupported((String)encoding)) {
            throw new UnsupportedEncodingException(encoding);
        }
        this.encoding = encoding;
    }

    public void setBreakLines(boolean brk) {
        this.brkLines = brk;
    }

    public void write(XDocument doc, Writer out) throws IOException {
        out.write(this.write(doc));
    }

    private OutputStreamWriter getWriter(OutputStream out) {
        try {
            return new OutputStreamWriter(out, this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnexpectedException((Exception)ex);
        }
    }

    public void write(XDocument doc, OutputStream out) throws IOException {
        String s = this.write(doc);
        OutputStreamWriter ps = this.getWriter(out);
        ps.write(s);
        ps.flush();
    }

    public String write(XDocument doc) {
        String res = "";
        res = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n";
        res = res + this.write(doc.getRoot());
        return res;
    }

    public void write(XElement elem, Writer out) throws IOException {
        out.write(this.write(elem));
    }

    public void write(XElement elem, OutputStream out) throws IOException {
        String s = this.write(elem);
        OutputStreamWriter ps = this.getWriter(out);
        ps.write(s);
        ps.flush();
    }

    private void addNewline(StringBuffer buffer, int indentLevel) {
        buffer.append("\n");
        int i = 0;
        while (i < indentLevel) {
            buffer.append(this.indent);
            ++i;
        }
    }

    public String write(XElement elem) {
        return this.write(elem, 0, new Stack());
    }

    private boolean existsNamespace(Stack nsStack, XNamespace ns) {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        Iterator i = ((AbstractList)nsStack).iterator();
        while (i.hasNext()) {
            Map map = (Map)i.next();
            if (!map.containsKey(prefix)) continue;
            return map.get(prefix).equals(uri);
        }
        return false;
    }

    private String write(XElement elem, int indentLevel, Stack nsStack) {
        List content;
        StringBuffer res = new StringBuffer();
        if (this.brkLines) {
            this.addNewline(res, indentLevel);
        }
        res.append("<").append(elem.getQualifiedName());
        List attrs = elem.getAttributes();
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            XAttribute attr = (XAttribute)it.next();
            res.append(" ").append(attr.getQualifiedName()).append("=\"").append(StringUtil.escapeXMLChars((String)attr.getValue())).append("\"");
        }
        List ns = elem.getAdditionalNamespaces();
        boolean hasNamespaces = false;
        if (ns.size() > 0) {
            HashMap<String, String> nsMap = new HashMap<String, String>();
            it = ns.iterator();
            while (it.hasNext()) {
                XNamespace nmsp = (XNamespace)it.next();
                if (this.existsNamespace(nsStack, nmsp)) continue;
                String prefix = nmsp.getPrefix();
                String uri = nmsp.getURI();
                if ("xml".equals(prefix)) continue;
                res.append(" xmlns");
                if (!"".equals(prefix)) {
                    res.append(":").append(prefix);
                }
                res.append("=\"").append(StringUtil.escapeXMLChars((String)uri)).append("\"");
                nsMap.put(prefix, uri);
            }
            nsStack.push(nsMap);
            hasNamespaces = true;
        }
        if ((content = elem.getMixedContent()).size() > 0) {
            res.append(">");
            boolean hasSubElements = elem.getSubElements().length > 0;
            boolean origBrkLines = this.brkLines;
            if (!hasSubElements) {
                this.brkLines = false;
            }
            it = content.iterator();
            while (it.hasNext()) {
                Object node = it.next();
                if (node instanceof XElement) {
                    res.append(this.write((XElement)node, indentLevel + 1, nsStack));
                    continue;
                }
                if (node instanceof XText) {
                    if (this.brkLines && hasSubElements && this.mixedContent) {
                        this.addNewline(res, indentLevel + 1);
                    }
                    if (hasSubElements && (!hasSubElements || !this.mixedContent)) continue;
                    res.append(this.write((XText)node));
                    continue;
                }
                if (node instanceof XComment) {
                    res.append(this.write((XComment)node));
                    continue;
                }
                if (node instanceof XCDATA) {
                    res.append(this.write((XCDATA)node));
                    continue;
                }
                if (!(node instanceof XProcessingInstruction)) continue;
                res.append(this.write((XProcessingInstruction)node));
            }
            if (this.brkLines) {
                this.addNewline(res, indentLevel);
            }
            res.append("</").append(elem.getQualifiedName()).append(">");
            this.brkLines = origBrkLines;
        } else {
            res.append(" />");
        }
        if (hasNamespaces) {
            nsStack.pop();
        }
        return res.toString();
    }

    public void write(XText txt, Writer out) throws IOException {
        out.write(this.write(txt));
    }

    public void write(XText txt, OutputStream out) throws IOException {
        String s = this.write(txt);
        OutputStreamWriter ps = this.getWriter(out);
        ps.write(s);
        ps.flush();
    }

    public String write(XText txt) {
        return StringUtil.escapeXMLChars((String)txt.getText());
    }

    public void write(XComment com, Writer out) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public void write(XComment com, OutputStream out) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public String write(XComment com) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public void write(XCDATA dat, Writer out) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public void write(XCDATA dat, OutputStream out) {
        try {
            out.write(this.write(dat).getBytes(DEFAULT_ENCODING));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String write(XCDATA dat) {
        return "<![CDATA[" + dat.getText() + "]]>";
    }

    public void write(XProcessingInstruction pi, Writer out) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public void write(XProcessingInstruction pi, OutputStream out) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public String write(XProcessingInstruction pi) {
        throw new UnsupportedOperationException("Unsupported in this release");
    }

    public void setMixedContent(boolean mixedContent) {
        this.mixedContent = mixedContent;
    }

    public boolean isMixedContent() {
        return this.mixedContent;
    }
}

