/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.xdom.impl;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.xdom.InvalidArgumentException;
import com.sap.aii.util.xml.xdom.StructureCorruptingException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XData;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.XNode;
import com.sap.aii.util.xml.xdom.XText;
import com.sap.aii.util.xml.xdom.impl.AXElement;
import com.sap.aii.util.xml.xdom.impl.XAttributeImpl;
import com.sap.aii.util.xml.xdom.impl.XCDATAImpl;
import com.sap.aii.util.xml.xdom.impl.XNameImpl;
import com.sap.aii.util.xml.xdom.impl.XNamespaceImpl;
import com.sap.aii.util.xml.xdom.impl.XTextImpl;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class XElementImpl
extends AXElement {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$util$xml$xdom$impl$XElementImpl == null ? (class$com$sap$aii$util$xml$xdom$impl$XElementImpl = XElementImpl.class$("com.sap.aii.util.xml.xdom.impl.XElementImpl")) : class$com$sap$aii$util$xml$xdom$impl$XElementImpl).getName());
    private static final long serialVersionUID = 42L;
    private static String PRE_PREFIX = "generateduniqueprefix";
    private static int PRE_SUFFIX = 0;
    private static List EMPTY_LIST = new ArrayList();
    static /* synthetic */ Class class$com$sap$aii$util$xml$xdom$impl$XElementImpl;

    static String getUniquePrefix() {
        String p = new String(PRE_PREFIX);
        p = p + Integer.toString(PRE_SUFFIX++);
        return p;
    }

    private XElementImpl(String name) {
        this(new XNameImpl(name));
    }

    public XElementImpl(XName name) {
        this(name, null);
    }

    public XElementImpl(XName name, XElement parent) {
        this.name = name;
        this.parent = parent;
        this.mixedContent = new AXElement.ContentVector(this);
        this.additionalNamespaces = new AXElement.NamespacesVector(this);
    }

    public XElementImpl(String name, String uri) {
        this(new XNameImpl(name, uri));
    }

    public XElementImpl(String name, String prefix, String uri) {
        this(new XNameImpl(name, prefix, uri));
    }

    public void setParent(XElement newParent) {
        if (null != this.parent && null != newParent) {
            throw new StructureCorruptingException(StructureCorruptingException.createMsg_PARENT());
        }
        this.parent = newParent;
    }

    public String getQualifiedName() {
        this.normalizeNamespace();
        return this.name.getQualifiedName();
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public XElement add(String text) {
        if (null == text) {
            return this;
        }
        XTextImpl xt = new XTextImpl(text);
        this.mixedContent.add(xt);
        return this;
    }

    public XElement add(XElement node) {
        if (null == node) {
            return this;
        }
        this.mixedContent.add(node);
        return this;
    }

    public XElement add(XNamespace ns) {
        if (null == ns) {
            return this;
        }
        if (null == ns.getPrefix()) {
            ns = this.normalizeNamespace(ns, false);
        }
        String prefix = ns.getPrefix();
        int i = 0;
        while (i < this.additionalNamespaces.size()) {
            XNamespace n = (XNamespace)this.additionalNamespaces.get(i);
            if (n.getPrefix().equals(prefix)) {
                this.additionalNamespaces.remove(i);
                break;
            }
            ++i;
        }
        this.additionalNamespaces.add(ns);
        return this;
    }

    public XElement add(XAttribute attr) {
        if (null == attr) {
            return this;
        }
        XAttribute a = this.getAttribute(attr.getName());
        if (this.attributes == null) {
            this.attributes = new AXElement.AttributesVector(this);
        }
        if (null != a) {
            this.attributes.set(this.attributes.indexOf(a), attr);
        } else {
            this.attributes.add(attr);
        }
        return this;
    }

    public XElement addCDATA(String text) {
        this.mixedContent.add(new XCDATAImpl(text));
        return this;
    }

    public XElement addComment(String comment) {
        throw new UnsupportedOperationException("method addComment() is not yet implemented.");
    }

    public XElement addProcessingInstruction(String Target, String instruction) {
        throw new UnsupportedOperationException("method addProcessingInstruction() is not yet implemented.");
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AXElement.AttributesVector(this);
        }
        return this.attributes;
    }

    public String getAttributeValue(XName name) {
        XAttribute atr = this.getAttribute(name);
        if (null == atr) {
            return null;
        }
        return atr.getValue();
    }

    public String getAttributeValue(String name) {
        XAttribute atr = this.getAttribute(name);
        if (null == atr) {
            return null;
        }
        return atr.getValue();
    }

    public XAttribute getAttribute(XName name) {
        if (this.attributes == null) {
            return null;
        }
        int i = 0;
        while (i < this.attributes.size()) {
            XAttribute a = (XAttribute)this.attributes.get(i);
            XName an = a.getName();
            if (an.equals(name)) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public XAttribute getAttribute(String localName) {
        if (this.attributes == null) {
            return null;
        }
        int i = 0;
        while (i < this.attributes.size()) {
            XAttribute a = (XAttribute)this.attributes.get(i);
            if (a.getLocalName().equals(localName)) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public XElement[] getSubElements() {
        ArrayList v = new ArrayList();
        int i = 0;
        while (i < this.mixedContent.size()) {
            Object o = this.mixedContent.get(i);
            if (o instanceof XElement) {
                v.add(o);
            }
            ++i;
        }
        XElement[] arr = new XElement[v.size()];
        arr = v.toArray(arr);
        return arr;
    }

    public XElement getSubElement(String localName) {
        return this.getSubElement(new XNameImpl(localName, XDOMFactory.NO_NAMESPACE));
    }

    public XElement getSubElement(String localName, String namespaceUri) {
        return this.getSubElement(new XNameImpl(localName, namespaceUri));
    }

    public XElement getSubElement(XName name) {
        Iterator i = this.mixedContent.iterator();
        while (i.hasNext()) {
            XElement e;
            Object o = i.next();
            if (!(o instanceof XElement) || !name.equals((e = (XElement)o).getName())) continue;
            return e;
        }
        return null;
    }

    public XElement[] getSubElements(String localName) {
        return this.getSubElements(new XNameImpl(localName, XDOMFactory.NO_NAMESPACE));
    }

    public XElement[] getSubElements(String localName, String namespaceUri) {
        return this.getSubElements(new XNameImpl(localName, namespaceUri));
    }

    public XElement[] getSubElements(XName name) {
        Vector<XElement> v = new Vector<XElement>();
        Iterator i = this.mixedContent.iterator();
        while (i.hasNext()) {
            XElement e;
            Object o = i.next();
            if (!(o instanceof XElement) || !name.equals((e = (XElement)o).getName())) continue;
            v.add(e);
        }
        return v.toArray(new XElement[0]);
    }

    public List getAdditionalNamespaces() {
        return this.additionalNamespaces;
    }

    public List getAllNamespaces() {
        return new Vector(this.getAllNamespacesMap().values());
    }

    private Map getAllNamespacesMap() {
        Map<String, XNamespace> result = this.parent != null ? ((XElementImpl)this.parent).getAllNamespacesMap() : new HashMap();
        this.normalizeNamespace();
        Iterator i = this.getAttributes().iterator();
        while (i.hasNext()) {
            ((XAttributeImpl)i.next()).normalizeNamespace();
        }
        Iterator i2 = this.additionalNamespaces.iterator();
        while (i2.hasNext()) {
            XNamespace ns = (XNamespace)i2.next();
            result.put(ns.getPrefix(), ns);
        }
        return result;
    }

    XNamespace getNamespaceFromSelfOrAcc(String uri) {
        XNamespace res = null;
        Iterator it = this.additionalNamespaces.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            XNamespace ns = (XNamespace)o;
            if (null == ns.getPrefix() || !ns.getURI().equals(uri)) continue;
            res = ns;
            break;
        }
        if (null == res && null != this.parent && this.parent instanceof XElementImpl) {
            XNamespace nmsp = this.parent.getNamespace();
            if (nmsp.getURI().equals(uri)) {
                res = nmsp;
            } else {
                XElementImpl xei = (XElementImpl)this.parent;
                res = xei.getNamespaceFromSelfOrAcc(uri);
            }
        }
        return res;
    }

    private XNamespace normalizeNamespace(String uri, boolean isAttributeNS) {
        XNamespace res = null;
        res = this.normalizeNamespace(new XNamespaceImpl(null, uri), isAttributeNS);
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    XNamespace normalizeNamespace(XNamespace ns, boolean isAttributeNS) {
        if (ns != this.name.getNamespace()) {
            this.normalizeNamespace();
        }
        XNamespace res = null;
        String uri = ns.getURI();
        if (uri.equals(XDOMFactory.XML_NAMESPACE.getURI())) {
            return XDOMFactory.XML_NAMESPACE;
        }
        res = this.getNamespaceFromSelfOrAcc(uri);
        if (null != res) return res;
        boolean is2badded = true;
        res = ns;
        if (null == res.getPrefix() && res instanceof XNamespaceImpl) {
            XNamespaceImpl xni = (XNamespaceImpl)res;
            if ("".equals(xni.getURI())) {
                String defuri = this.getNamespaceURI("");
                if (!isAttributeNS && defuri != null && !defuri.equals("")) throw new StructureCorruptingException(StructureCorruptingException.createMsg_NO_URI());
                xni.setPrefix("");
                is2badded = false;
            } else {
                xni.setPrefix(XElementImpl.getUniquePrefix());
            }
        } else if (isAttributeNS && "".equals(res.getURI())) {
            is2badded = false;
        } else if (res.equals(XDOMFactory.NO_NAMESPACE)) {
            is2badded = false;
        }
        if (!is2badded) return res;
        this.add(res);
        return res;
    }

    private void normalizeNamespace() {
        XNamespace res = this.name.getNamespace();
        res = this.normalizeNamespace(res, false);
        this.setNamespace(res);
    }

    public XNamespace getNamespace() {
        this.normalizeNamespace();
        XNamespace res = this.name.getNamespace();
        return res;
    }

    public void setNamespace(XNamespace newNamespace) {
        if (this.name instanceof XNameImpl) {
            XNameImpl xni = (XNameImpl)this.name;
            xni.setNamespace(newNamespace);
        }
    }

    private String getNsPrefix(String uri, boolean deep) {
        int i = 0;
        while (i < this.additionalNamespaces.size()) {
            XNamespace n = (XNamespace)this.additionalNamespaces.get(i);
            if (n.getURI().equals(uri)) {
                return n.getPrefix();
            }
            ++i;
        }
        if (null != this.parent && deep) {
            return this.parent.getNamespacePrefix(uri);
        }
        return null;
    }

    public String getNamespacePrefix(String uri) {
        return this.getNsPrefix(uri, true);
    }

    private String getNsURI(String prefix, boolean deep) {
        int i = 0;
        while (i < this.additionalNamespaces.size()) {
            XNamespace n = (XNamespace)this.additionalNamespaces.get(i);
            if (n.getPrefix().equals(prefix)) {
                return n.getURI();
            }
            ++i;
        }
        if (null != this.parent && deep) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    public String getSubElementText(String localName) {
        XElement e = this.getSubElement(localName);
        return e == null ? null : e.getText();
    }

    public String getSubElementTextTrim(String localName) {
        XElement e = this.getSubElement(localName);
        if (e == null) {
            return null;
        }
        String s = e.getText();
        return s == null ? null : s.trim();
    }

    public String getSubElementText(XName name) {
        XElement e = this.getSubElement(name);
        return e == null ? null : e.getText();
    }

    public String getSubElementTextTrim(XName name) {
        XElement e = this.getSubElement(name);
        if (e == null) {
            return null;
        }
        String s = e.getText();
        return s == null ? null : s.trim();
    }

    public String getSubElementText(String localName, String namespaceUri) {
        XElement e = this.getSubElement(localName, namespaceUri);
        return e == null ? null : e.getText();
    }

    public String getSubElementTextTrim(String localName, String namespaceUri) {
        XElement e = this.getSubElement(localName, namespaceUri);
        if (e == null) {
            return null;
        }
        String s = e.getText();
        return s == null ? null : s.trim();
    }

    public String getNamespaceURI(String prefix) {
        return this.getNsURI(prefix, true);
    }

    XElement findInAllDescendants(String XPath) throws InvalidArgumentException {
        XElement res = null;
        res = this.findElement(XPath);
        if (null == res) {
            List sube = this.mixedContent;
            int i = 0;
            while (i < sube.size()) {
                if (sube.get(i) instanceof XElementImpl) {
                    res = ((XElementImpl)sube.get(i)).findInAllDescendants(XPath);
                }
                if (null != res) break;
                ++i;
            }
        }
        return res;
    }

    XElementImpl findByLevels(List levels) throws InvalidArgumentException {
        XElementImpl res = null;
        XElementImpl found = null;
        XPathLevel thisLevel = (XPathLevel)levels.iterator().next();
        String qname = null;
        String prefix = thisLevel.getPrefix();
        if (thisLevel.getName().equals("..")) {
            if (this.parent == null) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            res = 1 == levels.size() ? (XElementImpl)this.parent : ((XElementImpl)this.parent).findByLevels(levels.subList(1, levels.size()));
        } else if (thisLevel.getName().equals(".")) {
            res = 1 == levels.size() ? this : this.findByLevels(levels.subList(1, levels.size()));
        } else {
            qname = prefix + ("".equals(prefix) ? "" : ":") + thisLevel.getName();
            if (thisLevel.isPosSpecified()) {
                found = (XElementImpl)this.findInPosition(qname, thisLevel.getPosition());
                res = null == found ? null : (1 == levels.size() ? found : found.findByLevels(levels.subList(1, levels.size())));
            } else {
                int p = 1;
                while (p <= this.mixedContent.size()) {
                    found = (XElementImpl)this.findInPosition(qname, p);
                    ++p;
                    if (null == found) continue;
                    if (1 == levels.size()) {
                        res = found;
                        break;
                    }
                    res = found.findByLevels(levels.subList(1, levels.size()));
                    if (null != res) break;
                }
            }
        }
        return res;
    }

    public XElement findElement(String XPath) throws InvalidArgumentException {
        XElement res = null;
        XPath.trim();
        if (XPath.endsWith("/")) {
            throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
        }
        if (XPath.startsWith("//")) {
            res = null == this.parent ? this.findInAllDescendants(XPath.substring(2)) : this.parent.findElement(XPath);
        } else if (XPath.startsWith("/")) {
            res = null == this.parent ? this.findElement(XPath.substring(1)) : this.parent.findElement(XPath);
        } else {
            Vector<XPathLevel> xpLevels = new Vector<XPathLevel>();
            StringTokenizer st = new StringTokenizer(XPath, "/ ", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                XPathLevel xpl = new XPathLevel(token);
                xpLevels.add(xpl);
            }
            if (xpLevels.size() == 0) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            res = this.findByLevels(xpLevels);
        }
        return res;
    }

    XElement findInPosition(String qname, int pos) {
        XElement found = null;
        XElement[] sube = this.getSubElements();
        int posFound = 0;
        int i = 0;
        while (i < sube.length) {
            if (qname.equals(sube[i].getQualifiedName()) && ++posFound == pos) {
                found = sube[i];
                break;
            }
            ++i;
        }
        return found;
    }

    List selectInAllDescendants(String XPath) throws InvalidArgumentException {
        List res = new Vector();
        res = this.selectElementsToList(XPath);
        List sube = this.mixedContent;
        int i = 0;
        while (i < sube.size()) {
            if (sube.get(i) instanceof XElementImpl) {
                res.addAll(((XElementImpl)sube.get(i)).selectInAllDescendants(XPath));
            }
            ++i;
        }
        return res;
    }

    List selectByLevels(List levels) throws InvalidArgumentException {
        Vector<XElement> res = new Vector<XElement>();
        Vector<XElement> found = new Vector<XElement>();
        XPathLevel thisLevel = (XPathLevel)levels.iterator().next();
        String prefix = thisLevel.getPrefix();
        String qname = null;
        if (thisLevel.getName().equals("..")) {
            if (this.parent == null) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            if (1 == levels.size()) {
                res.add(this.parent);
            } else {
                res.addAll(((XElementImpl)this.parent).selectByLevels(levels.subList(1, levels.size())));
            }
        } else if (thisLevel.getName().equals(".")) {
            if (1 == levels.size()) {
                res.add(this);
            } else {
                res.addAll(this.selectByLevels(levels.subList(1, levels.size())));
            }
        } else {
            qname = prefix + ("".equals(prefix) ? "" : ":") + thisLevel.getName();
            if (thisLevel.isPosSpecified()) {
                XElementImpl xei = (XElementImpl)this.findInPosition(qname, thisLevel.getPosition());
                if (null == xei) {
                    res.clear();
                } else if (1 == levels.size()) {
                    res.add(xei);
                } else {
                    res.addAll(xei.selectByLevels(levels.subList(1, levels.size())));
                }
            } else {
                Object obj;
                Iterator iter = this.mixedContent.iterator();
                while (iter.hasNext()) {
                    XElement xe;
                    obj = iter.next();
                    if (!(obj instanceof XElement) || !qname.equals((xe = (XElement)obj).getQualifiedName())) continue;
                    found.add(xe);
                }
                if (1 == levels.size()) {
                    res = found;
                } else {
                    iter = ((AbstractList)found).iterator();
                    while (iter.hasNext()) {
                        obj = iter.next();
                        XElementImpl xei = (XElementImpl)obj;
                        res.addAll(xei.selectByLevels(levels.subList(1, levels.size())));
                    }
                }
            }
        }
        return res;
    }

    public List selectElementsToList(String XPath) throws InvalidArgumentException {
        List res = new Vector();
        if (XPath.endsWith("/")) {
            throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
        }
        if (XPath.startsWith("//")) {
            res = null == this.parent ? this.selectInAllDescendants(XPath.substring(2)) : ((XElementImpl)this.parent).selectElementsToList(XPath);
        } else if (XPath.startsWith("/")) {
            res = null == this.parent ? this.selectElementsToList(XPath.substring(1)) : ((XElementImpl)this.parent).selectElementsToList(XPath);
        } else {
            Vector<XPathLevel> xpLevels = new Vector<XPathLevel>();
            StringTokenizer st = new StringTokenizer(XPath, "/ ", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                XPathLevel xpl = new XPathLevel(token);
                xpLevels.add(xpl);
            }
            if (xpLevels.size() == 0) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            res = this.selectByLevels(xpLevels);
        }
        return res;
    }

    public XElement[] selectElements(String XPath) throws InvalidArgumentException {
        List l = this.selectElementsToList(XPath);
        int n = l.size();
        XElement[] e = new XElement[n];
        int i = 0;
        while (i < n) {
            e[i] = (XElement)l.get(i);
            ++i;
        }
        return e;
    }

    public XElement getParent() {
        return this.parent;
    }

    public List getMixedContent() {
        return this.mixedContent;
    }

    public XName getName() {
        this.normalizeNamespace();
        return this.name;
    }

    public XElement setName(XName newName) {
        this.name = newName;
        this.setNamespace(newName.getNamespace());
        return this;
    }

    public XElement remove(XElement elem) {
        this.mixedContent.remove(elem);
        return this;
    }

    public XElement remove(XAttribute attr) {
        if (this.attributes == null) {
            return this;
        }
        this.attributes.remove(attr);
        return this;
    }

    public XElement remove(XData data) {
        if (data instanceof XTextImpl) {
            // empty if block
        }
        this.mixedContent.remove(data);
        return this;
    }

    public XElement remove(XNamespace ns) {
        this.additionalNamespaces.remove(ns);
        return this;
    }

    public void removeAttribute(XName name) {
        XAttribute atr = this.getAttribute(name);
        if (null != atr) {
            this.remove(atr);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeAttribute(String localName) {
        XAttribute atr;
        while ((atr = this.getAttribute(localName)) != null) {
            void var2_2;
            this.remove((XAttribute)var2_2);
        }
    }

    public XElement removeElement(String localName) {
        Iterator it = this.mixedContent.iterator();
        while (it.hasNext()) {
            XElementImpl xe;
            Object o = it.next();
            if (!(o instanceof XElementImpl) || !(xe = (XElementImpl)o).getLocalName().equals(localName)) continue;
            this.mixedContent.remove(o);
        }
        return this;
    }

    public XElement removeElement(XName name) {
        Iterator it = this.mixedContent.iterator();
        while (it.hasNext()) {
            XElementImpl xe;
            Object o = it.next();
            if (!(o instanceof XElementImpl) || !(xe = (XElementImpl)o).getName().equals(name)) continue;
            this.mixedContent.remove(o);
            break;
        }
        return this;
    }

    public XElement removeNamespace(String URI2) {
        Iterator it = this.additionalNamespaces.iterator();
        while (it.hasNext()) {
            XNamespace xn;
            Object o = it.next();
            if (!(o instanceof XNamespace) || !(xn = (XNamespace)o).getURI().equals(URI2)) continue;
            this.additionalNamespaces.remove(o);
        }
        return this;
    }

    public void setAttribute(String localName, String value) throws InvalidArgumentException {
        XAttribute attr = this.getAttribute(localName);
        if (this.attributes == null) {
            this.attributes = new AXElement.AttributesVector(this);
        }
        if (null != attr) {
            attr.setValue(value);
        } else {
            String uri = this.getNamespaceURI("");
            if (null == uri) {
                uri = "";
            }
            XDOMFactory xf = new XDOMFactory(uri);
            attr = xf.newXAttribute(localName, value);
            this.attributes.add(attr);
        }
    }

    public int getLineNumber() {
        throw new UnsupportedOperationException("method getLineNumber() is not yet implemented.");
    }

    public int getColumnNumber() {
        throw new UnsupportedOperationException("method getColumnNumber() is not yet implemented.");
    }

    public String getText() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.mixedContent.size()) {
            Object o = this.mixedContent.get(i);
            if (o instanceof XText) {
                XText d = (XText)o;
                sb.append(d.getText());
            }
            ++i;
        }
        return sb.toString();
    }

    public void removeAll() {
        this.mixedContent.clear();
    }

    public Object clone() {
        XElementImpl e = new XElementImpl((XName)this.getName().clone());
        Iterator i = this.additionalNamespaces.iterator();
        while (i.hasNext()) {
            e.add((XNamespace)((XNamespace)i.next()).clone());
        }
        if (this.attributes != null) {
            i = this.attributes.iterator();
            while (i.hasNext()) {
                e.add((XAttribute)((XAttribute)i.next()).clone());
            }
        }
        i = this.mixedContent.iterator();
        while (i.hasNext()) {
            XNode node = (XNode)((XNode)i.next()).clone();
            if (node instanceof XElement) {
                e.add((XElement)node);
                continue;
            }
            if (!(node instanceof XText)) continue;
            e.add(((XText)node).getText());
        }
        return e;
    }

    public XNamespace getNamespace(String prefix) {
        XNamespace ns = null;
        this.normalizeNamespace();
        String uri = this.getNamespaceURI(prefix);
        if (uri != null) {
            ns = this.normalizeNamespace(uri, false);
        }
        return ns;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class XPathLevel {
        private String localName;
        private String prefix;
        private int pos;
        private boolean posSpecified;

        public XPathLevel(String s) throws InvalidArgumentException {
            String toFind = s;
            int dblpt = toFind.indexOf(58);
            int oBracket = toFind.indexOf(91);
            int cBracket = toFind.indexOf(93);
            int toFindLen = toFind.length();
            if (dblpt + 1 == toFindLen) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            if (oBracket + 1 == toFindLen) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            if (-1 != cBracket && cBracket + 1 != toFindLen) {
                throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
            }
            String _prefix = null;
            String _localName = null;
            int localNameStart = 0;
            int localNameEnd = toFindLen;
            this.pos = -1;
            this.posSpecified = false;
            if (dblpt != -1) {
                _prefix = toFind.substring(0, dblpt);
                localNameStart = dblpt + 1;
            } else {
                _prefix = "";
            }
            if (oBracket == -1) {
                if (cBracket != -1) {
                    throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
                }
            } else {
                if (cBracket == -1) {
                    throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
                }
                localNameEnd = oBracket;
                String position = toFind.substring(oBracket + 1, cBracket);
                try {
                    this.pos = Integer.parseInt(position);
                    this.posSpecified = true;
                }
                catch (NumberFormatException ex) {
                    throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH(), ex);
                }
                if (this.posSpecified && this.pos <= 0) {
                    throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_XPATH());
                }
            }
            this.localName = _localName = toFind.substring(localNameStart, localNameEnd);
            this.prefix = _prefix;
        }

        public String getName() {
            return this.localName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getPosition() {
            return this.pos;
        }

        public boolean isPosSpecified() {
            return this.posSpecified;
        }

        public String toString() {
            String res = "";
            if (!"".equals(this.prefix)) {
                res = res + this.prefix;
            }
            res = res + this.localName;
            if (this.posSpecified) {
                res = res + "[" + this.pos + "]";
            }
            return res;
        }
    }
}

