/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.xdom;

import com.sap.aii.util.xml.xdom.InvalidArgumentException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.impl.XAttributeImpl;
import com.sap.aii.util.xml.xdom.impl.XDocumentImpl;
import com.sap.aii.util.xml.xdom.impl.XElementImpl;
import com.sap.aii.util.xml.xdom.impl.XNameImpl;
import com.sap.aii.util.xml.xdom.impl.XNamespaceImpl;

public class XDOMFactory {
    public static final XNamespace NO_NAMESPACE = new XNamespaceImpl("", "");
    public static final XNamespace XML_NAMESPACE = new XNamespaceImpl("xml", "http://www.w3.org/XML/1998/namespace");
    private String presetURI;

    public XDOMFactory() {
        this("");
    }

    public XDOMFactory(String presetURI) {
        this.presetURI = presetURI;
        presetURI.trim();
    }

    public XName newXName(String localName) throws InvalidArgumentException {
        return this.newXName(localName, this.presetURI);
    }

    public XName newXName(String localName, String URI2) throws InvalidArgumentException {
        return this.newXName(localName, this.newXNamespace(URI2));
    }

    public XName newXName(String localName, XNamespace ns) throws InvalidArgumentException {
        if (!XDOMFactory.isLocalNameValid(localName)) {
            throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_LOCALNAME());
        }
        return new XNameImpl(localName, ns);
    }

    public XDocument newXDocument() {
        return new XDocumentImpl();
    }

    public XNamespace newXNamespace() {
        return this.newXNamespace(this.presetURI);
    }

    public XNamespace newXNamespace(String URI2) {
        if (XML_NAMESPACE.getURI().equals(URI2)) {
            return XML_NAMESPACE;
        }
        XNamespace ns = null;
        try {
            ns = this.newXNamespace(null, URI2);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        return ns;
    }

    public XNamespace newXNamespace(String prefix, String URI2) throws InvalidArgumentException {
        if (null == URI2) {
            URI2 = "";
        }
        if (XML_NAMESPACE.getPrefix().equals(prefix)) {
            return XML_NAMESPACE;
        }
        if (!XDOMFactory.isPrefixValid(prefix)) {
            throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_PREFIX());
        }
        return new XNamespaceImpl(prefix, URI2);
    }

    public XAttribute newXAttribute(XName name, String value) {
        return new XAttributeImpl(name, value);
    }

    public XAttribute newXAttribute(String localName, String value) throws InvalidArgumentException {
        if (!XDOMFactory.isLocalNameValid(localName)) {
            throw new InvalidArgumentException(InvalidArgumentException.createMsg_INVALID_LOCALNAME());
        }
        return this.newXAttribute(this.newXName(localName, this.newXNamespace(null, this.presetURI)), value);
    }

    public XElement newXElement(XName name) {
        return new XElementImpl(name);
    }

    public XElement newXElement(String localName, String URI2) throws InvalidArgumentException {
        return this.newXElement(localName, this.newXNamespace(URI2));
    }

    public XElement newXElement(String localName, XNamespace ns) throws InvalidArgumentException {
        return this.newXElement(this.newXName(localName, ns));
    }

    public XElement newXElement(String localName) throws InvalidArgumentException {
        return this.newXElement(localName, this.presetURI);
    }

    private static boolean isNCNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isNCNamePart(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == '-';
    }

    private static boolean isLocalNameValid(String s) {
        boolean ret = true;
        if (null == s || "".equals(s)) {
            ret = false;
        } else {
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                if (!XDOMFactory.isNCNamePart(ch) || 0 == i && !XDOMFactory.isNCNameStart(ch)) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    private static boolean isPrefixValid(String s) {
        return null == s || "".equals(s) || XDOMFactory.isLocalNameValid(s);
    }
}

