/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.blob.api.BlobServices;
import com.sap.aii.util.misc.api.InvalidArgumentException;
import com.sap.aii.util.misc.api.StringUtil;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLMemory;
import com.sap.aii.util.xml.api.XMLMemoryStream;
import com.sap.aii.util.xml.api.XMLServices;
import com.sap.aii.util.xml.api.XMLStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class XMLTagStream
extends XMLMemoryStream {
    private String externalDTD;

    public XMLTagStream() {
        super(XMLStream.FRAGMENT);
    }

    public void init() {
        super.init();
        this.externalDTD = null;
    }

    public void setExternalDTD(String ref) throws XMLException {
        if (StringUtil.contains((String)ref, (char)'\"')) {
            throw new XMLException(XMLException.createMsg_ILLEGAL_CHAR("\"", "DTD"));
        }
        this.externalDTD = ref;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setReadableOutput(boolean x) {
        this.readableOutput = x;
    }

    public String toXMLDocString() throws XMLException {
        return this.toXMLDocString(null);
    }

    public String toXMLString() throws XMLException {
        this.testWellFormed();
        try {
            super.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buffer.toString();
    }

    public String toXMLDocString(String encoding) throws XMLException {
        this.testWellFormed();
        if (this.closeCount != 1) {
            throw new XMLException(XMLException.createMsg_ROOT());
        }
        StringBuffer s = new StringBuffer("<?xml version=\"1.0\"");
        if (encoding != null) {
            s.append(" encoding=\"" + encoding + "\"");
        }
        s.append("?>\n");
        if (this.externalDTD != null) {
            s.append("<!DOCTYPE " + this.rootElement + " SYSTEM \"" + this.externalDTD + "\"" + ">\n");
        }
        s.append(this.buffer.toString());
        return s.toString();
    }

    public XMLMemory toXML(String encoding) throws XMLException, UnsupportedEncodingException {
        this.encoding = encoding;
        byte[] buffer = this.toXMLDocString(encoding).getBytes(encoding);
        try {
            return (XMLMemory)XMLServices.getXML((AIIBlob)BlobServices.getBlobFromArray((byte[])buffer, (String)"xml"));
        }
        catch (InvalidArgumentException e) {
            return null;
        }
    }

    public XMLMemory toXML() throws XMLException {
        try {
            return this.toXML("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnexpectedException((Exception)ex);
        }
    }

    public boolean hasRootElement() {
        return this.closeCount == 1;
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 50) {
            XMLTagStream xml = new XMLTagStream();
            xml.openTag("root");
            xml.setReadableOutput(true);
            xml.setExternalDTD("/path/external.dtd");
            xml.openTag("inner");
            xml.addAttr("nr", "9000");
            xml.addAttr("id", "TEST");
            xml.addText("Dies ist ein <Testtext> ");
            xml.openTag("tag2");
            xml.addText("\"Test\" & Text");
            xml.openTag("TX");
            xml.addAttr("x", "JHLK&\"\"");
            xml.closeTag();
            xml.closeTag("tag2");
            xml.addText("noch ein Testtext mit Umlauten&Sonderzeichen: \u00e4\u00fc\u00f6\u00d6\u00c4\u00dc\u00df &amp; & <>>");
            xml.closeTag("inner");
            xml.openTag("eins");
            xml.addNamespace("a", "x");
            xml.openTag("zwei");
            xml.setDefaultNamespace("qwertz");
            xml.addNamespace("b", "y");
            xml.addNamespace("leer", "");
            xml.addTextTag("", "tdszft", "fguzk");
            xml.openTag("drei");
            xml.setDefaultNamespace("w");
            xml.addNamespace("b", "x");
            xml.addNamespace("c", "z");
            xml.addNamespace("d", "z");
            xml.addAttr("x", "testattr", "wert");
            xml.addTextTag("d:test1", "blabla");
            xml.addTextTag("HGJ", "test1", "blabla2");
            xml.addTextTag("z", "test1", "blabla3");
            xml.closeTag();
            xml.closeTag();
            xml.closeTag("eins");
            String XLINK_URI = "http://www.w3.org/1999/xlink";
            xml.openTag("namespacetest");
            xml.setDefaultNamespace("urn:sap-com:ifr");
            xml.addNamespace("xlink", XLINK_URI);
            xml.addNamespace("hugo", "urn:hugo-org");
            xml.openTag("hugo:test1");
            xml.closeTag();
            xml.openTag("urn:hugo-org", "test2");
            xml.closeTag();
            xml.openTag("test3");
            xml.addAttr(XLINK_URI, "href", "http://irgendwo.xml");
            xml.addAttr("murks", "attr", "wert");
            xml.addText("...");
            xml.closeTag();
            xml.openTag("test4");
            xml.addNamespace("urn:test");
            xml.addTextTag("urn:test", "name", "Meyer");
            xml.closeAllTags();
            System.out.println("\n>>>XML = " + xml.toXMLDocString("UTF-8"));
            xml.clear();
            System.out.println("\n>>>cleared XML = " + xml.toString());
            xml.openTag("eins");
            xml.addNamespace("a", "x");
            xml.openTag("Hallo").addAttr("nr", "5").addText("Test").closeTag();
            xml.closeAllTags();
            System.out.println("\n>>> new XML = " + xml.toXMLDocString("UTF-8"));
            ++i;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time = " + (endTime - startTime) + " ms");
    }
}

