/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.BaseRuntimeException;
import com.sap.aii.util.misc.api.ResourceException;
import com.sap.aii.util.misc.api.StringUtil;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.xml.api.SAXCopyHandler;
import com.sap.aii.util.xml.api.SAXElement;
import com.sap.aii.util.xml.api.StreamElement;
import com.sap.aii.util.xml.api.XML;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.XText;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;

public class XMLStream {
    protected static final Logger log = Logger.getLogger((String)(class$com$sap$aii$util$xml$api$XMLStream == null ? (class$com$sap$aii$util$xml$api$XMLStream = XMLStream.class$("com.sap.aii.util.xml.api.XMLStream")) : class$com$sap$aii$util$xml$api$XMLStream).getName());
    public static final String NAMESPACE_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String NAMESPACE_XLINK = "http://www.w3.org/1999/xlink";
    protected OutputStream outStream;
    protected String encoding;
    protected Writer out;
    protected StreamElement current;
    protected int mode;
    protected boolean documentStarted;
    protected int closeCount;
    private int prefix_count;
    protected String externalDTD;
    protected String rootElement;
    protected boolean readableOutput = false;
    protected String indent = "   ";
    public static int DOCUMENT = 0;
    public static int ELEMENT = 1;
    public static int FRAGMENT = 2;
    static /* synthetic */ Class class$com$sap$aii$util$xml$api$XMLStream;

    protected void initStream(OutputStream outStream, String encoding) throws UnsupportedEncodingException {
        this.outStream = outStream;
        this.encoding = encoding;
        this.out = new OutputStreamWriter(outStream, encoding);
    }

    protected void initStream(Writer out, String encoding) {
        this.outStream = null;
        this.encoding = encoding;
        this.out = out;
    }

    protected void init() {
        this.current = null;
        this.documentStarted = false;
        this.prefix_count = 0;
        this.closeCount = 0;
        this.externalDTD = null;
        this.rootElement = null;
    }

    protected XMLStream(int mode) {
        this.mode = mode;
    }

    public XMLStream(OutputStream outStream) {
        this(DOCUMENT);
        try {
            this.initStream(outStream, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnexpectedException((Exception)ex);
        }
        this.init();
    }

    public XMLStream(OutputStream outStream, int mode, String encoding) throws UnsupportedEncodingException {
        this(mode);
        this.initStream(outStream, encoding);
        this.init();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    void setIndent2(String indent) {
        this.indent = indent;
    }

    void setReadableOutput2(boolean x) {
        this.readableOutput = x;
    }

    protected static boolean isValidName(String name) {
        if (name.length() < 1) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && !StringUtil.contains((String)"_", (char)c)) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && !StringUtil.contains((String)"_-.", (char)c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setDefaultNamespace(String uri) throws XMLException {
        this.addNamespace("", uri);
    }

    public String getDefaultNamespace() {
        if (this.current == null) {
            return "";
        }
        String ret = this.current.getDefaultNamespace();
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public String addNamespace(String prefix, String uri) throws XMLException {
        if (prefix.equals("xml") && uri.equals(NAMESPACE_XML)) {
            return "xml";
        }
        String attr = "xmlns";
        if (prefix.length() > 0) {
            if (!XMLStream.isValidName(prefix)) {
                throw new XMLException(XMLException.createMsg_ILLEGAL_NAME(prefix));
            }
            if (prefix.toLowerCase().startsWith("xml")) {
                throw new XMLException(XMLException.createMsg_RESERVED_PREFIX(prefix));
            }
            attr = attr + ":" + prefix;
        }
        StreamElement.putNamespace(this.current, prefix, uri);
        this.oldAddAttr(attr, uri);
        return prefix;
    }

    public String addNamespace(String uri) throws XMLException {
        if (uri.equals(NAMESPACE_XML)) {
            return "xml";
        }
        String prefix = this.getPrefixOrNull(uri, true);
        if (prefix == null) {
            prefix = this.generatePrefix();
            this.addNamespace(prefix, uri);
        }
        return prefix;
    }

    protected String generatePrefix() {
        String prefix;
        do {
            ++this.prefix_count;
        } while (this.isPrefixDefined(prefix = "_" + this.prefix_count, false));
        return prefix;
    }

    private boolean isPrefixDefined(String prefix, boolean local) {
        if (this.current == null) {
            return false;
        }
        return this.current.getPrefixMapping(local).containsKey(prefix);
    }

    public String getPrefix(String uri, boolean useDefault) throws XMLException {
        String prefix = this.getPrefixOrNull(uri, useDefault);
        if (prefix == null) {
            throw new XMLException(XMLException.createMsg_UNKNOWN_NAMESP(uri));
        }
        return prefix;
    }

    private String getPrefixOrNull(String uri, boolean useDefault) {
        String prefix = this.current == null ? (useDefault && "".equals(uri) ? "" : null) : this.current.getPrefix(uri, useDefault);
        return prefix;
    }

    public String getPrefix(String uri) throws XMLException {
        return this.getPrefix(uri, true);
    }

    protected static String qualifiedName(String prefix, String name) {
        if (prefix.length() > 0) {
            name = prefix + ':' + name;
        }
        return name;
    }

    protected String testQualifiedName(String qualName) throws XMLException {
        String name;
        String prefix;
        int pos = qualName.indexOf(58);
        if (pos == -1) {
            prefix = "";
            name = qualName;
        } else {
            prefix = qualName.substring(0, pos);
            name = qualName.substring(pos + 1);
            if (!XMLStream.isValidName(prefix)) {
                throw new XMLException(XMLException.createMsg_ILLEGAL_NAME(prefix));
            }
            if (!this.isPrefixDefined(prefix, false)) {
                throw new XMLException(XMLException.createMsg_PREFIX_NOT_DEF(prefix));
            }
        }
        this.testName(name);
        return prefix;
    }

    protected void testName(String name) throws XMLException {
        if (!XMLStream.isValidName(name)) {
            throw new XMLException(XMLException.createMsg_ILLEGAL_NAME(name));
        }
    }

    public Map getNamespaces() {
        if (this.current == null) {
            return Collections.EMPTY_MAP;
        }
        return this.current.getNamespaces();
    }

    public SAXElement getElement() {
        return this.current;
    }

    private void startDocument() throws IOException {
        this.out.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.out.write(" encoding=\"" + this.encoding + "\"");
        }
        this.out.write("?>\n");
        this.documentStarted = true;
    }

    public void close() throws XMLException, IOException {
        this.testWellFormed();
        if (this.mode != FRAGMENT && this.closeCount != 1) {
            throw new BaseRuntimeException(XMLException.createMsg_ROOT());
        }
        this.flush();
        this.out.close();
    }

    private void oldOpenTag(String prefix, String name) throws XMLException {
        if (this.mode != FRAGMENT && this.closeCount > 0) {
            throw new XMLException(XMLException.createMsg_ROOT());
        }
        String qname = XMLStream.qualifiedName(prefix, name);
        try {
            if (this.mode == DOCUMENT && !this.documentStarted) {
                this.startDocument();
            }
            this.finishTag();
            this.current = new StreamElement(this.current, name, prefix);
            if (this.readableOutput) {
                this.addNewline();
            }
            this.out.write(60);
            this.out.write(qname);
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
        if (this.rootElement == null) {
            this.rootElement = qname;
        }
    }

    public XMLStream openTag(String qname) throws XMLException {
        String prefix = this.testQualifiedName(qname);
        String name = "".equals(prefix) ? qname : qname.substring(prefix.length() + 1);
        this.oldOpenTag(prefix, name);
        return this;
    }

    public XMLStream openTag(String uri, String name) throws XMLException {
        boolean isNewPrefix = false;
        String prefix = this.getPrefixOrNull(uri, true);
        if (prefix == null) {
            prefix = this.generatePrefix();
            isNewPrefix = true;
        }
        this.testName(name);
        this.oldOpenTag(prefix, name);
        if (isNewPrefix) {
            this.addNamespace(prefix, uri);
        }
        return this;
    }

    public XMLStream openTag(String prefix, String uri, String name) throws XMLException {
        this.testName(prefix);
        this.testName(name);
        this.oldOpenTag(prefix, name);
        this.addNamespace(prefix, uri);
        return this;
    }

    public String closeTag() throws XMLException {
        if (this.current == null) {
            throw new XMLException(XMLException.createMsg_NO_OPEN_TAG());
        }
        String qname = XMLStream.qualifiedName(this.current.getPrefix(), this.current.getName());
        try {
            if (this.current.isOpenForAttributes()) {
                this.out.write(" /");
                this.finishTag();
            } else {
                if (this.readableOutput) {
                    this.addNewline();
                }
                this.out.write("</");
                this.out.write(qname);
                this.out.write(62);
            }
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
        this.current.setClosed();
        this.current = (StreamElement)this.current.getParent();
        if (this.current == null) {
            ++this.closeCount;
        }
        return qname;
    }

    public void closeTag(String name) throws XMLException {
        String tag_name = this.closeTag();
        if (!tag_name.equals(name)) {
            throw new XMLException(XMLException.createMsg_NAME_MATCH(name, tag_name));
        }
    }

    public void closeTag(String uri, String name) throws XMLException {
        StreamElement cur = this.current;
        String qname = this.closeTag();
        if (!cur.getName().equals(name)) {
            throw new XMLException(XMLException.createMsg_NAME_MATCH(name, cur.getName()));
        }
        if (uri == null) {
            if (cur.getNamespace() != null) {
                throw new XMLException(XMLException.createMsg_NAME_MATCH(name, qname));
            }
        } else if (!uri.equals(cur.getNamespace())) {
            throw new XMLException(XMLException.createMsg_NAME_MATCH(XMLStream.qualifiedName(cur.getPrefix(uri, true), name), qname));
        }
    }

    protected void closeAllTags() throws XMLException {
        while (this.current != null) {
            this.closeTag();
        }
    }

    protected void finishTag() throws IOException {
        if (this.current != null && this.current.isOpenForAttributes()) {
            this.out.write(62);
            this.current.closeForAttributes();
        }
    }

    protected void addNewline() throws IOException {
        this.out.write("\n");
        int level = 0;
        if (this.current != null) {
            level = this.current.getLevel() - 1;
        }
        int i = 0;
        while (i < level) {
            this.out.write(this.indent);
            ++i;
        }
    }

    public XMLStream addComment(String text) throws XMLException {
        if (this.mode == ELEMENT && this.current == null) {
            throw new XMLException(XMLException.createMsg_ADD_COMMENT());
        }
        StringBuffer buffer = new StringBuffer(text);
        StringUtil.replaceSubString((StringBuffer)buffer, (String)"--", (String)"-=");
        try {
            if (this.mode == DOCUMENT && !this.documentStarted) {
                this.startDocument();
            }
            this.finishTag();
            if (this.readableOutput) {
                this.addNewline();
            }
            this.out.write("<!-- ");
            this.out.write(buffer.toString());
            this.out.write(" -->");
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
        return this;
    }

    public XMLStream addPI(String target, String text) throws XMLException {
        if (this.mode == ELEMENT && this.current == null) {
            throw new XMLException(XMLException.createMsg_ADD_PI());
        }
        this.testName(target);
        if (text.indexOf("?>") > -1) {
            throw new XMLException(XMLException.createMsg_ILLEGAL_CHAR("?>", "ProcessingInstruction"));
        }
        try {
            if (this.mode == DOCUMENT && !this.documentStarted) {
                this.startDocument();
            }
            this.finishTag();
            if (this.readableOutput) {
                this.addNewline();
            }
            this.out.write("<?");
            this.out.write(target);
            this.out.write(32);
            this.out.write(text);
            this.out.write("?>");
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
        return this;
    }

    protected XMLStream addRawText(String text) throws XMLException, IOException {
        this.finishTag();
        this.out.write(text);
        return this;
    }

    public XMLStream addText(String text) throws XMLException {
        if (this.mode != FRAGMENT && this.current == null) {
            throw new XMLException(XMLException.createMsg_NO_OPEN_TAG());
        }
        try {
            this.finishTag();
            if (this.readableOutput) {
                this.addNewline();
            }
            this.out.write(StringUtil.escapeXMLChars((String)text));
            if (this.current != null) {
                this.current.addContent(text);
            }
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
        return this;
    }

    public XMLStream addTextTag(String name, String text) throws XMLException {
        this.openTag(name);
        boolean temp = this.readableOutput;
        this.readableOutput = false;
        if (text.length() > 0) {
            this.addText(text);
        }
        this.closeTag();
        this.readableOutput = temp;
        return this;
    }

    public XMLStream addTextTag(String uri, String name, String text) throws XMLException {
        this.openTag(uri, name);
        boolean temp = this.readableOutput;
        this.readableOutput = false;
        if (text != null && text.length() > 0) {
            this.addText(text);
        }
        this.closeTag();
        this.readableOutput = temp;
        return this;
    }

    protected void oldAddAttr(String name, String value) throws XMLException {
        try {
            this.out.write(32);
            this.out.write(name);
            this.out.write("=\"");
            this.out.write(StringUtil.escapeXMLChars((String)value));
            this.out.write(34);
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
    }

    public XMLStream addAttr(String qname, String value) throws XMLException {
        String uri;
        String name;
        String prefix = this.testQualifiedName(qname);
        if (this.current == null || "".equals(prefix)) {
            name = qname;
            uri = "";
        } else {
            name = qname.substring(prefix.length() + 1);
            uri = this.current.getUri(prefix);
        }
        this.addAttr(uri, name, qname, value);
        return this;
    }

    public XMLStream addAttr(String uri, String name, String value) throws XMLException {
        String prefix;
        try {
            prefix = this.getPrefix(uri, false);
        }
        catch (XMLException e) {
            prefix = this.addNamespace(uri);
        }
        this.testName(name);
        this.addAttr(uri, name, XMLStream.qualifiedName(prefix, name), value);
        return this;
    }

    private void addAttr(String uri, String name, String qname, String value) throws XMLException {
        if (this.current == null) {
            throw new XMLException(XMLException.createMsg_NO_OPEN_TAG());
        }
        this.current.addAttr(uri, name, qname, value);
        this.oldAddAttr(qname, value);
    }

    public XMLStream addXML(XML xml) throws XMLException {
        try {
            this.finishTag();
            SAXCopyHandler copyHandler = new SAXCopyHandler(this);
            xml.SAXparse(copyHandler);
        }
        catch (ResourceException ex) {
            throw new UnexpectedException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new XMLException(ex);
        }
        catch (SAXException ex) {
            throw new XMLException(ex);
        }
        return this;
    }

    public XMLStream addXML(XElement element) throws XMLException {
        XNamespace ns = element.getNamespace();
        this.openTag(ns.getURI(), element.getLocalName());
        Iterator attributes = element.getAttributes().iterator();
        while (attributes.hasNext()) {
            XAttribute attribute = (XAttribute)attributes.next();
            XName name = attribute.getName();
            this.addAttr(name.getNamespace().getURI(), attribute.getLocalName(), attribute.getValue());
        }
        Iterator content = element.getMixedContent().iterator();
        while (content.hasNext()) {
            Object next = content.next();
            if (next instanceof XElement) {
                this.addXML((XElement)next);
                continue;
            }
            if (!(next instanceof XText)) continue;
            this.addText(((XText)next).getText());
        }
        this.closeTag();
        return this;
    }

    public boolean isWellFormed() {
        return this.current == null;
    }

    protected void testWellFormed() throws XMLException {
        if (!this.isWellFormed()) {
            String name = this.current.getName();
            throw new XMLException(XMLException.createMsg_WELL_FORMED(name));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

