/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.blob.api.AIIBlobMemory;
import com.sap.aii.util.blob.api.BlobServices;
import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.AIIProperties;
import com.sap.aii.util.misc.api.BaseRuntimeException;
import com.sap.aii.util.misc.api.Digest;
import com.sap.aii.util.misc.api.InternalErrorException;
import com.sap.aii.util.misc.api.InvalidArgumentException;
import com.sap.aii.util.misc.api.ResourceException;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.xml.api.SAXCopyHandler;
import com.sap.aii.util.xml.api.SAXHandler;
import com.sap.aii.util.xml.api.SAXStopException;
import com.sap.aii.util.xml.api.XML;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLMemory;
import com.sap.aii.util.xml.api.XMLMemoryStream;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.aii.util.xml.api.XMLblob;
import com.sap.aii.util.xml.api.XMLloc;
import com.sap.aii.util.xml.api.XiSAXException;
import com.sap.aii.util.xml.jdom.Document;
import com.sap.aii.util.xml.jdom.JDOMException;
import com.sap.aii.util.xml.jdom.SAXBuilder;
import com.sap.aii.util.xml.jdom.XMLOutputter;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.io.XDOMInputter;
import com.sap.aii.util.xml.xdom.io.XDOMOutputter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLServices {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$util$xml$api$XMLServices == null ? (class$com$sap$aii$util$xml$api$XMLServices = XMLServices.class$("com.sap.aii.util.xml.api.XMLServices")) : class$com$sap$aii$util$xml$api$XMLServices).getName());
    private static final XDOMOutputter outputter = new XDOMOutputter();
    private static final XDOMFactory xFactory = new XDOMFactory();
    private static final String DEFAULT_PARSER_FACTORY = "com.sap.engine.lib.jaxp.SAXParserFactoryImpl";
    private static final String DEFAULT_TRANSFORMER_FACTORY = "com.sap.engine.lib.jaxp.TransformerFactoryImpl";
    private static SAXParserFactory factory = null;
    static /* synthetic */ Class class$com$sap$aii$util$xml$api$XMLServices;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    private XMLServices() {
    }

    public static XML getXML(AIIBlob b) throws InvalidArgumentException {
        if (b == null) {
            return null;
        }
        XMLblob x = new XMLblob(b);
        if (b instanceof AIIBlobMemory) {
            try {
                return new XMLloc(x);
            }
            catch (ResourceException e) {
                return x;
            }
        }
        return x;
    }

    public static XMLMemory getXMLIntoMemory(XML x) throws ResourceException {
        if (x instanceof XMLMemory) {
            return (XMLMemory)x;
        }
        return new XMLloc(x);
    }

    public static TransformerFactory getTransformerFactory() {
        TransformerFactory fact = null;
        AIIProperties props = AIIProperties.getInstance();
        try {
            fact = (TransformerFactory)Class.forName(props.getProperty("com.sap.aii.util.xml.transformerFactory", DEFAULT_TRANSFORMER_FACTORY)).newInstance();
        }
        catch (Exception e) {
            log.error("can't get xslt-transformer", (Throwable)e);
        }
        return fact;
    }

    public static synchronized SAXParserFactory getParserFactory() {
        if (factory == null) {
            AIIProperties props = AIIProperties.getInstance();
            String name = props.getProperty("com.sap.aii.util.xml.parserFactory", DEFAULT_PARSER_FACTORY);
            log.finest("ParserFactory \"" + name + "\"");
            try {
                factory = (SAXParserFactory)Class.forName(name).newInstance();
                if (log.getActiveLevel().compareTo((Object)Level.FINEST) <= 0) {
                    ClassLoader cl = (class$com$sap$aii$util$xml$api$XMLServices == null ? (class$com$sap$aii$util$xml$api$XMLServices = XMLServices.class$("com.sap.aii.util.xml.api.XMLServices")) : class$com$sap$aii$util$xml$api$XMLServices).getClassLoader();
                    URL url = cl.getResource("javax/xml/parsers/SAXParserFactory.class");
                    log.finest("got ParserFactory \"" + factory.getClass().getName() + "\" from \"" + url + "\"");
                }
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                factory.setValidating(false);
            }
            catch (Exception e) {
                throw new BaseRuntimeException((Throwable)e);
            }
        }
        return factory;
    }

    public static Digest digest(XML xml) throws ResourceException {
        return new Digest(BlobServices.getByteArray((AIIBlob)xml.getBlob()));
    }

    public static Document getJDOM(XML xml) throws ResourceException, JDOMException {
        if (xml instanceof JDOMXML) {
            return ((JDOMXML)xml).getDocument();
        }
        if (xml instanceof XDOMXML) {
            return Document.wrap(((XDOMXML)xml).getDocument());
        }
        return XMLServices.transformXMLtoJDOM(xml);
    }

    private static Document transformXMLtoJDOM(XML xml) throws ResourceException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        return builder.build(xml.getBlob().getBinaryStream());
    }

    public static XML getJDOMXML(XML xml) throws ResourceException, JDOMException {
        if (xml instanceof JDOMXML) {
            return xml;
        }
        return new JDOMXML(XMLServices.transformXMLtoJDOM(xml));
    }

    public static XML getXML(Document doc) throws IOException {
        return new JDOMXML(doc);
    }

    public static XDocument getXDOM(XML xml) throws ResourceException, XDOMException {
        if (xml instanceof XDOMXML) {
            return ((XDOMXML)xml).getDocument();
        }
        if (xml instanceof JDOMXML) {
            return ((JDOMXML)xml).getDocument().unwrap();
        }
        return XMLServices.transformXMLtoXDOM(xml);
    }

    private static XDocument transformXMLtoXDOM(XML xml) throws ResourceException, XDOMException {
        XDOMInputter builder = new XDOMInputter();
        return builder.read(xml.getBlob().getBinaryStream());
    }

    public static XMLMemory getXDOMXML(XML xml) throws ResourceException, XDOMException {
        if (xml instanceof XDOMXML) {
            return (XDOMXML)xml;
        }
        return new XDOMXML(XMLServices.transformXMLtoXDOM(xml));
    }

    public static XMLMemory getXML(XDocument doc) throws ResourceException {
        return new XDOMXML(doc);
    }

    public static XMLMemory getXMLIntoMemoryWhileSAXParse(XML x, SAXHandler dh) throws ResourceException, SAXException {
        SAXHandler run;
        SAXCopyHandler ch = null;
        if (x instanceof XMLMemory) {
            run = dh;
        } else {
            ch = new SAXCopyHandler();
            run = new SAXHandler(dh);
            run.addHandler(ch);
        }
        try {
            x.SAXparse(run);
        }
        catch (SAXStopException e) {
            // empty catch block
        }
        if (x instanceof XMLMemory) {
            return (XMLMemory)x;
        }
        try {
            return XMLServices.getXMLIntoMemory(ch.getCopy());
        }
        catch (XMLException e) {
            throw new InternalErrorException((Throwable)((Object)e));
        }
    }

    public static String prettyPrintXML(XML xml, String indent) {
        try {
            XMLMemoryStream xml_out = new XMLMemoryStream(XMLStream.DOCUMENT, "ISO-8859-1");
            xml_out.setReadableOutput2(true);
            xml_out.setIndent2(indent);
            XMLTrimHandler handler = new XMLTrimHandler(xml_out);
            xml.SAXparse(handler);
            return xml_out.toString();
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex);
        }
    }

    public static String validateXML(InputStream xml, InputStream schema) throws ParserConfigurationException, IOException, SAXException, IllegalStateException {
        org.w3c.dom.Document xmlDoc = null;
        org.w3c.dom.Document xsdDoc = null;
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(true);
        xmlDoc = null;
        xsdDoc = null;
        DocumentBuilder b = f.newDocumentBuilder();
        xmlDoc = b.parse(new InputSource(xml));
        xsdDoc = b.parse(new InputSource(schema));
        try {
            return XMLServices.validateXML(xmlDoc, xsdDoc);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Validator not found");
        }
    }

    public static String validateXML(Node xml, Node xsd) throws IllegalStateException {
        try {
            AIIProperties props = AIIProperties.getInstance();
            String className = props.getProperty("com.sap.aii.util.xml.schemaValidator", "com.sap.engine.lib.schema.validator.SchemaValidator");
            log.finest("SchemaValidator \"" + className + "\"");
            Class<?> sv = Class.forName(className);
            Object validator = sv.newInstance();
            Class[] clparams = new Class[]{class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XMLServices.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XMLServices.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node};
            Method validateMethod = sv.getDeclaredMethod("validate", clparams);
            Object[] params = new Object[]{xml, xsd};
            Object result = validateMethod.invoke(validator, params);
            boolean valid = false;
            if (result instanceof Boolean) {
                valid = (Boolean)result;
            }
            if (!valid) {
                Method descrMethod = sv.getDeclaredMethod("getDescriptionOfTheFirstError", new Class[0]);
                Object descr = descrMethod.invoke(validator, new Object[0]);
                return descr.toString();
            }
            return null;
        }
        catch (Exception e) {
            if (e.getClass().getName().endsWith("SchemaException")) {
                throw new IllegalStateException("Schema is not valid " + e.getMessage());
            }
            log.error("error in schema validator", (Throwable)e);
            throw new IllegalStateException("Validator not found");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class XDOMXML
    extends XMLMemory {
        private XDocument doc;

        public XDOMXML(XDocument doc) {
            this.doc = doc;
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XDOMOutputter outputter = new XDOMOutputter();
                outputter.write(this.doc, (OutputStream)baos);
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new UnexpectedException((Exception)e);
            }
        }

        public AIIBlob getBlob() {
            return BlobServices.getBlobFromArray((byte[])this.toByteArray(), (String)"xml");
        }

        public void sendToOutputstream(OutputStream out) throws ResourceException {
            try {
                XDOMOutputter outputter = new XDOMOutputter();
                outputter.write(this.doc, out);
            }
            catch (IOException e) {
                throw new ResourceException((Throwable)e);
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            try {
                XDOMOutputter outputter = new XDOMOutputter();
                outputter.write(this.doc, (Writer)sw);
            }
            catch (IOException e) {
                log.error("error in toString()", (Throwable)e);
                return "";
            }
            return sw.toString();
        }

        public XDocument getDocument() {
            return this.doc;
        }
    }

    private static class JDOMXML
    extends XML {
        private Document doc;

        public JDOMXML(Document doc) {
            this.doc = doc;
        }

        private byte[] toByteArray() throws ResourceException {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(this.doc, (OutputStream)baos);
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new ResourceException((Throwable)e);
            }
        }

        public AIIBlob getBlob() throws ResourceException {
            return BlobServices.getBlobFromArray((byte[])this.toByteArray(), (String)"xml");
        }

        public void sendToOutputstream(OutputStream out) throws ResourceException {
            try {
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(this.doc, out);
            }
            catch (IOException e) {
                throw new ResourceException((Throwable)e);
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            try {
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(this.doc, (Writer)sw);
            }
            catch (IOException e) {
                log.error("error while toString()", (Throwable)e);
                return "";
            }
            return sw.toString();
        }

        public Document getDocument() {
            return this.doc;
        }
    }

    private static class XMLTrimHandler
    extends SAXCopyHandler {
        private StringBuffer content = new StringBuffer();

        public XMLTrimHandler(XMLMemoryStream xml) {
            super(xml);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws XiSAXException {
            this.flushContent();
            super.startElement(uri, localName, qName, attributes);
        }

        public void endElement(String uri, String localName, String qName) throws XiSAXException {
            this.flushContent();
            super.endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws XiSAXException {
            this.content.append(ch, start, length);
        }

        private void flushContent() throws XiSAXException {
            char[] buffer = this.content.toString().trim().toCharArray();
            if (buffer.length > 0) {
                super.characters(buffer, 0, buffer.length);
            }
            this.content.delete(0, this.content.length());
        }
    }
}

