/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.IOUtil;
import com.sap.aii.util.misc.api.ResourceException;
import com.sap.aii.util.xml.api.ControlledSAXHandler;
import com.sap.aii.util.xml.api.SAXHandler;
import com.sap.aii.util.xml.api.XMLServices;
import com.sap.aii.util.xml.api.XiSAXException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XML {
    public static final String MIMETYPE = "xml";
    private static final Logger logger = Logger.getLogger((String)(class$com$sap$aii$util$xml$api$XML == null ? (class$com$sap$aii$util$xml$api$XML = XML.class$("com.sap.aii.util.xml.api.XML")) : class$com$sap$aii$util$xml$api$XML).getName());
    private static Stack parsers = new Stack();
    static /* synthetic */ Class class$com$sap$aii$util$xml$api$XML;

    public abstract AIIBlob getBlob() throws ResourceException;

    public void sendToOutputstream(OutputStream out) throws ResourceException {
        try {
            IOUtil.copyStream((InputStream)this.getBlob().getBinaryStream(), (OutputStream)out);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream(this.getBlob().length());
            this.sendToOutputstream(o);
            return o.toString();
        }
        catch (ResourceException e) {
            return e.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void SAXparse(DefaultHandler dh) throws ResourceException, SAXException {
        if (dh instanceof ControlledSAXHandler) {
            this.SAXparse(((ControlledSAXHandler)dh).getControler());
            return;
        }
        SAXParser parser = null;
        Stack stack = parsers;
        // MONITORENTER : stack
        try {
            parser = (SAXParser)parsers.pop();
        }
        catch (EmptyStackException e) {
            // empty catch block
        }
        if (parser == null) {
            try {
                parser = XMLServices.getParserFactory().newSAXParser();
            }
            catch (Exception e) {
                XML.th(e);
            }
        }
        if (dh instanceof SAXHandler) {
            dh = new SAXHandler((SAXHandler)dh, true);
        }
        try {
            try {
                parser.parse(this.getBlob().getBinaryStream(), dh);
            }
            catch (Exception e) {
                XML.th(e);
                Object var7_9 = null;
                parsers.push(parser);
                return;
            }
            Object var7_8 = null;
            parsers.push(parser);
            return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            parsers.push(parser);
            throw throwable;
        }
    }

    private static void th(Exception e) throws SAXException, ResourceException {
        if (e instanceof SAXException) {
            SAXException f = (SAXException)e;
            if (!(f instanceof XiSAXException)) {
                logger.error("SAXException from parser: " + f.getMessage(), (Throwable)f.getException());
            }
            throw f;
        }
        if (e instanceof ResourceException) {
            throw (ResourceException)((Object)e);
        }
        throw new ResourceException((Throwable)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

