/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.xml.api.SAXElement;
import com.sap.aii.util.xml.api.XMLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class StreamElement
extends SAXElement {
    private String prefix;
    private Map prefixes = new HashMap();
    private boolean openForAttributes = true;
    private AttributesImpl attributes = new AttributesImpl();

    StreamElement(StreamElement father, String name, String prefix) {
        super(father, name);
        this.prefix = prefix;
        this.namespaces = new HashMap();
    }

    public String getNamespace() {
        return (String)this.getPrefixMapping(true).get(this.prefix);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    String getPrefix() {
        return this.prefix;
    }

    static void putNamespace(StreamElement element, String prefix, String uri) throws XMLException {
        if (element == null || !element.openForAttributes) {
            throw new XMLException(XMLException.createMsg_ADD_ATTR());
        }
        element.addNamespace(prefix, uri);
        if (!"".equals(prefix)) {
            element.prefixes.put(uri, prefix);
        }
    }

    String getPrefix(String uri, boolean useDefault) {
        String ret;
        if (useDefault) {
            String def = this.getDefaultNamespace();
            if (def == null) {
                def = "";
            }
            if (def.equals(uri)) {
                return "";
            }
        }
        if ((ret = (String)this.prefixes.get(uri)) != null) {
            return ret;
        }
        Map nsps = this.getPrefixMapping(true);
        StreamElement el = (StreamElement)this.getParent();
        while (el != null) {
            ret = el.getPrefix(uri, false);
            if (ret == null) {
                return null;
            }
            if (uri.equals(nsps.get(ret))) {
                return ret;
            }
            Iterator entries = el.getPrefixMapping(false).entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!uri.equals(entry.getValue()) || !uri.equals(nsps.get(ret = (String)entry.getKey()))) continue;
                return ret;
            }
            el = (StreamElement)el.getParent();
        }
        return null;
    }

    Map getNamespaces() {
        Object uri;
        HashMap ret = new HashMap();
        HashSet doubts = new HashSet();
        Iterator entries = this.getPrefixMapping(true).entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            uri = entry.getValue();
            if (ret.put(uri, entry.getKey()) == null) continue;
            doubts.add(uri);
        }
        Iterator doubtIt = doubts.iterator();
        while (doubtIt.hasNext()) {
            uri = (String)doubtIt.next();
            ret.put(uri, this.getPrefix((String)uri, true));
        }
        return ret;
    }

    void closeForAttributes() {
        this.openForAttributes = false;
    }

    void addAttr(String uri, String name, String qname, String value) throws XMLException {
        if (!this.openForAttributes) {
            throw new XMLException(XMLException.createMsg_ADD_ATTR());
        }
        if (this.attributes.getValue(uri, name) != null) {
            throw new XMLException(XMLException.createMsg_DUPL_ATTR(qname));
        }
        this.attributes.addAttribute(uri, name, qname, "CDATA", value);
    }

    boolean isOpenForAttributes() {
        return this.openForAttributes;
    }

    void setClosed() {
        super.setClosed();
        this.closeForAttributes();
    }
}

