/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.xml.api.XMLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public abstract class SAXElement {
    private SAXElement element;
    private StringBuffer content;
    private boolean closed = false;
    private SAXElement father;
    private String uri;
    private String localName;
    Map namespaces;
    private String path = null;
    private int level = 0;
    private Map prefixMapping = null;

    SAXElement(SAXElement father, String localName) {
        this.father = father;
        this.localName = localName;
        this.content = new StringBuffer();
    }

    protected SAXElement(SAXElement element) {
        this.element = element;
    }

    public String getName() {
        if (this.element == null) {
            return this.localName;
        }
        return this.element.getName();
    }

    public String getPath() {
        if (this.element == null) {
            if (this.path == null) {
                this.path = this.father == null ? this.localName : this.father.getPath() + "/" + this.localName;
            }
            return this.path;
        }
        return this.element.getPath();
    }

    public SAXElement getParent() {
        if (this.element == null) {
            return this.father;
        }
        return this.element.getParent();
    }

    public int getLevel() {
        if (this.element == null) {
            if (this.level == 0) {
                this.level = this.father == null ? 1 : this.father.getLevel() + 1;
            }
            return this.level;
        }
        return this.element.getLevel();
    }

    public String getText() {
        if (this.element == null) {
            return this.content.toString();
        }
        return this.element.getText();
    }

    public boolean isClosed() {
        if (this.element == null) {
            return this.closed;
        }
        return this.element.isClosed();
    }

    public String getNamespace() {
        if (this.element == null) {
            return null;
        }
        return this.element.getNamespace();
    }

    public Map getPrefixMapping(boolean allLevels) {
        if (this.element == null) {
            if (this.father == null || !allLevels) {
                return Collections.unmodifiableMap(this.namespaces);
            }
            if (this.prefixMapping == null) {
                this.prefixMapping = new HashMap(this.father.getPrefixMapping(true));
                this.prefixMapping.putAll(this.namespaces);
            }
            return Collections.unmodifiableMap(this.prefixMapping);
        }
        return this.element.getPrefixMapping(allLevels);
    }

    public String getUri(String prefix) {
        String ret = (String)this.namespaces.get(prefix);
        if (ret == null && this.father != null) {
            ret = (String)this.getPrefixMapping(true).get(prefix);
        }
        return ret;
    }

    public String getDefaultNamespace() {
        if (this.element == null) {
            return (String)this.getPrefixMapping(true).get("");
        }
        return this.element.getDefaultNamespace();
    }

    public boolean isLocated(String path, int depth) {
        if (this.element == null) {
            if (depth == 0) {
                return this.getPath().equals(path);
            }
            if (depth > 0) {
                SAXElement parent = this.getParent();
                return parent != null && parent.isLocated(path, depth - 1);
            }
            return false;
        }
        return this.element.isLocated(path, depth);
    }

    public Attributes getAttributes() {
        if (this.element == null) {
            return null;
        }
        return this.element.getAttributes();
    }

    void setClosed() {
        this.closed = true;
    }

    void addContent(char[] chars, int start, int length) {
        this.content.append(chars, start, length);
    }

    void addContent(String text) {
        if (text != null) {
            this.content.append(text);
        }
    }

    void addNamespace(String prefix, String uri) throws XMLException {
        if (this.namespaces.containsKey(prefix)) {
            throw new XMLException(XMLException.createMsg_DUPL_NAMESP(prefix));
        }
        this.namespaces.put(prefix, uri);
        if (this.prefixMapping != null) {
            this.prefixMapping.put(prefix, uri);
        }
    }
}

