/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html.parser;

import com.sapportals.portal.prt.util.html.parser.HtmlDocument;
import com.sapportals.portal.prt.util.html.parser.ParserVisitor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HtmlStructurizer
extends ParserVisitor {
    protected MyVector tagStack = new MyVector();
    protected MyVector elements;
    protected boolean collected;
    protected static Hashtable dontMatch = new Hashtable();
    protected static String[] dontMatchStrings = new String[]{"AREA", "BASE", "BASEFONT", "BR", "COL", "HR", "IMG", "INPUT", "ISINDEX", "LINK", "META", "P", "PARAM"};

    protected int pushNode(HtmlDocument.HtmlElement e) {
        this.elements.addElement(e);
        return this.elements.size() - 1;
    }

    public void visit(HtmlDocument.Comment c) {
        this.pushNode(c);
    }

    public void visit(HtmlDocument.Text t) {
        this.pushNode(t);
    }

    public void visit(HtmlDocument.Newline n) {
        this.pushNode(n);
    }

    public void visit(HtmlDocument.Tag t) {
        TagStackEntry ts = new TagStackEntry();
        int index = this.pushNode(t);
        if (!t.emptyTag && !dontMatch.containsKey(t.tagName.toUpperCase())) {
            ts.tagName = t.tagName;
            ts.index = index;
            this.tagStack.addElement(ts);
        }
    }

    public void visit(HtmlDocument.EndTag t) {
        int i = this.tagStack.size() - 1;
        while (i >= 0) {
            TagStackEntry ts = (TagStackEntry)this.tagStack.elementAt(i);
            if (t.tagName.equalsIgnoreCase(ts.tagName)) {
                HtmlDocument.ElementSequence blockElements = new HtmlDocument.ElementSequence(this.elements.size() - ts.index - 1);
                int j = ts.index + 1;
                while (j < this.elements.size()) {
                    blockElements.addElement((HtmlDocument.HtmlElement)this.elements.elementAt(j));
                    ++j;
                }
                HtmlDocument.Tag tag = (HtmlDocument.Tag)this.elements.elementAt(ts.index);
                HtmlDocument.TagBlock block = new HtmlDocument.TagBlock(tag.tagName, tag.attributeList, blockElements);
                this.elements.popN(this.elements.size() - ts.index);
                this.elements.addElement(block);
                this.tagStack.popN(this.tagStack.size() - i);
                this.collected = true;
                break;
            }
            --i;
        }
        if (i < 0) {
            this.pushNode(t);
        }
    }

    public void visit(HtmlDocument.TagBlock bl) {
        HtmlStructurizer c = new HtmlStructurizer();
        c.start();
        c.visit(bl.body);
        c.finish();
        this.pushNode(bl);
    }

    public void visit(HtmlDocument.ElementSequence s) {
        this.elements = new MyVector(s.elements.size());
        this.collected = false;
        Enumeration e = s.elements.elements();
        while (e.hasMoreElements()) {
            ((HtmlDocument.HtmlElement)e.nextElement()).accept(this);
        }
        if (this.collected) {
            s.elements = this.elements;
        }
    }

    public void start() {
    }

    public void finish() {
    }

    static {
        Integer dummy = new Integer(0);
        int i = 0;
        while (i < dontMatchStrings.length) {
            dontMatch.put(dontMatchStrings[i], dummy);
            ++i;
        }
    }

    private static class MyVector
    extends Vector {
        MyVector() {
        }

        MyVector(int n) {
            super(n);
        }

        public void popN(int n) {
            this.elementCount -= n;
        }
    }

    private static class TagStackEntry {
        String tagName;
        int index;

        private TagStackEntry() {
        }
    }
}

