/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlContainer;
import com.sapportals.portal.prt.util.html.IHtmlUniqueObject;
import com.sapportals.portal.prt.util.html.Stringable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlStyle
extends HtmlContainer
implements IHtmlUniqueObject {
    protected StyleType m_styleType;
    protected String m_title;
    protected String m_styleId;

    public HtmlStyle() {
        this.setTag("style");
        this.m_styleType = StyleType.TEXT_CSS;
    }

    public HtmlStyle(String styleId) {
        this.setTag("style");
        this.m_styleType = StyleType.TEXT_CSS;
        if (styleId == null || styleId == "") {
            throw new Error("[HtmlStyle.HtmlStyle] style identifier is null.");
        }
        this.m_styleId = styleId;
    }

    public HtmlStyle(StyleType styleType) {
        this.setTag("style");
        this.m_styleType = styleType;
    }

    public void outputAttributes(StringBuffer strbuf) {
        if (this.getStyleType() != null) {
            strbuf.append("TYPE=\"").append(this.getStyleType()).append("\" ");
        }
        if (this.getTitle() != null) {
            strbuf.append("TITLE=").append(this.getTitle()).append(" ");
        }
        strbuf.append("MEDIA=\"screen\" ");
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        try {
            if (this.getStyleType() != null) {
                out.write("TYPE=\"");
                out.write(this.getStyleType().toString());
                out.write("\" ");
            }
            if (this.getTitle() != null) {
                out.write("TITLE=");
                out.write(this.getTitle());
                out.write(" ");
            }
            out.write("MEDIA=\"screen\" ");
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public StyleType getStyleType() {
        return this.m_styleType;
    }

    public HtmlStyle setStyleType(StyleType v) {
        this.m_styleType = v;
        return this;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String v) {
        this.m_title = v;
    }

    public String getUniqueId() {
        return this.m_styleId;
    }

    public void getUniqueHtmlCode(StringBuffer strbuf) {
        this.output(strbuf);
    }

    public void getUniqueHtmlCode(PrintWriter out) {
        this.output((Writer)out);
    }

    public void getUniqueHtmlCode(Writer out) {
        this.output(out);
    }

    public String getStyleId() {
        return this.m_styleId;
    }

    public void setStyleId(String v) {
        this.m_styleId = v;
    }

    public static class StyleType
    extends Stringable {
        public static final StyleType TEXT_CSS = new StyleType("text/css");

        private StyleType(String string) {
            super(string);
        }
    }
}

