/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlContainerIdentifiable;
import com.sapportals.portal.prt.util.html.IHtmlUniqueObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlScript
extends HtmlContainerIdentifiable
implements IHtmlUniqueObject {
    protected String m_uniqueId;
    protected String m_language;
    protected String m_src;
    protected String m_type;
    protected String m_for;
    protected String m_event;
    protected boolean m_deferred;

    public HtmlScript(String src) {
        this.setTag("script");
        if (src == null) {
            throw new Error("[HtmlScript.HtmlScript] THe script source is not given");
        }
        this.setSrc(src);
    }

    public HtmlScript() {
        this.setTag("script");
    }

    public void outputAttributes(StringBuffer strbuf) {
        super.outputAttributes(strbuf);
        if (this.m_deferred) {
            strbuf.append(" DEFER ");
        }
        if (this.m_language != null) {
            strbuf.append(" LANGUAGE=\"").append(this.m_language).append("\" ");
        }
        if (this.m_src != null) {
            strbuf.append(" SRC=\"").append(this.m_src).append("\" ");
        }
        if (this.m_type != null) {
            strbuf.append(" TYPE=\"").append(this.m_type).append("\" ");
        }
        if (this.m_for != null) {
            strbuf.append(" FOR=\"").append(this.m_for).append("\" ");
        }
        if (this.m_event != null) {
            strbuf.append(" EVENT=\"").append(this.m_event).append("\" ");
        }
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        super.outputAttributes(out);
        try {
            if (this.m_deferred) {
                out.write(" DEFER ");
            }
            if (this.m_language != null) {
                out.write(" LANGUAGE=\"");
                out.write(this.m_language);
                out.write("\" ");
            }
            if (this.m_src != null) {
                out.write(" SRC=\"");
                out.write(this.m_src);
                out.write("\" ");
            }
            if (this.m_type != null) {
                out.write(" TYPE=\"");
                out.write(this.m_type);
                out.write("\" ");
            }
            if (this.m_for != null) {
                out.write(" FOR=\"");
                out.write(this.m_for);
                out.write("\" ");
            }
            if (this.m_event != null) {
                out.write(" EVENT=\"");
                out.write(this.m_event);
                out.write("\" ");
            }
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public String getUniqueId() {
        return this.m_uniqueId;
    }

    public void setUniqueId(String v) {
        this.m_uniqueId = v;
    }

    public void getUniqueHtmlCode(StringBuffer strbuf) {
        this.output(strbuf);
    }

    public void getUniqueHtmlCode(PrintWriter writer) {
        this.output((Writer)writer);
    }

    public void getUniqueHtmlCode(Writer writer) {
        this.output(writer);
    }

    public String getLanguage() {
        return this.m_language;
    }

    public HtmlScript setLanguage(String v) {
        this.m_language = v;
        return this;
    }

    public String getSrc() {
        return this.m_src;
    }

    public HtmlScript setSrc(String v) {
        this.m_uniqueId = this.m_src = v;
        return this;
    }

    public String getType() {
        return this.m_type;
    }

    public HtmlScript setType(String v) {
        this.m_type = v;
        return this;
    }

    public String getFor() {
        return this.m_for;
    }

    public HtmlScript setFor(String v) {
        this.m_for = v;
        return this;
    }

    public String getEvent() {
        return this.m_event;
    }

    public HtmlScript setEvent(String v) {
        this.m_event = v;
        return this;
    }

    public boolean getDeferred() {
        return this.m_deferred;
    }

    public HtmlScript setDeferred(boolean v) {
        this.m_deferred = v;
        return this;
    }
}

