/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlContainerIdentifiableWithUniqueManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class HtmlObject
extends HtmlContainerIdentifiableWithUniqueManager {
    private String m_codebase;
    private String m_name;
    private Hashtable m_param;

    public HtmlObject() {
        this.setTag("object");
    }

    public void outputAttributes(StringBuffer strbuf) {
        super.outputAttributes(strbuf);
        if (this.m_codebase != null) {
            strbuf.append(new String("  CODEBASE=\"") + this.m_codebase + "\"\n");
        }
        if (this.m_name != null) {
            strbuf.append(new String("  NAME=\"") + this.m_name + "\"");
        }
        if (this.m_param != null) {
            Enumeration e = this.m_param.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)this.m_param.get(name);
                strbuf.append("   >\n <PARAM name=" + name + " value=\"" + value + "\"");
            }
        } else {
            strbuf.append("   >\n");
        }
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        StringBuffer buf = new StringBuffer(this.getElementCount() * 60);
        this.outputAttributes(buf);
        try {
            out.write(buf.toString());
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public HtmlObject setName(String name) {
        this.m_name = name;
        return this;
    }

    public HtmlObject setCodebase(String codebase) {
        this.m_codebase = codebase;
        return this;
    }

    public HtmlObject addParam(String name, String value) {
        if (this.m_param == null) {
            this.m_param = new Hashtable(10);
        }
        this.m_param.put(name, value);
        return this;
    }
}

