/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlFocusEventingFormItem;
import com.sapportals.portal.prt.util.html.Stringable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class HtmlInput
extends HtmlFocusEventingFormItem {
    protected InputType m_type;
    protected String m_value;

    public HtmlInput() {
        this.setTag("input");
        this.requireClosingTag(false);
    }

    public abstract String getSpecificProperties();

    public void outputAttributes(StringBuffer strbuf) {
        if (this.m_type != null) {
            strbuf.append(" TYPE=").append(this.m_type).append(" ");
        }
        if (this.m_value != null) {
            strbuf.append(" VALUE=\"").append(this.m_value).append("\" ");
        }
        strbuf.append(this.getSpecificProperties());
        super.outputAttributes(strbuf);
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        try {
            if (this.m_type != null) {
                out.write(" TYPE=");
                out.write(this.m_type.toString());
                out.write(" ");
            }
            if (this.m_value != null) {
                out.write(" VALUE=\"");
                out.write(this.m_value);
                out.write("\" ");
            }
            out.write(this.getSpecificProperties());
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
        super.outputAttributes(out);
    }

    public InputType getType() {
        return this.m_type;
    }

    public void setType(InputType v) {
        this.m_type = v;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String v) {
        this.m_value = v;
    }

    public static class InputType
    extends Stringable {
        public static final InputType TEXT = new InputType("TEXT");
        public static final InputType CHECKBOX = new InputType("CHECKBOX");
        public static final InputType RADIO = new InputType("RADIO");
        public static final InputType PASSWORD = new InputType("PASSWORD");
        public static final InputType HIDDEN = new InputType("HIDDEN");
        public static final InputType SUBMIT = new InputType("SUBMIT");
        public static final InputType RESET = new InputType("RESET");
        public static final InputType BUTTON = new InputType("BUTTON");
        public static final InputType FILE = new InputType("FILE");
        public static final InputType IMAGE = new InputType("IMAGE");

        private InputType(String string) {
            super(string);
        }
    }
}

