/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.util.html.Html;
import com.sapportals.portal.prt.util.html.HtmlBody;
import com.sapportals.portal.prt.util.html.HtmlDocType;
import com.sapportals.portal.prt.util.html.HtmlHead;
import com.sapportals.portal.prt.util.html.HtmlMeta;
import com.sapportals.portal.prt.util.html.HtmlTitle;
import java.io.IOException;
import java.io.Writer;

public class HtmlDocument {
    private Html mm_html = new Html();
    private HtmlHead mm_head = new HtmlHead();
    private HtmlBody mm_body;
    private HtmlTitle mm_title = new HtmlTitle();
    private HtmlMeta mm_meta;
    private String mm_codeset = null;
    private HtmlDocType mm_docType = null;

    public HtmlDocument() {
        this.mm_body = new HtmlBody();
        this.mm_meta = new HtmlMeta();
        this.mm_head.addUniqueObject("title", this.mm_title);
        this.mm_html.addUniqueObject("head", this.mm_head);
        this.mm_html.addUniqueObject("body", this.mm_body);
        this.mm_head.addUniqueObject("meta", this.mm_meta);
    }

    public HtmlDocType getDocType() {
        return this.mm_docType;
    }

    public HtmlDocument setDocType(HtmlDocType doctype) {
        this.mm_docType = doctype;
        return this;
    }

    public Html getHtml() {
        return this.mm_html;
    }

    public HtmlDocument setHtml(Html html) {
        this.mm_html = html;
        return this;
    }

    public HtmlHead getHead() {
        return this.mm_head;
    }

    public HtmlDocument setHead(HtmlHead head) {
        this.mm_html.addElement(head);
        return this;
    }

    public HtmlBody getBody() {
        return this.mm_body;
    }

    public HtmlDocument setBody(HtmlBody body) {
        this.mm_html.addUniqueObject("body", body);
        return this;
    }

    public HtmlTitle getTitle() {
        return this.mm_title;
    }

    public HtmlDocument setTitle(HtmlTitle title) {
        this.mm_head.addUniqueObject("title", title);
        return this;
    }

    public HtmlMeta getMeta() {
        return this.mm_meta;
    }

    public HtmlDocument setMeta(HtmlMeta meta) {
        this.mm_head.addUniqueObject("meta", meta);
        return this;
    }

    public void output(StringBuffer out) {
        if (this.mm_docType != null) {
            this.mm_docType.output(out);
            out.append('\n');
        }
        this.mm_html.output(out);
    }

    public void output(Writer writer) throws IOException {
        if (this.mm_docType != null) {
            this.mm_docType.output(writer);
            writer.write("\n");
        }
        this.mm_html.output(writer);
    }

    public void destroy() {
        this.mm_html.destroy();
        this.mm_html = null;
        this.mm_head = null;
        this.mm_body = null;
        this.mm_title = null;
        this.mm_meta = null;
    }
}

