/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.util.html.HtmlContainerIdentifiable;
import com.sapportals.portal.prt.util.html.IHtmlOutputable;
import com.sapportals.portal.prt.util.html.IHtmlUniqueObject;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class HtmlContainerIdentifiableWithUniqueManager
extends HtmlContainerIdentifiable {
    protected Hashtable m_uniqueObjects = new Hashtable();
    protected Vector m_uniqueObjectList = new Vector();

    public void output(StringBuffer strbuf) {
        this.outputStartTag(strbuf);
        this.outputChildren(strbuf);
        Enumeration e = this.m_uniqueObjects.elements();
        while (e.hasMoreElements()) {
            IHtmlUniqueObject hc = (IHtmlUniqueObject)e.nextElement();
            hc.getUniqueHtmlCode(strbuf);
        }
        this.outputEndTag(strbuf);
    }

    public void output(PrintWriter writer) {
        this.output((Writer)writer);
    }

    public void output(Writer writer) {
        this.outputStartTag(writer);
        this.outputChildren(writer);
        Enumeration e = this.m_uniqueObjectList.elements();
        while (e.hasMoreElements()) {
            IHtmlUniqueObject obj = (IHtmlUniqueObject)this.m_uniqueObjects.get(e.nextElement());
            if (obj == null) continue;
            obj.getUniqueHtmlCode(writer);
        }
        this.outputEndTag(writer);
    }

    public int getElementCount() {
        int count = 0;
        count = super.getElementCount();
        Enumeration e = this.m_uniqueObjects.elements();
        while (e.hasMoreElements()) {
            IHtmlUniqueObject hc = (IHtmlUniqueObject)e.nextElement();
            count += hc.getElementCount();
            ++count;
        }
        return count;
    }

    public void addUniqueObject(IHtmlUniqueObject obj) {
        if (obj.getUniqueId() == null) {
            throw new Error("[HtmlContainerIdentifiableWithUniqueManager.addUniqueObject] Cannot register an unique object which is not identified.");
        }
        this.m_uniqueObjects.put(obj.getUniqueId(), obj);
        if (!this.m_uniqueObjectList.contains(obj.getUniqueId())) {
            this.m_uniqueObjectList.addElement(obj.getUniqueId());
        }
    }

    public void addUniqueObject(String key, IHtmlOutputable obj) {
        if (key == null) {
            throw new Error("[HtmlContainerIdentifiableWithUniqueManager.addUniqueObject] Cannot register an unique object which is not identified.");
        }
        HtmlUniqueObjectFacade facade = new HtmlUniqueObjectFacade(key, obj);
        this.addUniqueObject(facade);
    }

    public void removeUniqueObject(String uniqueid) {
        if (uniqueid == null) {
            throw new Error("[HtmlContainerIdentifiableWithUniqueManager.removeUniqueObject] Cannot remove an unique object which null identifier .");
        }
        this.m_uniqueObjects.remove(uniqueid);
        this.m_uniqueObjectList.removeElement(uniqueid);
    }

    public Hashtable getUniqueObjects() {
        return this.m_uniqueObjects;
    }

    public IHtmlUniqueObject getUniqueObject(String objId) {
        return (IHtmlUniqueObject)this.m_uniqueObjects.get(objId);
    }

    public void removeAllUniqueObjects() {
        if (this.m_uniqueObjects != null) {
            Iterator iter = this.m_uniqueObjects.values().iterator();
            while (iter.hasNext()) {
                IHtmlOutputable item = (IHtmlOutputable)iter.next();
                item.destroy();
            }
            this.m_uniqueObjects.clear();
            this.m_uniqueObjectList.clear();
        }
    }

    public void destroy() {
        super.destroy();
        this.removeAllUniqueObjects();
        if (this.m_uniqueObjects != null) {
            this.m_uniqueObjects = null;
            this.m_uniqueObjectList = null;
        }
    }

    public class HtmlUniqueObjectFacade
    implements IHtmlUniqueObject {
        private IHtmlOutputable mm_htmlOutputable = null;
        private String mm_uniqueId = null;

        public HtmlUniqueObjectFacade(String id, IHtmlOutputable obj) {
            this.mm_htmlOutputable = obj;
            this.mm_uniqueId = id;
        }

        public void destroy() {
            this.mm_htmlOutputable.destroy();
            this.mm_htmlOutputable = null;
            this.mm_uniqueId = null;
        }

        public String getUniqueId() {
            return this.mm_uniqueId;
        }

        public void getUniqueHtmlCode(StringBuffer strbuf) {
            if (this.mm_htmlOutputable != null) {
                this.mm_htmlOutputable.output(strbuf);
            }
        }

        public void getUniqueHtmlCode(PrintWriter writer) {
            this.getUniqueHtmlCode((Writer)writer);
        }

        public void getUniqueHtmlCode(Writer writer) {
            if (this.mm_htmlOutputable != null) {
                this.mm_htmlOutputable.output(writer);
            }
        }

        public void output(StringBuffer strbuf) {
        }

        public void output(PrintWriter writer) {
        }

        public void output(Writer writer) {
        }

        public int getElementCount() {
            return this.mm_htmlOutputable.getElementCount();
        }
    }
}

