/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util.html;

import com.sapportals.portal.prt.runtime.PortalRuntimeException;
import com.sapportals.portal.prt.util.html.HtmlRow;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class HtmlCell
extends HtmlRow {
    protected String m_background;
    protected Integer m_colSpan;
    protected Integer m_rowSpan;
    protected String m_width;

    public HtmlCell() {
        this.setTag("td");
    }

    public void outputAttributes(StringBuffer strbuf) {
        super.outputAttributes(strbuf);
        if (this.m_width != null) {
            strbuf.append(" WIDTH=\"").append(this.m_width).append("\" ");
        }
        if (this.m_colSpan != null) {
            strbuf.append(" COLSPAN=").append(this.m_colSpan).append(" ");
        }
        if (this.m_rowSpan != null) {
            strbuf.append(" ROWSPAN=").append(this.m_rowSpan).append(" ");
        }
        if (this.m_background != null) {
            strbuf.append(" BACKGROUND=\"").append(this.m_background).append("\" ");
        }
    }

    public void outputAttributes(PrintWriter out) {
        this.outputAttributes((Writer)out);
    }

    public void outputAttributes(Writer out) {
        super.outputAttributes(out);
        try {
            if (this.m_width != null) {
                out.write(" WIDTH=\"");
                out.write(this.m_width);
                out.write("\" ");
            }
            if (this.m_colSpan != null) {
                out.write(" COLSPAN=");
                out.write(String.valueOf(this.m_colSpan));
                out.write(" ");
            }
            if (this.m_rowSpan != null) {
                out.write(" ROWSPAN=");
                out.write(String.valueOf(this.m_rowSpan));
                out.write(" ");
            }
            if (this.m_background != null) {
                out.write(" BACKGROUND=\"");
                out.write(this.m_background);
                out.write("\" ");
            }
        }
        catch (IOException e) {
            throw new PortalRuntimeException(e);
        }
    }

    public String getBackground() {
        return this.m_background;
    }

    public HtmlCell setBackground(String v) {
        this.m_background = v;
        return this;
    }

    public Integer getColSpan() {
        return this.m_colSpan;
    }

    public HtmlCell setColSpan(int v) {
        this.m_colSpan = v == 1 ? null : new Integer(v);
        return this;
    }

    public Integer getRowSpan() {
        return this.m_rowSpan;
    }

    public HtmlCell setRowSpan(int v) {
        this.m_rowSpan = v == 1 ? null : new Integer(v);
        return this;
    }

    public String getWidth() {
        return this.m_width;
    }

    public HtmlCell setWidth(String v) {
        this.m_width = v;
        return this;
    }
}

