/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.util.AbstractPool;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.SharedString;
import com.sapportals.portal.prt.util.SmartBuffer;
import com.sapportals.portal.prt.util.StringBufferPool;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    private static final int UNDEFINED_INPUT_LENGTH = -1;
    private static final String ENTITY_START = "&#";
    private static final String ENTITY_END = ";";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String AMP = "&amp;";
    private static final String EQU = "&#61;";
    private static final String DQM = "&quot;";
    private static final String SQM = "&#39;";
    private static final String DQM_JS = "\\\"";
    private static final String SQM_JS = "\\'";
    private static final String BKS_JS = "\\\\";
    private static final String SCRIPT = "script:";
    private static final int P_COLON = "script:".indexOf(58);
    private static final char COLON_REPL = ';';
    private static final String ESC_NEWLINE = "\\n";
    private static final String ESC_LINEFEED = "\\r";
    private static final String ESC_LINESEPERATOR = "\\u2028";
    private static final String ESC_PARASEPARATOR = "\\u2029";
    private static final String ESC_LT = "\\u003c";
    private static final String ESC_GT = "\\u003e";
    private static final char[] TOESCAPE_ST = new char[]{'<', '>'};
    private static final char[] TOESCAPE_HTML = new char[]{'<', '>', '&', '\'', '\"'};
    private static final char[] TOESCAPE_TAG = new char[]{'<', '>', '&', '\'', '\"', '='};
    private static final char[] TOESCAPE_URL = new char[]{'<', '>', '\'', '\"'};
    private static final char[] TOESCAPE_JS = new char[]{'<', '>', '\'', '\"', '\\', '\n', '\r', '\u2028', '\u2029'};
    private static final String[] ESCAPEWITH_ST = new String[]{"\\u003c", "\\u003e"};
    private static final String[] ESCAPEWITH_HTML = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    private static final String[] ESCAPEWITH_TAG = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;", "&#61;"};
    private static final String[] ESCAPEWITH_URL = new String[]{"&lt;", "&gt;", "&#39;", "&quot;"};
    private static final String[] ESCAPEWITH_JS = new String[]{"\\u003c", "\\u003e", "\\'", "\\\"", "\\\\", "\\n", "\\r", "\\u2028", "\\u2029"};
    private static BitSet toEscape = new BitSet();
    static boolean[] dontNeedEncoding = new boolean[256];
    static int ARRAY_SIZE;
    static boolean[] m_resetBools;
    static final String[] hex;
    protected static StringBufferPool BUFFER_POOL_URLS;
    protected static int URL_SIZE;
    private static BooleanPool BOOLEAN_POOL;

    public static String escapeToJS(String input) {
        return StringUtils.escapeToJS(input, -1);
    }

    public static String escapeToJS(String input, int maxLength) {
        return StringUtils.doEscape(input, maxLength, TOESCAPE_JS, ESCAPEWITH_JS, false);
    }

    public static String escapeToHTML(String input) {
        return StringUtils.escapeToHTML(input, -1);
    }

    public static String escapeToHTML(String input, int maxLength) {
        return StringUtils.doEscape(input, maxLength, TOESCAPE_HTML, ESCAPEWITH_HTML, true);
    }

    public static String escapeToAttributeValue(String input) {
        return StringUtils.escapeToAttributeValue(input, -1);
    }

    public static String escapeToAttributeValue(String input, int maxLength) {
        return StringUtils.doEscape(input, maxLength, TOESCAPE_TAG, ESCAPEWITH_TAG, true);
    }

    public static String escapeToURL(String input) {
        return StringUtils.escapeToURL(input, -1);
    }

    public static String escapeToURL(String input, int maxLength) {
        String cInput = StringUtils.lengthAdjust(input, maxLength);
        cInput = StringUtils.disableScriptSignatures(cInput);
        return StringUtils.doEscape(cInput, maxLength, TOESCAPE_URL, ESCAPEWITH_URL, false);
    }

    public static String escapeScriptEndTag(String pStr) {
        return StringUtils.doEscape(pStr, -1, TOESCAPE_ST, ESCAPEWITH_ST, false);
    }

    private static String lengthAdjust(String input, int maxLength) {
        if (input != null && maxLength > -1 && maxLength < input.length()) {
            return input.substring(0, maxLength);
        }
        return input;
    }

    private static String decodeEntities(String input) {
        StringBuffer buffy = new StringBuffer(input.length());
        String cInput = input.toLowerCase();
        int a = 0;
        int i = 0;
        while (i >= 0) {
            int e = -1;
            i = cInput.indexOf(ENTITY_START, a);
            if (i < 0) continue;
            int j = cInput.indexOf(ENTITY_END, i);
            if (j >= 0) {
                int iBase;
                String cSub = cInput.substring(i + 2, j);
                if (cSub.charAt(0) == 'x') {
                    cSub = cSub.substring(1);
                    iBase = 16;
                } else {
                    iBase = 10;
                }
                try {
                    e = Integer.parseInt(cSub, iBase);
                }
                catch (NumberFormatException nfe) {
                    e = -1;
                }
            }
            if (e > 0 && e < 65536) {
                buffy.append(input.substring(a, i)).append((char)e);
                a = j + 1;
                continue;
            }
            a = i + 1;
        }
        buffy.append(input.substring(a));
        return buffy.toString();
    }

    private static String removeWhitespace(String input) {
        StringBuffer buffy = new StringBuffer(input.length());
        if (input != null) {
            int i = 0;
            while (i < input.length()) {
                char chr = input.charAt(i);
                if (chr == ' ' || chr > ' ' && !Character.isWhitespace(chr)) {
                    buffy.append(input.charAt(i));
                }
                ++i;
            }
        }
        return buffy.toString();
    }

    private static String disableScriptSignatures(String input) {
        String decodedInput = StringUtils.decodeEntities(input);
        String canonicalInput = StringUtils.removeWhitespace(decodedInput);
        StringBuffer safeData = new StringBuffer(canonicalInput);
        String tempData = canonicalInput.toLowerCase();
        int i = 0;
        while (i >= 0) {
            if ((i = tempData.indexOf(SCRIPT, i)) < 0) continue;
            safeData.setCharAt(i += P_COLON, ';');
            ++i;
        }
        return safeData.toString();
    }

    private static String doEscape(String input, int maxLength, char[] toEscape, String[] escapeWith, boolean handleEntities) {
        if (input != null && toEscape != null && escapeWith != null) {
            StringBuffer buffy = new StringBuffer(input.length() << 1);
            String sIn = StringUtils.lengthAdjust(input, maxLength);
            int l = sIn.length();
            int i = 0;
            while (i < l) {
                char chr = sIn.charAt(i);
                if (handleEntities && chr >= '\u007f') {
                    buffy.append(StringUtils.encodeToEntity(chr));
                } else {
                    int j = 0;
                    while (j < toEscape.length) {
                        if (chr == toEscape[j]) {
                            buffy.append(escapeWith[j]);
                            break;
                        }
                        ++j;
                    }
                    if (j >= toEscape.length) {
                        buffy.append(chr);
                    }
                }
                ++i;
            }
            return buffy.toString();
        }
        return null;
    }

    private static String encodeToEntity(char chr) {
        StringBuffer result = new StringBuffer(7);
        result.append(ENTITY_START);
        result.append((int)chr);
        result.append(ENTITY_END);
        return result.toString();
    }

    private static SharedString encodeUTF8(String s, char[] forceEncode) {
        int i;
        RecyclableStringBuffer rbuf = BUFFER_POOL_URLS.get(URL_SIZE);
        SmartBuffer sbuf = rbuf.getBuffer();
        int len = s.length();
        boolean[] toBeEncoded = null;
        if (forceEncode != null && forceEncode.length > 0) {
            toBeEncoded = BOOLEAN_POOL.get();
            i = 0;
            while (i < forceEncode.length) {
                toBeEncoded[forceEncode[i]] = true;
                ++i;
            }
        }
        i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (toBeEncoded != null && toBeEncoded[ch]) {
                sbuf.append(hex[ch]);
            } else if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
            } else if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
            } else if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
            } else if (ch == ' ') {
                sbuf.append('+');
            } else if (ch == '-' || ch == '_' || ch == '.' || ch == '!' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')') {
                sbuf.append(ch);
            } else if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
            } else if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            } else {
                sbuf.append(hex[0xE0 | ch >> 12]);
                sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
            }
            ++i;
        }
        SharedString strUrl = rbuf.getSharedString();
        BUFFER_POOL_URLS.release(rbuf);
        BOOLEAN_POOL.releasePoolObject(toBeEncoded);
        return strUrl;
    }

    public static String urlEncode(String s, char[] forceEncode) {
        SharedString ss = StringUtils.encodeUTF8(s, forceEncode);
        String result = new String(ss.getChars(), 0, ss.length());
        ss.release();
        return result;
    }

    public static SharedString urlEncodeShared(String s, char[] forceEncode) {
        return StringUtils.encodeUTF8(s, forceEncode);
    }

    public static String urlEncode(String s) {
        return StringUtils.urlEncode(s, null);
    }

    public static String[] tokenize(String szInput, String szDelim) {
        List l = StringUtils.tokenizeInList(szInput, szDelim);
        String[] array = new String[l.size()];
        String[] res = l.toArray(array);
        return res;
    }

    public static List tokenizeInList(String szInput, String szDelim) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(szInput, szDelim);
        while (t.hasMoreTokens()) {
            l.add(t.nextToken());
        }
        return l;
    }

    public static String[] tokenize(String szInput, char delimiter) {
        List l = StringUtils.tokenizeInList(szInput, delimiter);
        String[] array = new String[l.size()];
        String[] res = l.toArray(array);
        return res;
    }

    public static List tokenizeInList(String szInput, char delimiter) {
        ArrayList<String> l;
        block6: {
            l = new ArrayList<String>();
            int begin = 0;
            int end = szInput.indexOf(delimiter, 0);
            int length = szInput.length();
            if (length == 0) {
                return l;
            }
            do {
                if (begin != end) {
                    if (end == -1 && begin == 0) {
                        l.add(szInput.substring(begin));
                    } else {
                        l.add(szInput.substring(begin, end));
                    }
                }
                if (end == -1) break block6;
            } while ((end = szInput.indexOf(delimiter, begin = end + 1)) != -1);
            if (begin != length) {
                l.add(szInput.substring(begin));
            }
        }
        return l;
    }

    static {
        int i = 97;
        while (i <= 122) {
            StringUtils.dontNeedEncoding[i] = true;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            StringUtils.dontNeedEncoding[i] = true;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            StringUtils.dontNeedEncoding[i] = true;
            ++i;
        }
        StringUtils.dontNeedEncoding[32] = true;
        StringUtils.dontNeedEncoding[45] = true;
        StringUtils.dontNeedEncoding[95] = true;
        StringUtils.dontNeedEncoding[46] = true;
        StringUtils.dontNeedEncoding[42] = true;
        char[] toBeEscaped = new char[]{'\'', '\"', '&', '<', '>', '+', '\u00a9', '\u00ae', '\u00b6', '\u00bc', '\u00bd', '\u00be'};
        i = 0;
        while (i < toBeEscaped.length) {
            toEscape.set(toBeEscaped[i]);
            ++i;
        }
        ARRAY_SIZE = 256;
        m_resetBools = new boolean[ARRAY_SIZE];
        i = 0;
        while (i < ARRAY_SIZE) {
            StringUtils.m_resetBools[i] = false;
            ++i;
        }
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
        URL_SIZE = 3000;
        BUFFER_POOL_URLS = StringBufferPool.createInstance("com.sap.portal.utils.encoding.pool.urls", 0, 0, 128);
        BOOLEAN_POOL = new BooleanPool(256, 100, 0, 100);
    }

    private static class BooleanPool
    extends AbstractPool {
        private int mm_arraySize;

        BooleanPool(int arraySize, int initialCapacity, int nbInitialInstance, int maxNumberObjects) {
            super(initialCapacity, nbInitialInstance, maxNumberObjects);
            this.mm_arraySize = arraySize;
        }

        boolean[] get() {
            boolean[] b = null;
            try {
                b = (boolean[])this.getPoolObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return b;
        }

        public Object createPoolObject() throws Exception {
            return new boolean[this.mm_arraySize];
        }

        public boolean validatePoolObject(Object o) {
            System.arraycopy(m_resetBools, 0, o, 0, ARRAY_SIZE);
            return true;
        }

        public void expirePoolObject(Object o) {
        }
    }
}

