/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.util;

import com.sapportals.portal.prt.component.AbstractPortalComponent;
import com.sapportals.portal.prt.component.IPortalComponentProfile;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.component.IPortalComponentURI;
import com.sapportals.portal.prt.event.IPortalRequestEvent;
import com.sapportals.portal.prt.event.IPortalRequestEventData;
import com.sapportals.portal.prt.pom.NodeMode;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.util.StringUtils;
import com.sapportals.portal.prt.util.html.HtmlBr;
import com.sapportals.portal.prt.util.html.HtmlCell;
import com.sapportals.portal.prt.util.html.HtmlCol;
import com.sapportals.portal.prt.util.html.HtmlColGroup;
import com.sapportals.portal.prt.util.html.HtmlContainer;
import com.sapportals.portal.prt.util.html.HtmlDiv;
import com.sapportals.portal.prt.util.html.HtmlForm;
import com.sapportals.portal.prt.util.html.HtmlOption;
import com.sapportals.portal.prt.util.html.HtmlRow;
import com.sapportals.portal.prt.util.html.HtmlSelect;
import com.sapportals.portal.prt.util.html.HtmlSpan;
import com.sapportals.portal.prt.util.html.HtmlString;
import com.sapportals.portal.prt.util.html.HtmlTable;
import com.sapportals.portal.prt.util.html.HtmlTextInput;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class StandardEditDialog
extends AbstractPortalComponent {
    private final String PROPERTY_TYPE_SELECT = "select[";
    private final String PROPERTY_TYPE_BOOLEAN = "boolean";

    protected void doContent(IPortalComponentRequest request, IPortalComponentResponse response) {
        response.write("This component should only be used to generate personalization dialogues.");
    }

    protected void doEdit(IPortalComponentRequest request, IPortalComponentResponse response) {
        String lsUser = request.getUser().getLogonUid();
        ResourceBundle portalBundle = null;
        try {
            portalBundle = PortalRuntime.getRuntimeResources().getPortalBundle(request.getLocale());
        }
        catch (Exception e) {
            // empty catch block
        }
        String headMessage = null;
        String explanation = null;
        String descHead = null;
        String valueHead = null;
        String noAuthMsg = null;
        String noPropMsg = null;
        String saveButton = null;
        String defaultButton = null;
        String cancelButton = null;
        if (portalBundle != null) {
            try {
                headMessage = portalBundle.getString("STD_PERS_HEAD_MESSAGE");
                explanation = portalBundle.getString("STD_PERS_EXPLANATION");
                descHead = portalBundle.getString("STD_PERS_DESCRIPTIONHEAD");
                valueHead = portalBundle.getString("STD_PERS_VALUEHEAD");
                noAuthMsg = portalBundle.getString("STD_PERS_NO_AUTH");
                noPropMsg = portalBundle.getString("STD_PERS_NO_PROP");
                saveButton = portalBundle.getString("STD_PERS_SAVE");
                defaultButton = portalBundle.getString("STD_PERS_DEFAULT");
                cancelButton = portalBundle.getString("STD_PERS_CANCEL");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        IPortalComponentProfile profile = request.getComponentContext().getProfile();
        IPortalRequestEvent event = request.createRequestEvent("handleEditData");
        HtmlContainer topContainer = new HtmlContainer();
        topContainer.setClass("prtlBody");
        HtmlSpan titlespan = new HtmlSpan();
        topContainer.addElement(titlespan);
        titlespan.setClass("gSAPGroupHeader");
        titlespan.setStyle("width: 100%");
        titlespan.addElement("<LEFT>");
        String iviewtitle = "";
        if (request.getComponentContext().getProfile().getProperty("title") != null) {
            iviewtitle = request.getComponentContext().getProfile().getProperty("title");
        } else if (request.getComponentContext().getProfile().getProperty("Title") != null) {
            iviewtitle = request.getComponentContext().getProfile().getProperty("Title");
        }
        titlespan.addElement(MessageFormat.format(iviewtitle, iviewtitle));
        titlespan.addElement("</LEFT>");
        HtmlDiv propDiv = new HtmlDiv();
        topContainer.addElement(propDiv);
        HtmlSpan helpspan = new HtmlSpan();
        helpspan.setClass("gSAPP");
        helpspan.addElement(explanation);
        propDiv.addElement(new HtmlBr());
        HtmlForm editForm = new HtmlForm();
        editForm.setMethod(HtmlForm.FormMethod.POST);
        IPortalComponentURI uri = request.createPortalComponentURI();
        uri.setPortalRequestEvent(event);
        editForm.setAction(uri.toString());
        HtmlDiv innerDiv = new HtmlDiv();
        editForm.addElement(innerDiv);
        innerDiv.setStyle("width: 100%");
        boolean hasAtLeastOnePropertyToCustomize = false;
        Enumeration propEnum = profile.getProperties();
        HtmlTable propTable = null;
        if (propEnum != null && lsUser != null) {
            String name;
            propTable = new HtmlTable();
            propTable.setWidth("100%");
            propTable.addElement("<LEFT>");
            propTable.addElement(new HtmlColGroup().addElement(new HtmlCol().setWidth("35%")).addElement(new HtmlCol().setWidth("65%")));
            HtmlRow headRow = new HtmlRow();
            propTable.addElement(headRow);
            headRow.addElement("<td class=gsapb>" + descHead + "</td><td class=gsapb>" + valueHead + "</td>");
            HtmlRow proprow = null;
            HtmlCell propCellName = null;
            HtmlCell propCellValue = null;
            ResourceBundle bundle = null;
            try {
                bundle = request.getResourceBundle();
            }
            catch (Exception e) {
                // empty catch block
            }
            NameComparator comparator = new NameComparator(profile);
            Vector<BeautifulPropertyName> properties = new Vector<BeautifulPropertyName>();
            while (propEnum.hasMoreElements()) {
                name = (String)propEnum.nextElement();
                if (!profile.isPersonalizableProperty(name)) continue;
                properties.add(new BeautifulPropertyName(profile, bundle, name));
            }
            Collections.sort(properties, comparator);
            propEnum = properties.elements();
            while (propEnum.hasMoreElements()) {
                BeautifulPropertyName bpn = (BeautifulPropertyName)propEnum.nextElement();
                name = bpn.getPropertyName();
                String desc = bpn.getBeautifulName();
                String value = profile.getProperty(name);
                proprow = new HtmlRow();
                propTable.addElement(proprow);
                propTable.addElement("</LEFT>");
                propCellName = new HtmlCell();
                propCellName.setClass("gSAPP");
                proprow.addElement(propCellName);
                propCellName.addElement(StringUtils.escapeToHTML(desc));
                hasAtLeastOnePropertyToCustomize = true;
                propCellValue = new HtmlCell();
                proprow.addElement(propCellValue);
                String propertyType = profile.getPropertyAttribute(name, "type");
                if (propertyType == null) {
                    propertyType = "string";
                }
                if (propertyType.startsWith("select[")) {
                    String values = propertyType.substring("select[".length(), propertyType.length() - 1);
                    HtmlSelect htmlSelect = this.generateSelectBox(name, value, values);
                    propCellValue.addElement(htmlSelect);
                    continue;
                }
                if (propertyType.equals("boolean")) {
                    HtmlSelect htmlSelect = this.generateBooleanSelectBox(name, value);
                    propCellValue.addElement(htmlSelect);
                    continue;
                }
                HtmlTextInput textInput = new HtmlTextInput();
                propCellValue.addElement(textInput);
                textInput.setClass("gSAPInputText");
                textInput.setStyle("width: 100% ; ");
                textInput.setName(name);
                textInput.setValue(value);
            }
        }
        if (hasAtLeastOnePropertyToCustomize && lsUser != null) {
            propDiv.addElement(helpspan);
            propDiv.addElement(editForm);
            innerDiv.addElement(propTable);
            innerDiv.addElement("<br><br><input class=gsapinputbutton type=\"submit\" name=\"save\" value=\"" + saveButton + "\">");
        } else if (lsUser != null) {
            propDiv.addElement(editForm);
            innerDiv.addElement("<br><br><span class=gsapb style=\"color: blue\">" + noPropMsg + "</span><br><br>");
        } else {
            propDiv.addElement(editForm);
            innerDiv.addElement("<br><br><span class=gsapb style=\"color: blue\">" + noAuthMsg + "</span><br><br>");
        }
        innerDiv.addElement("&nbsp;&nbsp;<input class=gsapinputbutton type=\"submit\" name=\"cancel\" value=\"" + cancelButton + "\">");
        if (hasAtLeastOnePropertyToCustomize && lsUser != null) {
            innerDiv.addElement("&nbsp;&nbsp;<input class=gsapinputbutton type=\"submit\" name=\"default\" value=\"" + defaultButton + "\">");
        }
        innerDiv.addElement(" </DIV>");
        response.write(topContainer.toString());
    }

    public void doHandleEditData(IPortalComponentRequest request, IPortalRequestEvent event) {
        Enumeration allProps;
        boolean doDefault;
        IPortalRequestEventData data = event.getData();
        boolean doSave = data.getAttribute("save") != null;
        boolean bl = doDefault = data.getAttribute("default") != null;
        if ((doSave || doDefault) && (allProps = data.getAttributesEnumeration()) != null && allProps.hasMoreElements()) {
            IPortalComponentProfile profile = request.getComponentContext().getProfile();
            while (allProps.hasMoreElements()) {
                String name = (String)allProps.nextElement();
                if (name == null || name.equalsIgnoreCase("save") || name.equalsIgnoreCase("default")) continue;
                if (doSave) {
                    String value = data.getAttribute(name);
                    if (value == null) continue;
                    profile.setProperty(name, value);
                    continue;
                }
                if (!doDefault) continue;
                profile.resetProperty(name);
            }
            profile.store();
            request.getNode().setNodeMode(NodeMode.REFRESH_MODE);
        }
    }

    public HtmlSelect generateSelectBox(String name, String currentValue, String listOfValues) {
        HtmlSelect selectInput = new HtmlSelect();
        selectInput.setClass("gsapinputtext");
        selectInput.setStyle("width: 100%");
        selectInput.setName(name);
        Vector values = StandardEditDialog.getListOfValues(listOfValues);
        if (values != null && values.size() > 0) {
            int i = 0;
            while (i < values.size()) {
                String value = (String)values.get(i);
                HtmlOption option = new HtmlOption(value);
                if (currentValue.equals(value)) {
                    option.setSelected(true);
                }
                selectInput.addElement(option);
                selectInput.addElement(new HtmlString(StringUtils.escapeToHTML(value)));
                ++i;
            }
        }
        return selectInput;
    }

    public HtmlSelect generateBooleanSelectBox(String name, String value) {
        HtmlSelect selectInput = new HtmlSelect();
        selectInput.setClass("gsapinputtext");
        selectInput.setStyle("width: 100%");
        selectInput.setName(name);
        HtmlOption TRUE = new HtmlOption("true");
        HtmlOption FALSE = new HtmlOption("false");
        TRUE.setValue("true");
        FALSE.setValue("false");
        if (value.equals("1") || value.equalsIgnoreCase("Yes") || value.equalsIgnoreCase("true")) {
            TRUE.setSelected(true);
        } else {
            FALSE.setSelected(true);
        }
        selectInput.addElement(TRUE);
        selectInput.addElement(new HtmlString(TRUE.getValue()));
        selectInput.addElement(FALSE);
        selectInput.addElement(new HtmlString(FALSE.getValue()));
        return selectInput;
    }

    public static Vector getListOfValues(String values) {
        Vector<String> vector = new Vector<String>();
        StringBuffer buffer = new StringBuffer(values.length());
        StringBuffer value = new StringBuffer();
        buffer.append(values);
        boolean pos = false;
        boolean escapeMode = false;
        int i = 0;
        while (i < buffer.length()) {
            if (!escapeMode && buffer.charAt(i) == '\\') {
                escapeMode = true;
            } else if (!escapeMode && buffer.charAt(i) == ',') {
                vector.add(value.toString());
                value.setLength(0);
            } else {
                value.append(buffer.charAt(i));
                escapeMode = false;
            }
            ++i;
        }
        if (value.length() > 0) {
            vector.add(value.toString());
        }
        return vector;
    }

    private class NameComparator
    implements Comparator {
        IPortalComponentProfile mm_profile = null;

        public NameComparator(IPortalComponentProfile profile) {
            this.mm_profile = profile;
        }

        public int compare(Object o1, Object o2) {
            return ((BeautifulPropertyName)o1).getBeautifulName().compareToIgnoreCase(((BeautifulPropertyName)o2).getBeautifulName());
        }

        public boolean equals(Object obj) {
            return false;
        }
    }

    private class BeautifulPropertyName {
        String mm_propertyName = null;
        String mm_description = null;

        BeautifulPropertyName(IPortalComponentProfile profile, ResourceBundle bundle, String propertyName) {
            this.mm_propertyName = propertyName;
            String descToken = profile.getPropertyAttribute(this.mm_propertyName, "description");
            try {
                if (bundle != null && descToken != null) {
                    this.mm_description = bundle.getString(descToken);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.mm_description == null) {
                this.mm_description = profile.getPropertyAttribute(this.mm_propertyName, "plainDescription");
            }
            if (this.mm_description == null) {
                this.mm_description = this.mm_propertyName;
            }
        }

        public String getBeautifulName() {
            if (this.mm_description != null) {
                return this.mm_description;
            }
            return this.mm_propertyName;
        }

        public String getPropertyName() {
            return this.mm_propertyName;
        }
    }
}

